/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.autochanger.ui;


import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.bus.Agent;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUISubsystem;

/**
 *
 * @author virieux
 */
public class AutochangerGUI extends GeneralGUISubsystem {
    private long lastHeartBeat = 0, lastStateRequest = 0;
    String stateCorrelId;
    
    private static final String trucksModuleName = "autochangerTrucks";
    private static final String onlineModuleName = "onlineClamp";
    
    final long updateTrucksPositionTimeout;
    long timeoutForTrucksMotion;

    public AutochangerGUI(String name, Agent.AgentType type, String destination) {
        super(name, type, destination);
        this.topPanel = new AutochangerTopPanel(this);
        pane = new JScrollPane(topPanel);
        this.updateTrucksPositionTimeout = 1000;
        this.timeoutForTrucksMotion = 0;
    }

    public void setTimeoutForTrucksMotion(long timeoutForTrucksMotion) {
        this.timeoutForTrucksMotion = timeoutForTrucksMotion;
    }
    
    
    
    @Override
    public void onReply(CommandReply s) {
        //FIXME temporary fix to prevent multiple GUIs from interfering with each other.
        //See https://jira.slac.stanford.edu/browse/LSSTCCS-9
        if (s.getCorrelId().equals(stateCorrelId)) {
            //This is the first Status Message after the GUI has started
            AutochangerConfig config = (AutochangerConfig) s.getReply();

            fcslog.debug(getName() + "--- Got a reply from subs");
            ((AutochangerTopPanel)topPanel).initializeGui(config);
            initialized = true;
        }
    }

    @Override
    public void onDataArrival(String source, long timestamp, String dataType, Object s) {
        //If this data status is not for us we forget it.
        if (!source.equals(destination)) {
            return;
        }
        if (initialized) {
            switch (dataType) {
                    
                case "tcpProxy":
                    fcslog.debug(getName() + " read data dataType:tcpProxy");
                    ((AutochangerTopPanel)topPanel).updateCanOpenHardwarePanel((StatusDataPublishedByHardware) s);
                    lastHeartBeat = timestamp;
                    break; 
                    
                case "autochangerGeneral":
                    fcslog.debug(getName() + " read data dataType:autochangerGeneral");
                    ((AutochangerTopPanel)topPanel).updateAutochanger((StatusDataPublishedByAutoChanger) s);
                    lastHeartBeat = timestamp;
                    break;

                case "linearRailMasterController":
                    fcslog.debug(getName() + " read data dataType:linearRailMasterController");
                    ((AutochangerTopPanel)topPanel).updateLinearRailMasterController((StatusDataPublishedByEPOSController) s);
                    lastHeartBeat = timestamp;
                    break;

                case "linearRailSlaveController":
                    fcslog.debug(getName() + " read data dataType:linearRailSlaveController");
                    ((AutochangerTopPanel)topPanel).updateLinearRailSlaveController((StatusDataPublishedByEPOSController) s);
                    lastHeartBeat = timestamp;
                    break;
                    
                case "latchXminusController":
                    fcslog.debug(getName() + " read data dataType:latchXminusController");
                    ((AutochangerTopPanel)topPanel).updateLatchXminusController((StatusDataPublishedByEPOSController) s);
                    lastHeartBeat = timestamp;
                    break;    

                case "latchXplusController":
                    fcslog.debug(getName() + " read data dataType:latchXplusController");
                    ((AutochangerTopPanel)topPanel).updateLatchXplusController((StatusDataPublishedByEPOSController) s);
                    lastHeartBeat = timestamp;
                    break;
                    
                case "onlineClampController":
                    fcslog.debug(getName() + " read data dataType:onlineClampController");
                    ((AutochangerTopPanel)topPanel).updateOnlineClampController((StatusDataPublishedByEPOSController) s);
                    lastHeartBeat = timestamp;
                    break;
                   
                case "autochangerTrucks":
                    fcslog.debug(getName() + " read data dataType:autochangerTrucks");
                    fcslog.finest(getName() + " Data published by Trucks= " + ((StatusDataPublishedByAutoChangerTrucks)s).toString());
                    ((AutochangerTopPanel)topPanel).updateTrucks((StatusDataPublishedByAutoChangerTrucks) s);
                    lastHeartBeat = timestamp;
                    break;  
                
                case "autochangerLatch":
                    fcslog.debug(getName() + " read data dataType:autochangerLatch");
                    fcslog.finest(getName() + " Data published by Latch= " + ((StatusDataPublishedByAutochangerLatch)s).toString());
                    ((AutochangerTopPanel)topPanel).updateLatch((StatusDataPublishedByAutochangerLatch) s);
                    lastHeartBeat = timestamp;
                    break;                    
                   
                case "autochangerLatches":
                    fcslog.debug(getName() + " read data dataType:autochangerLatches");
                    fcslog.debug(getName() + " Data published by Latches= " + ((StatusDataPublishedByAutochangerTwoLatches)s).toString());
                    ((AutochangerTopPanel)topPanel).updateLatches((StatusDataPublishedByAutochangerTwoLatches) s);
                    lastHeartBeat = timestamp;
                    break;
                    
                default:
                    fcslog.warning(getName() + " An unexpected dataType was read on the status bus:" + dataType);
                    break;
            }
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastStateRequest > 2000) {
                lastStateRequest = currentTime;
                ModuleInvokerCommand cmd = new ModuleInvokerCommand("getFullState");
                sendAsynchronousCommand(cmd);
                stateCorrelId = cmd.getCorrelId();
            }
        }
    }    
    
     /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        AutochangerGUI t = new AutochangerGUI("AutochangerGUI",
                Agent.AgentType.CONSOLE,
                "testbenchCPPM");

        JFrame frame = new JFrame("Autochanger View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

    void updateTrucksPosition() {
        System.out.println("Autochanger updating Trucks position");
        fcslog.info("Autochanger updating Trucks position");
        fcslog.info("/timeout=" + updateTrucksPositionTimeout);
        new CommandSwingWorker("updatePosition",this.updateTrucksPositionTimeout, trucksModuleName).execute();
    }

    void goToHandOff() {
        System.out.println("Autochanger Trucks going to Handoff position");
        fcslog.info("Autochanger Trucks going to Handoff Position");
        fcslog.info("/timeout=" + timeoutForTrucksMotion);
        new CommandSwingWorker("goToHandOff",this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    void goToStandby() {
        System.out.println("Autochanger Trucks going to Standby position");
        fcslog.info("Autochanger Trucks going to Standby Position");
        fcslog.info("/timeout=" + timeoutForTrucksMotion);
        new CommandSwingWorker("goToStandby",this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    void goToOnline() {
        System.out.println("Autochanger Trucks going to Online position");
        fcslog.info("Autochanger Trucks going to Online Position");
        fcslog.info("/timeout=" + timeoutForTrucksMotion);
        new CommandSwingWorker("goToOnline",this.timeoutForTrucksMotion, trucksModuleName).execute();
    }
    
}
