/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenHardwarePanel;

public class TreePanel
extends JPanel
implements TreeSelectionListener {
    final String title;
    JTree tree;
    JPanel rightPanel;
    JSplitPane splitPane = new JSplitPane(1);
    JPanel helpPanel;

    public TreePanel(String title) {
        this.title = title;
        this.initComponents();
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), this.title));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(this.title);
        this.createNodes(top);
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        JScrollPane treeView = new JScrollPane(this.tree);
        this.splitPane.setLeftComponent(treeView);
        this.rightPanel = new JPanel();
        JScrollPane rightScrollPane = new JScrollPane(this.rightPanel);
        this.splitPane.setRightComponent(this.rightPanel);
        Dimension minimumSize = new Dimension(1200, 900);
        rightScrollPane.setMinimumSize(minimumSize);
        treeView.setMinimumSize(new Dimension(200, 900));
        this.splitPane.setDividerLocation(200);
        this.splitPane.setPreferredSize(new Dimension(1200, 900));
        this.add(this.splitPane);
        this.helpPanel = new JPanel();
        JLabel helpLabel = new JLabel("Nothing to display");
        this.helpPanel.add(helpLabel);
    }

    private void displayPanel(JPanel panel) {
        if (panel != null) {
            JScrollPane scrollPane = new JScrollPane(panel);
            this.splitPane.setRightComponent(scrollPane);
        } else {
            JScrollPane scrollPane = new JScrollPane(this.helpPanel);
            this.splitPane.setRightComponent(scrollPane);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (nodeInfo == null) {
            return;
        }
        if (node.isLeaf()) {
            JPanel panel = (JPanel)nodeInfo;
            this.displayPanel(panel);
        }
    }

    private void createNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode devicesNode = new DefaultMutableTreeNode("CANopen devices");
        devicesNode.add(new DefaultMutableTreeNode(new CanOpenHardwarePanel()));
        top.add(devicesNode);
        top.add(new DefaultMutableTreeNode(new HardwarePanel("hardware1")));
        top.add(new DefaultMutableTreeNode(new HardwarePanel("hardware2")));
        top.add(new DefaultMutableTreeNode(new HardwarePanel("hardware3")));
    }

    public static void main(String[] argv) {
        TreePanel d = new TreePanel("FCS");
        JFrame frame = new JFrame("Subsystem Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public class HardwarePanel
    extends JPanel {
        String title;
        JLabel label;

        public HardwarePanel(String title) {
            this.title = title;
            this.label = new JLabel("My beautiful hardware has title:" + title);
            this.add(this.label);
        }

        @Override
        public String toString() {
            return this.title;
        }
    }
}

