/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.HeadlessException;
import java.io.PrintWriter;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import org.freehep.graphicsbase.swing.ErrorDialog;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandError;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.bus.messages.StateChangeNotification;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.DataStatusListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.TopPanel;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class GeneralGUI
implements DataStatusListener,
StatusMessageListener,
AgentPresenceListener {
    protected static final Logger fcslog = Tools.fcslog;
    protected final String destination;
    protected PrintWriter out = new PrintWriter(System.out, true);
    protected TopPanel topPanel;
    protected boolean initialized = false;
    protected boolean panelStateInitialized = false;
    public JScrollPane pane;
    public long abortTimeout;
    public long updateStateWithSensorsTimeout;
    private String name;
    protected AgentMessagingLayer aml;
    public long initializationTimeout;

    public GeneralGUI(String name, String destination, AgentMessagingLayer aml) {
        this.aml = aml;
        this.name = name;
        this.destination = destination;
        this.abortTimeout = 1000L;
        this.updateStateWithSensorsTimeout = 1000L;
        this.initializationTimeout = 2000L;
    }

    public String getName() {
        return this.name;
    }

    public void initGui() {
        this.aml.addStatusMessageListener((StatusMessageListener)this);
        fcslog.info((Object)(String.valueOf(this.name) + ":initGUI"));
        this.postInitGui();
    }

    public void postInitGui() {
        if (this.aml.getAgentPresenceManager().agentExists(this.destination)) {
            fcslog.warning((Object)(String.valueOf(this.destination) + " is already connected."));
            this.sendAsynchronousCommand(new CommandRequest(this.destination, "updateStateWithSensors"));
        }
        this.aml.getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
    }

    public JComponent getGuiLayout() {
        return this.pane;
    }

    public void resetGui() {
        this.topPanel.resetPanel();
    }

    public void shutdownMyDestinationSubsystem() {
        System.out.println("Shutting down " + this.destination);
        new CommandSwingWorker("shutdown", this.abortTimeout).execute();
    }

    public void abortAction() {
        System.out.println("Aborting " + this.destination);
        new CommandSwingWorker("abort", this.abortTimeout).execute();
    }

    public void stopMyDestinationSubsystem() {
        System.out.println("Stopping " + this.destination);
        this.sendAsynchronousCommand(new CommandRequest(this.destination, "stop", new Object[]{1000L}));
    }

    public void updateStateWithSensors() {
        fcslog.info((Object)"Reading sensors");
        fcslog.info((Object)("/timeout=" + this.updateStateWithSensorsTimeout));
        new CommandSwingWorker("updateStateWithSensors", this.updateStateWithSensorsTimeout).execute();
    }

    public void completeInitialization() {
        fcslog.info((Object)"Reading sensors");
        fcslog.info((Object)("/timeout=" + this.initializationTimeout));
        new CommandSwingWorker("completeInitialization", this.initializationTimeout).execute();
    }

    public void sendCommandSwingWorker(String commandName, long timeout, String moduleName) {
        fcslog.info((Object)(String.valueOf(this.getName()) + ": sending command= " + commandName + " to Module=" + moduleName));
        new CommandSwingWorker(commandName, timeout, moduleName).execute();
    }

    public void sendCommandSwingWorker(String commandName, long timeout) {
        fcslog.info((Object)(String.valueOf(this.getName()) + ": sending command= " + commandName));
        new CommandSwingWorker(commandName, timeout).execute();
    }

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    public void sendAsynchronousCommand(CommandRequest cmd) {
        this.aml.sendCommandRequest(cmd, new CommandOriginator(){

            public void processAck(CommandAck ack) {
            }

            public void processResult(CommandResult result) {
            }

            public void processNack(CommandNack nack) {
            }

            public void processError(CommandError nack) {
            }
        });
    }

    public Object sendCommand(CommandRequest cmd, long timeout) {
        try {
            fcslog.debug((Object)("fac=" + String.valueOf(this.aml)));
            SynchronousCommandAgent agent = new SynchronousCommandAgent(this.aml);
            fcslog.debug((Object)("agent=" + String.valueOf(agent)));
            fcslog.debug((Object)("command=" + String.valueOf(cmd)));
            Object response = agent.invoke(cmd, timeout);
            String strRes = String.valueOf(response);
            fcslog.debug((Object)("strRes=" + strRes));
            if (response == null) {
                strRes = "ok : DONE";
                return "ok : DONE";
            }
            strRes = String.valueOf(response);
            return strRes;
        }
        catch (Exception ex) {
            return ex;
        }
    }

    public void onStatusMessage(StatusMessage s) {
        if (!s.getOriginAgentInfo().getName().equals(this.destination)) {
            return;
        }
        if (!this.panelStateInitialized) {
            this.topPanel.getSubsystemPanel().updateState(s.getState());
            this.panelStateInitialized = true;
        } else {
            if (!(s instanceof StateChangeNotification)) {
                return;
            }
            this.topPanel.getSubsystemPanel().updateState(s.getState());
        }
    }

    public void connecting(AgentInfo agent) {
        if (agent.getName().equals(this.destination)) {
            fcslog.warning((Object)(String.valueOf(this.destination) + " is connecting NOW"));
            this.sendAsynchronousCommand(new CommandRequest(this.destination, "updateStateWithSensors"));
        }
    }

    public void disconnecting(AgentInfo agent) {
        this.resetGui();
    }

    public class CommandSwingWorker
    extends SwingWorker<Object, Object> {
        String cmdDestination;
        String cmdName;
        long cmdTimeout;

        public CommandSwingWorker(String cmdN, long timeout) {
            if (cmdN == null) {
                throw new IllegalArgumentException("Command should not be null in CommandSwingWorker");
            }
            if (timeout == 0L) {
                throw new IllegalArgumentException("timeout should not be equal to 0 in CommandSwingWorker");
            }
            this.cmdDestination = GeneralGUI.this.destination;
            this.cmdName = cmdN;
            this.cmdTimeout = timeout;
        }

        public CommandSwingWorker(String cmdN, long timeout, String moduleName) {
            if (cmdN == null) {
                throw new IllegalArgumentException("Command should not be null in CommandSwingWorker");
            }
            if (timeout == 0L) {
                throw new IllegalArgumentException("timeout should not be equal to 0 in CommandSwingWorker");
            }
            if (moduleName == null) {
                throw new IllegalArgumentException("moduleName should not be null in this constructor of CommandSwingWorker");
            }
            this.cmdDestination = String.valueOf(GeneralGUI.this.destination) + "/" + moduleName;
            this.cmdName = cmdN;
            this.cmdTimeout = timeout;
        }

        @Override
        public Object doInBackground() {
            fcslog.info((Object)("Executing " + this.cmdName + " on " + this.cmdDestination));
            fcslog.info((Object)("/timeout=" + this.cmdTimeout));
            return GeneralGUI.this.sendCommand(new CommandRequest(this.cmdDestination, this.cmdName), this.cmdTimeout);
        }

        @Override
        protected void done() {
            try {
                Object response = this.get();
                if (response instanceof Throwable) {
                    fcslog.error((Object)String.valueOf(response));
                    fcslog.error((Object)" command returned error", (Throwable)response);
                    ErrorDialog.showErrorDialog(null, (Object)response.toString(), (Throwable)((Throwable)response));
                } else if (response == null) {
                    String strRes = "ok : DONE";
                    JOptionPane.showMessageDialog(null, strRes, this.cmdName, 1);
                } else {
                    String strRes = String.valueOf(response);
                    JOptionPane.showMessageDialog(null, strRes, this.cmdName, 1);
                }
            }
            catch (HeadlessException | InterruptedException | ExecutionException ex) {
                fcslog.error((Object)ex.toString());
                ErrorDialog.showErrorDialog(null, (Object)ex.toString(), (Throwable)ex);
            }
        }
    }
}

