/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.config.CANopenHardwareConfig;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.utilities.logging.Logger;

@Deprecated
public class CanOpenHardwarePanel0
extends JPanel {
    protected static final Logger fcslog = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs");
    private GeneralGUI subs;
    private JLabel bootedNodesNBLabel;
    private JLabel expectedNodesNBLabel;
    private JLabel hardwareBootTimeoutLabel;
    private JPanel hardwarePanel;
    private JTable hardwareTable;
    private JLabel bootedNodesNBNameLabel;
    private JLabel hardwareBootTimeoutNameLabel;
    private JLabel expectedNodesNBNameLabel;
    private JLabel portNumberNameLabel;
    private EPOSControllerPanel hooksControllerPanel;
    private EPOSControllerPanel carrierControllerPanel;
    private JPanel jPanel3;
    private JScrollPane jScrollPane2;
    private JTabbedPane jTabbedPane1;
    private JLabel portNumberLabel;

    public CanOpenHardwarePanel0() {
        this.initComponents();
    }

    public EPOSControllerPanel getHooksControllerPanel() {
        return this.hooksControllerPanel;
    }

    public EPOSControllerPanel getCarrierControllerPanel() {
        return this.carrierControllerPanel;
    }

    public void setSubsystem(GeneralGUI subs) {
        this.subs = subs;
        this.hooksControllerPanel.setSubsystem(subs);
        this.carrierControllerPanel.setSubsystem(subs);
    }

    public void initializeGui(CanOpenProxyConfig tcpProxyConfig, EPOSControllerConfig clampCtlConfig, EPOSControllerConfig carrierCtlConfig) {
        SwingUtilities.invokeLater(new GuiInitialization(tcpProxyConfig, clampCtlConfig, carrierCtlConfig));
    }

    public void updateCanOpenHardwarePanel(StatusDataPublishedByHardware status) {
        SwingUtilities.invokeLater(new UpdateCanOpenHardwarePanel(status));
    }

    public void updateCarrierController(StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateCarrierController(status));
    }

    public void updateClampController(StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateClampController(status));
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.hardwarePanel = new JPanel();
        this.bootedNodesNBNameLabel = new JLabel("Number of booted CANopen Nodes:");
        this.bootedNodesNBLabel = new JLabel("0");
        this.hardwareBootTimeoutNameLabel = new JLabel("Hardware boot timeout:");
        this.hardwareBootTimeoutLabel = new JLabel("0");
        this.expectedNodesNBNameLabel = new JLabel("Number of expected CANopen Nodes:");
        this.expectedNodesNBLabel = new JLabel("0");
        this.portNumberNameLabel = new JLabel("Port number:");
        this.portNumberLabel = new JLabel("0");
        this.jTabbedPane1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jScrollPane2 = new JScrollPane();
        this.hardwareTable = new JTable();
        this.hardwareTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Node ID", "Serial NB", "Booted", "Initialized"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Object.class, Boolean.class, Boolean.class};
                this.canEdit = new boolean[5];
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        TableColumn column = null;
        int i = 0;
        while (i < 5) {
            column = this.hardwareTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(100);
            }
            ++i;
        }
        this.jScrollPane2.setViewportView(this.hardwareTable);
        JPanel generalInfoPanel = new JPanel();
        generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.insets = Tools.insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        gbc4.anchor = 21;
        generalInfoPanel.add((Component)this.portNumberNameLabel, gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)this.hardwareBootTimeoutNameLabel, gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)this.expectedNodesNBNameLabel, gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)this.bootedNodesNBNameLabel, gbc4);
        ++gbc4.gridx;
        gbc4.gridy = 0;
        gbc4.anchor = 22;
        generalInfoPanel.add((Component)this.portNumberLabel, gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)this.hardwareBootTimeoutLabel, gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)this.expectedNodesNBLabel, gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)this.bootedNodesNBLabel, gbc4);
        this.hardwarePanel.setBorder(BorderFactory.createLineBorder(new Color(255, 0, 255)));
        this.hardwarePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.anchor = 18;
        gbc0.insets = Tools.insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        this.hardwarePanel.add((Component)generalInfoPanel, gbc0);
        gbc0.gridx = 0;
        ++gbc0.gridy;
        this.hardwarePanel.add((Component)this.jScrollPane2, gbc0);
        this.hooksControllerPanel = new EPOSControllerPanel();
        this.carrierControllerPanel = new EPOSControllerPanel();
        this.jPanel3 = new JPanel();
        this.jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.anchor = 18;
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        JLabel jl3 = new JLabel("Pluto Gateway Panel : work in progress.....");
        this.jPanel3.add((Component)jl3, gbc3);
        this.jTabbedPane1.addTab("CANopen Hardware List", this.hardwarePanel);
        this.jTabbedPane1.addTab("Clamp Controller", this.hooksControllerPanel);
        this.jTabbedPane1.addTab("Carrier Controller", this.carrierControllerPanel);
        this.jTabbedPane1.addTab("Pluto Gateway", this.jPanel3);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 676, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1, -2, 664, -2).addContainerGap(-1, Short.MAX_VALUE))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 514, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTabbedPane1))));
    }

    public static void main(String[] argv) {
        CanOpenHardwarePanel0 p = new CanOpenHardwarePanel0();
        CANopenHardwareConfig config1 = new CANopenHardwareConfig("plutoGateway", "1", "22d6", Boolean.valueOf(false), Boolean.valueOf(false));
        CANopenHardwareConfig config2 = new CANopenHardwareConfig("hooksController", "1b", "79007141", Boolean.valueOf(false), Boolean.valueOf(false));
        CANopenHardwareConfig config3 = new CANopenHardwareConfig("carrierController", "1a", "80003184", Boolean.valueOf(false), Boolean.valueOf(false));
        CANopenHardwareConfig[] configList = new CANopenHardwareConfig[]{config1, config2, config3};
        CanOpenProxyConfig tcpConfig = new CanOpenProxyConfig("Toto", 52000, 3, 2000L, configList);
        EPOSControllerConfig hooksCtlConfig = new EPOSControllerConfig("hooksController", null, null, null);
        EPOSControllerConfig carrierCtlConfig = new EPOSControllerConfig("carrierController", null, null, null);
        p.initializeGui(tcpConfig, hooksCtlConfig, carrierCtlConfig);
        JFrame frame = new JFrame("CANopen Hardware");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        StatusDataPublishedByHardware s1 = new StatusDataPublishedByHardware("plutoGateway", true, false);
        p.updateCanOpenHardwarePanel(s1);
        StatusDataPublishedByHardware s2 = new StatusDataPublishedByHardware("hooksController", true, true);
        p.updateCanOpenHardwarePanel(s2);
        StatusDataPublishedByHardware s3 = new StatusDataPublishedByHardware("carrierController", false, true);
        p.updateCanOpenHardwarePanel(s3);
    }

    private class GuiInitialization
    implements Runnable {
        CanOpenProxyConfig canOpenProxyConfig;
        EPOSControllerConfig clampCtlConfig;
        EPOSControllerConfig carrierCtlConfig;

        public GuiInitialization(CanOpenProxyConfig aConfig, EPOSControllerConfig clampCtlConfig, EPOSControllerConfig carrierCtlConfig) {
            this.canOpenProxyConfig = aConfig;
            this.clampCtlConfig = clampCtlConfig;
            this.carrierCtlConfig = carrierCtlConfig;
        }

        @Override
        public void run() {
            CanOpenHardwarePanel0.this.portNumberLabel.setText(Integer.toString(this.canOpenProxyConfig.getPortNumber()));
            CanOpenHardwarePanel0.this.expectedNodesNBLabel.setText(Integer.toString(this.canOpenProxyConfig.getExpectedNodesNB()));
            CanOpenHardwarePanel0.this.hardwareBootTimeoutLabel.setText(Long.toString(this.canOpenProxyConfig.getHardwareBootTimeout()));
            CANopenHardwareConfig clampHConfig = new CANopenHardwareConfig("Unknown", "Unknown", "Unknown", Boolean.valueOf(false), Boolean.valueOf(false));
            CANopenHardwareConfig carrierHConfig = new CANopenHardwareConfig("Unknown", "Unknown", "Unknown", Boolean.valueOf(false), Boolean.valueOf(false));
            CANopenHardwareConfig[] list = this.canOpenProxyConfig.getHardwareConfigList();
            int rowNB = list.length;
            CanOpenHardwarePanel0.this.bootedNodesNBLabel.setText(Integer.toString(rowNB));
            DefaultTableModel hardwareTableModel = (DefaultTableModel)CanOpenHardwarePanel0.this.hardwareTable.getModel();
            int i = 0;
            while (i < rowNB) {
                Object[] tab = new Object[]{list[i].getName(), list[i].getNodeID(), list[i].getSerialNB(), list[i].isBooted(), list[i].isInitialized()};
                hardwareTableModel.addRow(tab);
                if (list[i].getName().equals(this.clampCtlConfig.getName())) {
                    clampHConfig = list[i];
                } else if (list[i].getName().equals(this.carrierCtlConfig.getName())) {
                    carrierHConfig = list[i];
                }
                ++i;
            }
            hardwareTableModel.fireTableDataChanged();
            CanOpenHardwarePanel0.this.hooksControllerPanel.initializeGui(clampHConfig, this.clampCtlConfig);
            CanOpenHardwarePanel0.this.carrierControllerPanel.initializeGui(carrierHConfig, this.clampCtlConfig);
        }
    }

    class UpdateCanOpenHardwarePanel
    implements Runnable {
        StatusDataPublishedByHardware s;

        public UpdateCanOpenHardwarePanel(StatusDataPublishedByHardware status) {
            this.s = status;
        }

        @Override
        public void run() {
            DefaultTableModel hardwareTableModel = (DefaultTableModel)CanOpenHardwarePanel0.this.hardwareTable.getModel();
            int rowNB = hardwareTableModel.getRowCount();
            int i = 0;
            while (i < rowNB) {
                if (hardwareTableModel.getValueAt(i, 0).equals(this.s.getName())) {
                    hardwareTableModel.setValueAt(this.s.isBooted(), i, 3);
                    hardwareTableModel.setValueAt(this.s.isInitialized(), i, 4);
                }
                ++i;
            }
            hardwareTableModel.fireTableDataChanged();
        }
    }

    class UpdateCarrierController
    implements Runnable {
        StatusDataPublishedByEPOSController s;

        public UpdateCarrierController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            CanOpenHardwarePanel0.this.carrierControllerPanel.updateController(this.s);
        }
    }

    class UpdateClampController
    implements Runnable {
        StatusDataPublishedByEPOSController s;

        public UpdateClampController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            CanOpenHardwarePanel0.this.hooksControllerPanel.updateController(this.s);
        }
    }
}

