/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.config.CANopenHardwareConfig;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.utilities.logging.Logger;

public class CanOpenHardwarePanel
extends JPanel {
    protected static final Logger fcslog = Tools.fcslog;
    private JLabel bootedNodesNBLabel;
    private JLabel expectedNodesNBLabel;
    private JLabel hardwareBootTimeoutLabel;
    private JPanel hardwarePanel;
    private JTable hardwareTable;
    private JLabel bootedNodesNBNameLabel;
    private JLabel hardwareBootTimeoutNameLabel;
    private JLabel expectedNodesNBNameLabel;
    private JLabel portNumberNameLabel;
    private JLabel portNumberLabel;
    private JScrollPane jScrollPane;

    public CanOpenHardwarePanel() {
        this.initComponents();
    }

    public void initializeGui(CanOpenProxyConfig tcpProxyConfig) {
        SwingUtilities.invokeLater(new GuiInitialization(tcpProxyConfig));
    }

    public void updateCanOpenHardwarePanel(StatusDataPublishedByHardware status) {
        SwingUtilities.invokeLater(new UpdateCanOpenHardwarePanel(status));
    }

    private void initComponents() {
        this.hardwarePanel = new JPanel();
        this.bootedNodesNBNameLabel = new JLabel("Number of booted CANopen Nodes:");
        this.bootedNodesNBLabel = new JLabel("0");
        this.hardwareBootTimeoutNameLabel = new JLabel("Hardware boot timeout:");
        this.hardwareBootTimeoutLabel = new JLabel("0");
        this.expectedNodesNBNameLabel = new JLabel("Number of expected CANopen Nodes:");
        this.expectedNodesNBLabel = new JLabel("0");
        this.portNumberNameLabel = new JLabel("Port number:");
        this.portNumberLabel = new JLabel("0");
        this.jScrollPane = new JScrollPane();
        this.hardwareTable = new JTable();
        this.hardwareTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Node ID", "Serial NB", "Booted", "Initialized"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Object.class, Boolean.class, Boolean.class};
                this.canEdit = new boolean[5];
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        TableColumn column = null;
        int i = 0;
        while (i < 5) {
            column = this.hardwareTable.getColumnModel().getColumn(i);
            if (i == 0) {
                column.setPreferredWidth(150);
            }
            ++i;
        }
        this.jScrollPane.setViewportView(this.hardwareTable);
        JPanel generalInfoPanel = new JPanel();
        generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.insets = Tools.insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        gbc4.anchor = 21;
        generalInfoPanel.add((Component)this.portNumberNameLabel, gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)this.hardwareBootTimeoutNameLabel, gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)this.expectedNodesNBNameLabel, gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)this.bootedNodesNBNameLabel, gbc4);
        ++gbc4.gridx;
        gbc4.gridy = 0;
        gbc4.anchor = 22;
        generalInfoPanel.add((Component)this.portNumberLabel, gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)this.hardwareBootTimeoutLabel, gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)this.expectedNodesNBLabel, gbc4);
        ++gbc4.gridy;
        generalInfoPanel.add((Component)this.bootedNodesNBLabel, gbc4);
        this.hardwarePanel.setBorder(BorderFactory.createLineBorder(new Color(255, 0, 255)));
        this.hardwarePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.anchor = 18;
        gbc0.insets = Tools.insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        this.hardwarePanel.add((Component)generalInfoPanel, gbc0);
        gbc0.gridx = 0;
        ++gbc0.gridy;
        this.hardwarePanel.add((Component)this.jScrollPane, gbc0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 512;
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.hardwarePanel, gbc);
    }

    @Override
    public String toString() {
        return "CANopen hardware list";
    }

    public static void main(String[] argv) {
        CanOpenHardwarePanel p = new CanOpenHardwarePanel();
        CANopenHardwareConfig config1 = new CANopenHardwareConfig("plutoGateway", "1", "22d6", Boolean.valueOf(false), Boolean.valueOf(false));
        CANopenHardwareConfig config2 = new CANopenHardwareConfig("hooksController", "1b", "79007141", Boolean.valueOf(false), Boolean.valueOf(false));
        CANopenHardwareConfig config3 = new CANopenHardwareConfig("carrierController", "1a", "80003184", Boolean.valueOf(false), Boolean.valueOf(false));
        CANopenHardwareConfig[] configList = new CANopenHardwareConfig[]{config1, config2, config3};
        CanOpenProxyConfig tcpConfig = new CanOpenProxyConfig("Toto", 52000, 3, 2000L, configList);
        p.initializeGui(tcpConfig);
        JFrame frame = new JFrame("CANopen Hardware");
        frame.setContentPane(p);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        StatusDataPublishedByHardware s1 = new StatusDataPublishedByHardware("plutoGateway", true, false);
        p.updateCanOpenHardwarePanel(s1);
        StatusDataPublishedByHardware s2 = new StatusDataPublishedByHardware("hooksController", true, true);
        p.updateCanOpenHardwarePanel(s2);
        StatusDataPublishedByHardware s3 = new StatusDataPublishedByHardware("carrierController", false, true);
        p.updateCanOpenHardwarePanel(s3);
    }

    private class GuiInitialization
    implements Runnable {
        CanOpenProxyConfig canOpenProxyConfig;

        public GuiInitialization(CanOpenProxyConfig aConfig) {
            this.canOpenProxyConfig = aConfig;
        }

        @Override
        public void run() {
            CanOpenHardwarePanel.this.portNumberLabel.setText(Integer.toString(this.canOpenProxyConfig.getPortNumber()));
            CanOpenHardwarePanel.this.expectedNodesNBLabel.setText(Integer.toString(this.canOpenProxyConfig.getExpectedNodesNB()));
            CanOpenHardwarePanel.this.hardwareBootTimeoutLabel.setText(Long.toString(this.canOpenProxyConfig.getHardwareBootTimeout()));
            new CANopenHardwareConfig("Unknown", "Unknown", "Unknown", Boolean.valueOf(false), Boolean.valueOf(false));
            new CANopenHardwareConfig("Unknown", "Unknown", "Unknown", Boolean.valueOf(false), Boolean.valueOf(false));
            CANopenHardwareConfig[] list = this.canOpenProxyConfig.getHardwareConfigList();
            int rowNB = list.length;
            CanOpenHardwarePanel.this.bootedNodesNBLabel.setText(Integer.toString(rowNB));
            DefaultTableModel hardwareTableModel = (DefaultTableModel)CanOpenHardwarePanel.this.hardwareTable.getModel();
            int i = 0;
            while (i < rowNB) {
                Object[] tab = new Object[]{list[i].getName(), list[i].getNodeID(), list[i].getSerialNB(), list[i].isBooted(), list[i].isInitialized()};
                hardwareTableModel.addRow(tab);
                ++i;
            }
            hardwareTableModel.fireTableDataChanged();
        }
    }

    class UpdateCanOpenHardwarePanel
    implements Runnable {
        StatusDataPublishedByHardware s;

        public UpdateCanOpenHardwarePanel(StatusDataPublishedByHardware status) {
            this.s = status;
        }

        @Override
        public void run() {
            DefaultTableModel hardwareTableModel = (DefaultTableModel)CanOpenHardwarePanel.this.hardwareTable.getModel();
            int rowNB = hardwareTableModel.getRowCount();
            int i = 0;
            while (i < rowNB) {
                if (hardwareTableModel.getValueAt(i, 0).equals(this.s.getName())) {
                    hardwareTableModel.setValueAt(this.s.isBooted(), i, 3);
                    hardwareTableModel.setValueAt(this.s.isInitialized(), i, 4);
                }
                ++i;
            }
            hardwareTableModel.fireTableDataChanged();
        }
    }
}

