/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.testbench.ui;

import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerLatchPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerOnlineClampPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerTrucksPanel;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;
import org.lsst.ccs.subsystems.fcs.config.PlutoGatewayConfig;
import org.lsst.ccs.subsystems.fcs.testbench.ui.TestbenchCPPMGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenHardwarePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.PlutoGatewayPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.TopPanel;

public class TestbenchCPPMGatherPanel
extends TopPanel {
    protected TestbenchCPPMGUI subs;
    private final SubsystemPanel subsystemPanel = new SubsystemPanel("TestbenchCPPM Subsystem State");
    protected CanOpenHardwarePanel hardwarePanel;
    protected EPOSControllerPanel linearRailMasterControllerPanel;
    protected EPOSControllerPanel linearRailSlaveControllerPanel;
    protected EPOSControllerPanel latchXminusControllerPanel;
    protected EPOSControllerPanel onlineClampXminusControllerPanel;
    protected PlutoGatewayPanel plutoGatewayPanel;
    AutochangerOnlineClampPanel onlineClampPanel;
    AutochangerTrucksPanel acTrucksPanel;
    AutochangerLatchPanel latchPanel;

    public TestbenchCPPMGatherPanel() {
        this.initPanels();
        fcslog.debug((Object)"COUCOU1");
    }

    public TestbenchCPPMGatherPanel(TestbenchCPPMGUI subs) {
        this.initPanels();
        fcslog.debug((Object)"COUCOU2");
        this.subs = subs;
        this.subsystemPanel.setSubsystem(subs);
        this.latchPanel.setSubsystem(subs);
        this.acTrucksPanel.setSubsystem(subs);
        this.linearRailMasterControllerPanel.setSubsystem(subs);
        this.linearRailSlaveControllerPanel.setSubsystem(subs);
        this.latchXminusControllerPanel.setSubsystem(subs);
        this.onlineClampXminusControllerPanel.setSubsystem(subs);
    }

    @Override
    public SubsystemPanel getSubsystemPanel() {
        return this.subsystemPanel;
    }

    public AutochangerTrucksPanel getAcTrucksPanel() {
        return this.acTrucksPanel;
    }

    public AutochangerOnlineClampPanel getOnlineClampPanel() {
        return this.onlineClampPanel;
    }

    public AutochangerLatchPanel getLatchPanel() {
        return this.latchPanel;
    }

    public CanOpenHardwarePanel getHardwarePanel() {
        return this.hardwarePanel;
    }

    public EPOSControllerPanel getLinearRailMasterControllerPanel() {
        return this.linearRailMasterControllerPanel;
    }

    public EPOSControllerPanel getLinearRailSlaveControllerPanel() {
        return this.linearRailSlaveControllerPanel;
    }

    public EPOSControllerPanel getLatchXminusControllerPanel() {
        return this.latchXminusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampXminusControllerPanel() {
        return this.onlineClampXminusControllerPanel;
    }

    public PlutoGatewayPanel getPlutoGatewayPanel() {
        return this.plutoGatewayPanel;
    }

    public void initializeGui(AutochangerConfig autochangerConfig) {
        SwingUtilities.invokeLater(new GuiInitialization(autochangerConfig));
    }

    void updateCanOpenHardwarePanel(StatusDataPublishedByHardware s) {
        this.hardwarePanel.updateCanOpenHardwarePanel(s);
    }

    void updateLinearRailMasterController(StatusDataPublishedByEPOSController s) {
        this.linearRailMasterControllerPanel.updateController(s);
    }

    void updateLinearRailSlaveController(StatusDataPublishedByEPOSController s) {
        this.linearRailSlaveControllerPanel.updateController(s);
    }

    void updateLatchXminusController(StatusDataPublishedByEPOSController s) {
        this.latchXminusControllerPanel.updateController(s);
    }

    void updateOnlineClampXminusController(StatusDataPublishedByEPOSController s) {
        this.onlineClampXminusControllerPanel.updateController(s);
    }

    void updateClampXminus(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.onlineClampPanel.updateClamp(s);
    }

    void updateLatch(StatusDataPublishedByAutochangerLatch s) {
        this.latchPanel.updateLatch(s);
    }

    void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        fcslog.finest((Object)(" Data published by Trucks= " + s.toString()));
        this.acTrucksPanel.updateTrucks(s);
    }

    private void initPanels() {
        this.hardwarePanel = new CanOpenHardwarePanel();
        this.linearRailMasterControllerPanel = new EPOSControllerPanel("linearRailMasterController");
        this.linearRailSlaveControllerPanel = new EPOSControllerPanel("linearRailSlaveController");
        this.latchXminusControllerPanel = new EPOSControllerPanel("latchXminusController");
        this.onlineClampXminusControllerPanel = new EPOSControllerPanel("onlineClampXminusController");
        this.plutoGatewayPanel = new PlutoGatewayPanel();
        this.onlineClampPanel = new AutochangerOnlineClampPanel();
        this.latchPanel = new AutochangerLatchPanel();
        this.acTrucksPanel = new AutochangerTrucksPanel();
    }

    private class GuiInitialization
    implements Runnable {
        AutochangerConfig autochangerConfig;
        CanOpenProxyConfig canOpenProxyConfig;
        EPOSControllerConfig lrMasterCtlConfig;
        EPOSControllerConfig lrSlaveCtlConfig;
        EPOSControllerConfig latchXminusCtlConfig;
        EPOSControllerConfig onlineXminusCtlConfig;
        PlutoGatewayConfig gwConfig;

        public GuiInitialization(AutochangerConfig autochangerConfig) {
            this.autochangerConfig = autochangerConfig;
            this.canOpenProxyConfig = autochangerConfig.getTcpProxyConfig();
            this.lrMasterCtlConfig = autochangerConfig.getLinearRailMasterControllerConfig();
            this.lrSlaveCtlConfig = autochangerConfig.getLinearRailSlaveControllerConfig();
            this.latchXminusCtlConfig = autochangerConfig.getLatchXminusControllerConfig();
            this.onlineXminusCtlConfig = autochangerConfig.getOnlineClampXminusControllerConfig();
            this.gwConfig = autochangerConfig.getGwConfig();
        }

        @Override
        public void run() {
            TestbenchCPPMGatherPanel.this.subsystemPanel.setcontrolRealHardwareLabelText(this.autochangerConfig.isRealHardware() ? "Real Hardware" : "Simulation");
            TestbenchCPPMGatherPanel.this.latchPanel.initializeGui(this.autochangerConfig.getLatchXminusConfig());
            TestbenchCPPMGatherPanel.this.hardwarePanel.initializeGui(this.canOpenProxyConfig);
            TestbenchCPPMGatherPanel.this.linearRailMasterControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.lrMasterCtlConfig), this.lrMasterCtlConfig);
            TestbenchCPPMGatherPanel.this.linearRailSlaveControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.lrSlaveCtlConfig), this.lrSlaveCtlConfig);
            fcslog.debug((Object)("latchXminusControllerPanel.initializeGui:" + this.latchXminusCtlConfig.toString()));
            TestbenchCPPMGatherPanel.this.latchXminusControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.latchXminusCtlConfig), this.latchXminusCtlConfig);
            TestbenchCPPMGatherPanel.this.onlineClampXminusControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.onlineXminusCtlConfig), this.onlineXminusCtlConfig);
            TestbenchCPPMGatherPanel.this.plutoGatewayPanel.initializeGui(Tools.retrieveDeviceInfo(this.canOpenProxyConfig, this.gwConfig.getName()), this.gwConfig);
            TestbenchCPPMGatherPanel.this.subs.postInitGui();
        }
    }
}

