/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import java.io.PrintWriter;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandError;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.messaging.DataStatusListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.SingleFilterTestConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.FilterExchangeMainPanel;
import org.lsst.ccs.utilities.logging.Logger;

public class SingleFilterTestGUISubsystem
implements DataStatusListener {
    private static final String destination = "single-filter-test";
    private static final String name = "SingleFilterTestModelGUIModule";
    private PrintWriter out = new PrintWriter(System.out, true);
    private final FilterExchangeMainPanel assembly;
    private long lastHeartBeat = 0L;
    private long lastStateRequest = 0L;
    private boolean initialized = false;
    JScrollPane pane;
    private final AgentMessagingLayer aml;
    protected static Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.fcs");

    public SingleFilterTestGUISubsystem(AgentMessagingLayer aml) {
        this.aml = aml;
        this.assembly = new FilterExchangeMainPanel(this);
        this.pane = new JScrollPane(this.assembly);
    }

    public void initGui() {
        this.aml.addStatusMessageListener((StatusMessageListener)this);
    }

    public String getName() {
        return name;
    }

    public JComponent getGuiLayout() {
        return this.pane;
    }

    public void resetGui() {
    }

    public static void main(String[] args) {
        Agent agent = new Agent(name, AgentInfo.AgentType.CONSOLE);
        SingleFilterTestGUISubsystem t = new SingleFilterTestGUISubsystem(agent.getMessagingAccess());
        t.initGui();
        agent.start();
        JFrame frame = new JFrame("Single Filter Test Subsystem");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    public void onDataArrival(String source, long timestamp, String dataType, Object s) {
        block23: {
            block21: {
                if (!source.equals(destination)) {
                    return;
                }
                if (!this.initialized) break block21;
                switch (dataType) {
                    case "carouselClamp": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:carouselClamp"));
                        this.assembly.updateClamp((StatusDataPublishedByClamp)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "actuator": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:actuator"));
                        this.assembly.updateActuator((StatusDataPublishedByClampActuator)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "carousel": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:carousel"));
                        this.assembly.updateCarousel((StatusDataPublishedByCarousel)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "autochangerLatch": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:autochangerLatch"));
                        this.assembly.updateLatch((StatusDataPublishedByAutochangerLatch)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "autochanger": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:autochanger"));
                        this.assembly.updateAutoChanger((StatusDataPublishedByBasicAutoChanger)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    default: {
                        log.warning((Object)(String.valueOf(this.getName()) + " An unexpected dataType was read on the status bus:" + dataType));
                        break;
                    }
                }
                break block23;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastStateRequest > 2000L) {
                this.lastStateRequest = currentTime;
                CommandRequest cmd = new CommandRequest(destination, "getFullState");
                this.aml.sendCommandRequest(cmd, new CommandOriginator(){

                    public void processAck(CommandAck ack) {
                    }

                    public void processResult(CommandResult result) {
                        SingleFilterTestConfig config = (SingleFilterTestConfig)result.getReply();
                        SingleFilterTestGUISubsystem.this.assembly.initializeGui(config);
                        SingleFilterTestGUISubsystem.this.initialized = true;
                    }

                    public void processNack(CommandNack nack) {
                    }

                    public void processError(CommandError nack) {
                    }
                });
            }
        }
    }
}

