/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGUI;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderMainPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenHardwarePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.TopPanel;

public class LoaderTopPanel
extends TopPanel {
    private GeneralGUI subs;
    private JTabbedPane jTabbedPane;
    LoaderMainPanel loaderMainPanel;
    private CanOpenHardwarePanel hardwarePanel;
    private EPOSControllerPanel hooksControllerPanel;
    private EPOSControllerPanel carrierControllerPanel;
    private JPanel plutoGWPanel;

    public LoaderTopPanel() {
        this.initComponents();
    }

    public LoaderTopPanel(LoaderGUI subs) {
        this.subs = subs;
        this.initComponents();
        this.loaderMainPanel.setSubsystem(subs);
        this.hooksControllerPanel.setSubsystem(subs);
        this.carrierControllerPanel.setSubsystem(subs);
    }

    @Override
    public SubsystemPanel getSubsystemPanel() {
        return this.loaderMainPanel.getSubsystemPanel();
    }

    public EPOSControllerPanel getHooksControllerPanel() {
        return this.hooksControllerPanel;
    }

    public EPOSControllerPanel getCarrierControllerPanel() {
        return this.carrierControllerPanel;
    }

    public void initializeGui(LoaderConfig loaderConfig) {
        SwingUtilities.invokeLater(new GuiInitialization(loaderConfig));
    }

    void updateLoaderGeneral(StatusDataPublishedByLoader statusDataPublishedByLoader) {
        this.loaderMainPanel.updateLoaderGeneral(statusDataPublishedByLoader);
    }

    void updateClamp(StatusDataPublishedByLoaderClamp statusDataPublishedByLoaderClamp) {
        this.loaderMainPanel.updateClamp(statusDataPublishedByLoaderClamp);
    }

    void updateCarrier(StatusDataPublishedByLoaderCarrier statusDataPublishedByLoaderCarrier) {
        this.loaderMainPanel.updateCarrier(statusDataPublishedByLoaderCarrier);
    }

    void updateCanOpenHardwarePanel(StatusDataPublishedByHardware statusDataPublishedByHardware) {
        this.hardwarePanel.updateCanOpenHardwarePanel(statusDataPublishedByHardware);
    }

    public void updateCarrierController(StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateCarrierController(status));
    }

    public void updateClampController(StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateClampController(status));
    }

    private void initComponents() {
        this.loaderMainPanel = new LoaderMainPanel();
        JScrollPane mainViewScrollPane = new JScrollPane(this.loaderMainPanel);
        mainViewScrollPane.createVerticalScrollBar();
        mainViewScrollPane.setPreferredSize(new Dimension(1200, 900));
        this.hardwarePanel = new CanOpenHardwarePanel();
        this.hooksControllerPanel = new EPOSControllerPanel();
        this.carrierControllerPanel = new EPOSControllerPanel();
        this.plutoGWPanel = new JPanel();
        this.plutoGWPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.anchor = 18;
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        JLabel jl3 = new JLabel("Pluto Gateway Panel : work in progress.....");
        this.plutoGWPanel.add((Component)jl3, gbc3);
        this.jTabbedPane = new JTabbedPane();
        this.jTabbedPane.setTabPlacement(1);
        this.jTabbedPane.setBorder(BorderFactory.createLineBorder(new Color(0, 150, 180)));
        this.jTabbedPane.addTab("Loader Main View", mainViewScrollPane);
        this.jTabbedPane.addTab("Loader CANopen Devices", this.hardwarePanel);
        this.jTabbedPane.addTab("Loader Clamp Controller", this.hooksControllerPanel);
        this.jTabbedPane.addTab("Loader Carrier Controller", this.carrierControllerPanel);
        this.jTabbedPane.addTab("Loader Pluto Gateway", this.plutoGWPanel);
        this.setLayout(new GridBagLayout());
        this.setForeground(new Color(204, 204, 255));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 512;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.jTabbedPane, gbc);
    }

    public static void main(String[] argv) {
        LoaderTopPanel d = new LoaderTopPanel();
        JFrame frame = new JFrame("Loader High Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class GuiInitialization
    implements Runnable {
        LoaderConfig loaderConfig;
        CanOpenProxyConfig canOpenProxyConfig;
        EPOSControllerConfig clampCtlConfig;
        EPOSControllerConfig carrierCtlConfig;

        public GuiInitialization(LoaderConfig loaderConfig) {
            this.loaderConfig = loaderConfig;
            this.canOpenProxyConfig = loaderConfig.getTcpProxyConfig();
            this.clampCtlConfig = loaderConfig.getLoaderClampControllerConfig();
            this.carrierCtlConfig = loaderConfig.getLoaderCarrierControllerConfig();
        }

        @Override
        public void run() {
            LoaderTopPanel.this.loaderMainPanel.initializeGui(this.loaderConfig);
            LoaderTopPanel.this.hardwarePanel.initializeGui(this.canOpenProxyConfig);
            LoaderTopPanel.this.hooksControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.clampCtlConfig), this.clampCtlConfig);
            LoaderTopPanel.this.carrierControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.carrierCtlConfig), this.carrierCtlConfig);
        }
    }

    class UpdateCarrierController
    implements Runnable {
        StatusDataPublishedByEPOSController s;

        public UpdateCarrierController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            LoaderTopPanel.this.carrierControllerPanel.updateController(this.s);
        }
    }

    class UpdateClampController
    implements Runnable {
        StatusDataPublishedByEPOSController s;

        public UpdateClampController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            LoaderTopPanel.this.hooksControllerPanel.updateController(this.s);
        }
    }
}

