/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandError;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderTopPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.utilities.logging.Logger;

public class LoaderGUI
extends GeneralGUI {
    private static final String clampModuleName = "clamp";
    private static final String carrierModuleName = "carrier";
    private long lastHeartBeat = 0L;
    private long lastStateRequest = 0L;
    protected static Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.fcs");
    long updateCarrierPositionTimeout;
    long openHooksTimeout;
    long closeHooksTimeout;
    long clampHooksTimeout;
    long homingHooksTimeout;
    long goToHandoffTimeout;
    long goToStorageTimeout;
    long quickStopTimeout;

    public LoaderGUI(String name, String destination, AgentMessagingLayer agentMessagingLayer) {
        super(name, destination, agentMessagingLayer);
        this.topPanel = new LoaderTopPanel(this);
        this.pane = new JScrollPane(this.topPanel);
        this.openHooksTimeout = 0L;
        this.closeHooksTimeout = 0L;
        this.clampHooksTimeout = 0L;
        this.homingHooksTimeout = 0L;
        this.goToHandoffTimeout = 0L;
        this.goToStorageTimeout = 0L;
        this.abortTimeout = 1000L;
        this.quickStopTimeout = 1000L;
        this.updateStateWithSensorsTimeout = 1000L;
        this.updateCarrierPositionTimeout = 1000L;
    }

    @Override
    public JComponent getGuiLayout() {
        return this.pane;
    }

    @Override
    public String getName() {
        return "LoaderGUIModule";
    }

    public void onDataArrival(String source, long timestamp, String dataType, Object s) {
        block26: {
            block24: {
                if (!source.equals(this.destination)) {
                    return;
                }
                if (!this.initialized) break block24;
                switch (dataType) {
                    case "loaderGeneral": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:loaderGeneral"));
                        ((LoaderTopPanel)this.topPanel).updateLoaderGeneral((StatusDataPublishedByLoader)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "loaderClamp": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:loaderClamp"));
                        ((LoaderTopPanel)this.topPanel).updateClamp((StatusDataPublishedByLoaderClamp)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "loaderCarrier": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:loaderCarrier"));
                        ((LoaderTopPanel)this.topPanel).updateCarrier((StatusDataPublishedByLoaderCarrier)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "tcpProxy": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:tcpProxy"));
                        ((LoaderTopPanel)this.topPanel).updateCanOpenHardwarePanel((StatusDataPublishedByHardware)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "carrierController": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:loaderCarrierController"));
                        ((LoaderTopPanel)this.topPanel).updateCarrierController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "hooksController": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:loaderClampController"));
                        ((LoaderTopPanel)this.topPanel).updateClampController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    default: {
                        log.warning((Object)(String.valueOf(this.getName()) + " An unexpected dataType was read on the status bus:" + dataType));
                        break;
                    }
                }
                break block26;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastStateRequest > 2000L) {
                this.lastStateRequest = currentTime;
                CommandRequest cmd = new CommandRequest(this.destination, "getFullState");
                this.aml.sendCommandRequest(cmd, new CommandOriginator(){

                    public void processAck(CommandAck ack) {
                    }

                    public void processResult(CommandResult result) {
                        LoaderConfig config = (LoaderConfig)result.getReply();
                        log.debug((Object)"--- Got a reply from subs");
                        ((LoaderTopPanel)LoaderGUI.this.topPanel).initializeGui(config);
                        LoaderGUI.this.initialized = true;
                    }

                    public void processNack(CommandNack nack) {
                    }

                    public void processError(CommandError nack) {
                    }
                });
            }
        }
    }

    protected void loadFilter() {
        System.out.println(String.valueOf(this.destination) + "loadFilterInCamera with timeout=" + this.goToHandoffTimeout);
        log.info((Object)"Loading filter in camera");
        log.info((Object)("/timeout=" + this.goToHandoffTimeout));
        new GeneralGUI.CommandSwingWorker("loadFilterInCamera", this.goToHandoffTimeout).execute();
    }

    protected void unloadFilter() {
        System.out.println(String.valueOf(this.destination) + "unloadFilterFromCamera with timeout=" + this.goToStorageTimeout);
        log.info((Object)"Loading filter in camera");
        log.info((Object)("/timeout=" + this.goToStorageTimeout));
        new GeneralGUI.CommandSwingWorker("unloadFilterFromCamera", this.goToStorageTimeout).execute();
    }

    protected void updateCarrierPosition() {
        System.out.println(String.valueOf(this.destination) + "updateCarrierPosition with updateCarrierPositionTimeout=" + this.updateCarrierPositionTimeout);
        log.info((Object)"Updating carrier position");
        log.info((Object)("/timeout=" + this.updateCarrierPositionTimeout));
        new GeneralGUI.CommandSwingWorker("updatePosition", this.updateCarrierPositionTimeout, carrierModuleName).execute();
    }

    protected void openHooks() {
        log.info((Object)"Opening Hooks");
        log.info((Object)("/timeout=" + this.openHooksTimeout));
        new GeneralGUI.CommandSwingWorker("openHooks", this.openHooksTimeout).execute();
    }

    protected void closeHooks() {
        log.info((Object)"Closing Hooks");
        System.out.println("/timeout=" + this.closeHooksTimeout);
        new GeneralGUI.CommandSwingWorker("closeHooks", this.closeHooksTimeout).execute();
    }

    protected void clampHooks() {
        log.info((Object)"Clamping Hooks");
        log.info((Object)("/timeout=" + this.clampHooksTimeout));
        new GeneralGUI.CommandSwingWorker("clampHooks", this.clampHooksTimeout).execute();
    }

    protected void goToHomePosition() {
        log.info((Object)"Clamp going to Home Position");
        log.info((Object)("/timeout=" + this.homingHooksTimeout));
        new GeneralGUI.CommandSwingWorker("goToHomePosition", this.homingHooksTimeout, clampModuleName).execute();
    }

    protected void goToClosePosition() {
        log.info((Object)"Going to Close Position");
        log.info((Object)("/timeout=" + this.clampHooksTimeout));
        new GeneralGUI.CommandSwingWorker("goToClampedPosition", this.clampHooksTimeout, clampModuleName).execute();
    }

    protected void goToHandOff() {
        log.info((Object)"Carrier going to Handoff Position");
        log.info((Object)("/timeout=" + this.goToHandoffTimeout));
        new GeneralGUI.CommandSwingWorker("goToHandOff", this.goToHandoffTimeout, carrierModuleName).execute();
    }

    protected void goToStorage() {
        System.out.println(String.valueOf(this.destination) + "goToStorage with goToStorageTimeout=" + this.goToStorageTimeout);
        log.info((Object)"Carrier going to Storage Position");
        log.info((Object)("/timeout=" + this.goToStorageTimeout));
        new GeneralGUI.CommandSwingWorker("goToStorage", this.goToStorageTimeout, carrierModuleName).execute();
    }

    public static void main(String[] args) {
        Agent agent = new Agent("LoaderGUIModule", AgentInfo.AgentType.CONSOLE);
        LoaderGUI t = new LoaderGUI(agent.getName(), "testbenchLPSC", agent.getMessagingAccess());
        agent.start();
        t.initGui();
        JFrame frame = new JFrame("Loader View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

