/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.carousel.config.CarouselConfig;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.utilities.logging.Logger;

public class CarouselMainPanel
extends JPanel {
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs");
    private CarouselGUI subs;
    SubsystemPanel subsystemPanel;

    public CarouselMainPanel() {
        this.initComponents();
    }

    public CarouselMainPanel(CarouselGUI subs) {
        this.subs = subs;
        this.initComponents();
    }

    public void setSubsystem(CarouselGUI subs) {
        this.subs = subs;
    }

    public SubsystemPanel getSubsystemPanel() {
        return this.subsystemPanel;
    }

    public void initializeGui(CarouselConfig config) {
        SwingUtilities.invokeLater(new GuiInitialization(config));
    }

    private void initComponents() {
        this.subsystemPanel = new SubsystemPanel("Carousel Subsystem State");
        GridBagConstraints gbc = new GridBagConstraints();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), "CAROUSEL"));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        gbc.anchor = 512;
        gbc.insets = Tools.insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.subsystemPanel, gbc);
    }

    public static void main(String[] argv) {
        CarouselMainPanel d = new CarouselMainPanel();
        JFrame frame = new JFrame("Carousel Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class GuiInitialization
    implements Runnable {
        CarouselConfig config;

        public GuiInitialization(CarouselConfig aConfig) {
            this.config = aConfig;
            CarouselMainPanel.this.subsystemPanel.setcontrolRealHardwareLabelText(this.config.isRealHardware() ? "Real Hardware" : "Simulation");
        }

        @Override
        public void run() {
        }
    }
}

