/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.carousel.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandError;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.carousel.config.CarouselConfig;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselMainPanel;
import org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselTopPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;

public class CarouselGUI
extends GeneralGUI {
    private long lastHeartBeat = 0L;
    private long lastStateRequest = 0L;
    String stateCorrelId;

    public CarouselGUI(String name, String destination, AgentMessagingLayer aml) {
        super(name, destination, aml);
        this.topPanel = new CarouselTopPanel(this);
        this.pane = new JScrollPane(this.topPanel);
    }

    public void onDataArrival(String source, long timestamp, String dataType, Object s) {
        block14: {
            block12: {
                if (!source.equals(this.destination)) {
                    return;
                }
                if (!this.initialized) break block12;
                switch (dataType) {
                    case "tcpProxy": {
                        CarouselMainPanel.log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:tcpProxy"));
                        ((CarouselTopPanel)this.topPanel).updateCanOpenHardwarePanel((StatusDataPublishedByHardware)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "carouselController": {
                        CarouselMainPanel.log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:linearRailMasterController"));
                        ((CarouselTopPanel)this.topPanel).updateCarouselController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    default: {
                        CarouselMainPanel.log.warning((Object)(String.valueOf(this.getName()) + " An unexpected dataType was read on the status bus:" + dataType));
                        break;
                    }
                }
                break block14;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastStateRequest > 2000L) {
                this.lastStateRequest = currentTime;
                CommandRequest cmd = new CommandRequest(this.destination, "getFullState");
                this.aml.sendCommandRequest(cmd, new CommandOriginator(){

                    public void processAck(CommandAck ack) {
                    }

                    public void processResult(CommandResult result) {
                        CarouselConfig config = (CarouselConfig)result.getReply();
                        CarouselMainPanel.log.debug((Object)"--- Got a reply from subs");
                        ((CarouselTopPanel)CarouselGUI.this.topPanel).initializeGui(config);
                        CarouselGUI.this.initialized = true;
                    }

                    public void processNack(CommandNack nack) {
                    }

                    public void processError(CommandError nack) {
                    }
                });
            }
        }
    }

    public static void main(String[] args) {
        Agent agent = new Agent("CarouselGUI", AgentInfo.AgentType.CONSOLE);
        CarouselGUI t = new CarouselGUI(agent.getName(), "carousel", agent.getMessagingAccess());
        agent.start();
        JFrame frame = new JFrame("Carousel View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }
}

