/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerTrucksConfig;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGeneralGUI;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerMainPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AutochangerTrucksPanel
extends JPanel {
    private AutochangerGeneralGUI subs;
    private final DigitalSwitch limitSwitchUpDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch standbyDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inTravelDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch handoffDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch onlineDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch limitSwitchDownDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inErrorDigitalSwitch = new DigitalSwitch();
    private final JLabel cajLabel = new JLabel("Trucks position");
    private final JLabel limitSUjLabel = new JLabel("Limit Switch Up");
    private final JLabel standbyjLabel = new JLabel("STANDBY");
    private final JLabel inTraveljLabel = new JLabel("In Travel");
    private final JLabel handoffjLabel = new JLabel("HAND-OFF");
    private final JLabel onlinejLabel = new JLabel("ONLINE");
    private final JLabel limitSDjLabel = new JLabel("Limit Switch Down");
    private final JLabel inErrorjLabel = new JLabel("IN ERROR");
    private final JLabel handoffSensorsErrorjLabel = new JLabel();
    private final JLabel standbySensorsErrorjLabel = new JLabel();
    private final JLabel acjLabel = new JLabel("Actual Position (in um): ");
    private final JLabel spjLabel = new JLabel("Speed (in rpm/s): ");
    private final JLabel cujLabel = new JLabel("Current (in mA): ");
    private final JLabel actualPositionjLabel = new JLabel("0");
    private final JLabel speedjLabel = new JLabel("0");
    private final JLabel currentjLabel = new JLabel("0");
    private final JProgressBar positionProgressBar = new JProgressBar(1, 0, 500);
    private final JLabel stjLabel = new JLabel("Standby Position (in mm): ");
    private final JLabel onjLabel = new JLabel("Online Position (in mm): ");
    private final JLabel hojLabel = new JLabel("Hand-Off Position (in mm): ");
    private final JLabel smjLabel = new JLabel("Speed max (in rpm/mn): ");
    private final JLabel cmjLabel = new JLabel("Current max (in mA): ");
    private final JLabel standbyPositionjLabel = new JLabel(Integer.toString(0));
    private final JLabel handoffPositionjLabel = new JLabel(Double.toString(0.0));
    private final JLabel onlinePositionjLabel = new JLabel(Double.toString(0.0));
    private final JLabel speedMaxjLabel = new JLabel(Integer.toString(0));
    private final JLabel currentMaxjLabel = new JLabel(Integer.toString(0));
    private final JButton updateStateWithSensorsButton = new JButton("updateStateWithSensors");
    private final JButton updatePositionButton = new JButton("updatePosition");
    private final JButton goToStandbyButton = new JButton("goToStandby");
    private final JButton goToHandoffButton = new JButton("goToHandOff");
    private final JButton goToOnlineButton = new JButton("goToOnline");
    private final JButton quickStopButton = new JButton("QuickStop");
    private final JButton abortButton = new JButton("Abort");
    JPanel faultMasterCtlPanel;
    DigitalSwitch faultMasterCtlSwitch = new DigitalSwitch();
    JPanel faultSlaveCtlPanel;
    DigitalSwitch faultSlaveCtlSwitch = new DigitalSwitch();

    public AutochangerTrucksPanel() {
        this.initComponents();
    }

    public void setSubsystem(AutochangerGeneralGUI subs) {
        this.subs = subs;
    }

    public void initializeGui(AutochangerTrucksConfig config) {
        SwingUtilities.invokeLater(new GuiInitialization(config));
    }

    public void updateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
        SwingUtilities.invokeLater(new UpdateTrucks(status));
    }

    private void initComponents() {
        this.updateStateWithSensorsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutochangerTrucksPanel.this.updateStateWithSensorsActionPerformed(evt);
            }
        });
        this.updatePositionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutochangerTrucksPanel.this.updatePositionActionPerformed(evt);
            }
        });
        this.goToHandoffButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutochangerTrucksPanel.this.goToHandoffActionPerformed(evt);
            }
        });
        this.goToOnlineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutochangerTrucksPanel.this.goToOnlineActionPerformed(evt);
            }
        });
        this.goToStandbyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutochangerTrucksPanel.this.goToStandbyActionPerformed(evt);
            }
        });
        this.quickStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutochangerTrucksPanel.this.quickStopActionPerformed(evt);
            }
        });
        this.abortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutochangerTrucksPanel.this.abortActionPerformed(evt);
            }
        });
        this.setBorder(BorderFactory.createTitledBorder("AUTOCHANGER TRUCKS"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = Tools.insets_std;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.cajLabel.setFont(Tools.bigFont);
        this.add((Component)this.cajLabel, gbc);
        this.limitSwitchUpDigitalSwitch.setColor(Color.gray);
        this.standbyDigitalSwitch.setColor(Color.gray);
        this.inTravelDigitalSwitch.setColor(Color.gray);
        this.handoffDigitalSwitch.setColor(Color.gray);
        this.onlineDigitalSwitch.setColor(Color.gray);
        this.limitSwitchDownDigitalSwitch.setColor(Color.gray);
        gbc.anchor = 13;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add((Component)this.limitSUjLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.limitSwitchUpDigitalSwitch, gbc);
        gbc.anchor = 12;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.standbyjLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.standbyDigitalSwitch, gbc);
        gbc.anchor = 13;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.inTraveljLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.inTravelDigitalSwitch, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.handoffjLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.handoffDigitalSwitch, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.onlinejLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.onlineDigitalSwitch, gbc);
        gbc.anchor = 12;
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.limitSDjLabel, gbc);
        ++gbc.gridx;
        this.add((Component)this.limitSwitchDownDigitalSwitch, gbc);
        gbc.anchor = 10;
        gbc.gridwidth = 1;
        gbc.gridheight = 4;
        gbc.fill = 3;
        gbc.gridx = 2;
        gbc.gridy = 2;
        this.positionProgressBar.setBorderPainted(true);
        this.positionProgressBar.setValue(400);
        this.positionProgressBar.setStringPainted(true);
        this.add((Component)this.positionProgressBar, gbc);
        gbc.gridheight = 1;
        JPanel errorjPanel = new JPanel();
        errorjPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        this.inErrorDigitalSwitch.setSize(60);
        this.inErrorDigitalSwitch.setColor(Color.RED);
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        errorjPanel.add((Component)this.inErrorDigitalSwitch, gbc1);
        ++gbc1.gridy;
        errorjPanel.add((Component)this.inErrorjLabel, gbc1);
        ++gbc1.gridy;
        errorjPanel.add((Component)this.standbySensorsErrorjLabel, gbc1);
        ++gbc1.gridy;
        errorjPanel.add((Component)this.handoffSensorsErrorjLabel, gbc1);
        gbc.gridx = 3;
        gbc.gridy = 4;
        gbc.anchor = 10;
        gbc.gridheight = 1;
        this.add((Component)errorjPanel, gbc);
        JPanel paramPanel = new JPanel();
        paramPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        paramPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = Tools.insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = 21;
        paramPanel.add((Component)this.acjLabel, gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)this.spjLabel, gbc2);
        ++gbc2.gridy;
        paramPanel.add((Component)this.cujLabel, gbc2);
        ++gbc2.gridx;
        gbc2.gridy = 0;
        gbc2.anchor = 22;
        this.actualPositionjLabel.setText("0");
        paramPanel.add((Component)this.actualPositionjLabel, gbc2);
        ++gbc2.gridy;
        this.speedjLabel.setText("0");
        paramPanel.add((Component)this.speedjLabel, gbc2);
        ++gbc2.gridy;
        this.currentjLabel.setText("0");
        paramPanel.add((Component)this.currentjLabel, gbc2);
        gbc.gridx = 3;
        gbc.gridy = 2;
        this.add((Component)paramPanel, gbc);
        JPanel generalInfoPanel = new JPanel();
        generalInfoPanel.setBorder(BorderFactory.createTitledBorder("General Informations"));
        generalInfoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        gbc3.anchor = 21;
        generalInfoPanel.add((Component)this.onjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.hojLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.stjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.smjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.cmjLabel, gbc3);
        ++gbc3.gridx;
        gbc3.gridy = 0;
        gbc3.anchor = 22;
        generalInfoPanel.add((Component)this.onlinePositionjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.handoffPositionjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.standbyPositionjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.speedMaxjLabel, gbc3);
        ++gbc3.gridy;
        generalInfoPanel.add((Component)this.currentMaxjLabel, gbc3);
        gbc.gridx = 3;
        gbc.gridy = 5;
        this.add((Component)generalInfoPanel, gbc);
        this.faultMasterCtlPanel = new JPanel();
        this.faultMasterCtlPanel.setBorder(BorderFactory.createTitledBorder("Master Ctl"));
        this.faultMasterCtlPanel.setLayout(new GridBagLayout());
        this.faultMasterCtlPanel.setPreferredSize(new Dimension(100, 100));
        this.faultMasterCtlSwitch.setColor(Color.GRAY);
        this.faultMasterCtlSwitch.setSize(50);
        GridBagConstraints gbcf = new GridBagConstraints();
        gbcf.insets = Tools.insets_std;
        gbcf.gridx = 0;
        gbcf.gridy = 0;
        gbcf.anchor = 10;
        this.faultMasterCtlPanel.add((Component)this.faultMasterCtlSwitch, gbcf);
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        this.add((Component)this.faultMasterCtlPanel, gbc);
        this.faultSlaveCtlPanel = new JPanel();
        this.faultSlaveCtlPanel.setBorder(BorderFactory.createTitledBorder("Slave Ctl"));
        this.faultSlaveCtlPanel.setLayout(new GridBagLayout());
        this.faultSlaveCtlPanel.setPreferredSize(new Dimension(100, 100));
        this.faultSlaveCtlSwitch.setColor(Color.GRAY);
        this.faultSlaveCtlSwitch.setSize(50);
        GridBagConstraints gbcfSlave = new GridBagConstraints();
        gbcfSlave.insets = Tools.insets_std;
        gbcfSlave.gridx = 0;
        gbcfSlave.gridy = 0;
        gbcfSlave.anchor = 10;
        this.faultSlaveCtlPanel.add((Component)this.faultSlaveCtlSwitch, gbcfSlave);
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        this.add((Component)this.faultSlaveCtlPanel, gbc);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc4 = new GridBagConstraints();
        gbc4.anchor = 23;
        gbc4.fill = 2;
        gbc4.insets = Tools.insets_std;
        gbc4.gridx = 0;
        gbc4.gridy = 0;
        controlPanel.add((Component)this.updateStateWithSensorsButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.updatePositionButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.goToOnlineButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.goToHandoffButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.goToStandbyButton, gbc4);
        ++gbc4.gridy;
        controlPanel.add((Component)this.abortButton, gbc4);
        gbc.gridx = 4;
        gbc.gridy = 3;
        gbc.weighty = 3.0;
        gbc.gridwidth = 2;
        this.add((Component)controlPanel, gbc);
    }

    private void updateStateWithSensorsActionPerformed(ActionEvent evt) {
        this.subs.updateStateWithSensors();
    }

    private void updatePositionActionPerformed(ActionEvent evt) {
        this.subs.updateTrucksPosition();
    }

    private void goToHandoffActionPerformed(ActionEvent evt) {
        this.subs.goToHandOff();
    }

    private void goToOnlineActionPerformed(ActionEvent evt) {
        this.subs.goToOnline();
    }

    private void goToStandbyActionPerformed(ActionEvent evt) {
        this.subs.goToStandby();
    }

    private void quickStopActionPerformed(ActionEvent evt) {
        this.subs.stopMyDestinationSubsystem();
    }

    private void abortActionPerformed(ActionEvent evt) {
        this.subs.abortAction();
    }

    @Override
    public String toString() {
        return "Trucks";
    }

    public static void main(String[] argv) {
        AutochangerTrucksPanel d = new AutochangerTrucksPanel();
        JFrame frame = new JFrame("Autochanger Trucks Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class GuiInitialization
    implements Runnable {
        AutochangerTrucksConfig autochangerTrucksConfig;

        public GuiInitialization(AutochangerTrucksConfig aConfig) {
            this.autochangerTrucksConfig = aConfig;
        }

        @Override
        public void run() {
            double standbyPositionInMm = this.autochangerTrucksConfig.getStandbyPosition() / 1000;
            double handoffPositionInMm = this.autochangerTrucksConfig.getHandoffPosition() / 1000;
            double onlinePositionInMm = this.autochangerTrucksConfig.getOnlinePosition() / 1000;
            AutochangerTrucksPanel.this.standbyPositionjLabel.setText(Double.toString(standbyPositionInMm));
            AutochangerTrucksPanel.this.handoffPositionjLabel.setText(Double.toString(handoffPositionInMm));
            AutochangerTrucksPanel.this.onlinePositionjLabel.setText(Double.toString(onlinePositionInMm));
            AutochangerTrucksPanel.this.speedMaxjLabel.setText(Integer.toString(this.autochangerTrucksConfig.getMaxSpeed()));
            AutochangerTrucksPanel.this.currentMaxjLabel.setText(Integer.toString(this.autochangerTrucksConfig.getMaxCurrent()));
            AutochangerTrucksPanel.this.positionProgressBar.setMinimum(this.autochangerTrucksConfig.getStandbyPosition());
            AutochangerTrucksPanel.this.positionProgressBar.setMaximum(this.autochangerTrucksConfig.getOnlinePosition());
            AutochangerTrucksPanel.this.positionProgressBar.setValue(0);
            AutochangerTrucksPanel.this.faultMasterCtlSwitch.setColor(Color.GRAY);
        }
    }

    class UpdateTrucks
    implements Runnable {
        StatusDataPublishedByAutoChangerTrucks s;

        public UpdateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
            this.s = status;
        }

        @Override
        public void run() {
            AutochangerMainPanel.fcslog.debug((Object)("update of Trucks Panel with s=" + this.s.toString()));
            AutochangerTrucksPanel.this.handoffDigitalSwitch.setColor(this.s.getHandoffSensorValue0() == 1 && this.s.getHandoffSensorValue1() == 1 ? Tools.greenColor : Color.gray);
            AutochangerTrucksPanel.this.onlineDigitalSwitch.setColor(this.s.getOnlineSensorValue0() == 1 && this.s.getOnlineSensorValue1() == 1 ? Tools.greenColor : Color.gray);
            AutochangerTrucksPanel.this.standbyDigitalSwitch.setColor(this.s.getStandbySensorValue0() == 1 && this.s.getStandbySensorValue1() == 1 ? Tools.greenColor : Color.gray);
            AutochangerTrucksPanel.this.inTravelDigitalSwitch.setColor(this.s.getHandoffSensorValue0() == 0 && this.s.getHandoffSensorValue1() == 0 && this.s.getOnlineSensorValue0() == 0 && this.s.getOnlineSensorValue1() == 0 && this.s.getStandbySensorValue0() == 0 && this.s.getStandbySensorValue1() == 0 ? Color.YELLOW : Color.gray);
            AutochangerTrucksPanel.this.inErrorDigitalSwitch.setColor(this.s.isHandoffInError() || this.s.isStandbyInError() ? Color.RED : Tools.greenColor);
            AutochangerTrucksPanel.this.inErrorjLabel.setText(this.s.isHandoffInError() || this.s.isStandbyInError() ? "IN ERROR" : "NO ERROR");
            AutochangerTrucksPanel.this.handoffSensorsErrorjLabel.setText(this.s.isHandoffInError() ? "<HTML>Handoff sensors<BR>in error</HTML>" : null);
            AutochangerTrucksPanel.this.standbySensorsErrorjLabel.setText(this.s.isStandbyInError() ? "<HTML>Standby sensors<BR>in error</HTML>" : null);
            AutochangerTrucksPanel.this.positionProgressBar.setValue(this.s.getPosition());
            AutochangerTrucksPanel.this.positionProgressBar.setForeground(Color.PINK);
            AutochangerTrucksPanel.this.actualPositionjLabel.setText(Integer.toString(this.s.getPosition()));
            AutochangerTrucksPanel.this.speedjLabel.setText(Integer.toString(this.s.getSpeed()));
            AutochangerTrucksPanel.this.currentjLabel.setText(Integer.toString(this.s.getCurrent()));
            AutochangerTrucksPanel.this.faultMasterCtlSwitch.setColor(this.s.isMasterControllerInFault() ? Color.RED : Tools.greenColor);
            AutochangerTrucksPanel.this.faultSlaveCtlSwitch.setColor(this.s.isSlaveControllerInFault() ? Color.RED : Tools.greenColor);
        }
    }
}

