/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGatherPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AutochangerTreePanel
extends JPanel
implements TreeSelectionListener {
    String title;
    JTree tree;
    JPanel rightPanel;
    JSplitPane splitPane = new JSplitPane(1);
    JPanel helpPanel;
    AutochangerGatherPanel gatherPanel;

    public AutochangerTreePanel(String title) {
        this.title = title;
        this.initComponents();
    }

    public AutochangerTreePanel(String title, AutochangerGatherPanel gatherPanel) {
        this.title = title;
        this.gatherPanel = gatherPanel;
        this.initComponents();
    }

    public void createNodes(DefaultMutableTreeNode top) {
        if (this.gatherPanel == null) {
            this.gatherPanel = new AutochangerGatherPanel();
        }
        DefaultMutableTreeNode devicesNode = new DefaultMutableTreeNode("CANopen devices");
        devicesNode.add(new DefaultMutableTreeNode(this.gatherPanel.getHardwarePanel()));
        devicesNode.add(new DefaultMutableTreeNode(this.gatherPanel.getPlutoGatewayPanel()));
        devicesNode.add(new DefaultMutableTreeNode(this.gatherPanel.getLatchXminusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(this.gatherPanel.getLatchXplusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(this.gatherPanel.getLinearRailSlaveControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(this.gatherPanel.getLinearRailMasterControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(this.gatherPanel.getOnlineClampXminusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(this.gatherPanel.getOnlineClampXplusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(this.gatherPanel.getOnlineClampZControllerPanel()));
        top.add(devicesNode);
        top.add(new DefaultMutableTreeNode(this.gatherPanel.getAcGeneralViewPanel()));
        top.add(new DefaultMutableTreeNode(this.gatherPanel.getAcLatchesPanel()));
        top.add(new DefaultMutableTreeNode(this.gatherPanel.getAcTrucksPanel()));
        top.add(new DefaultMutableTreeNode(this.gatherPanel.getAcClampsPanel()));
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), this.title));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(this.title);
        this.createNodes(top);
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.setMinimumSize(new Dimension(110, 100));
        this.splitPane.setLeftComponent(this.tree);
        this.rightPanel = new JPanel();
        this.splitPane.setRightComponent(this.rightPanel);
        this.splitPane.setDividerLocation(200);
        this.splitPane.setPreferredSize(Tools.preferedPanelSize);
        this.add(this.splitPane);
        this.helpPanel = new JPanel();
        JLabel helpLabel = new JLabel("Nothing to display");
        this.helpPanel.add(helpLabel);
    }

    private void displayPanel(JPanel panel) {
        if (panel != null) {
            JScrollPane scrollPane = new JScrollPane(panel);
            this.splitPane.setRightComponent(scrollPane);
        } else {
            JScrollPane scrollPane = new JScrollPane(this.helpPanel);
            this.splitPane.setRightComponent(scrollPane);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        if (nodeInfo == null) {
            return;
        }
        if (node.isLeaf()) {
            JPanel panel = (JPanel)nodeInfo;
            this.displayPanel(panel);
        }
    }

    public static void main(String[] argv) {
        AutochangerTreePanel d = new AutochangerTreePanel("Autochanger");
        JFrame frame = new JFrame("Autochanger Top Tree Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

