/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGeneralGUI;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerOnlineClampPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AutochangerThreeOnlineClampsPanel
extends JPanel {
    private AutochangerGeneralGUI subs;
    private final JLabel clampsState = new JLabel("UNKNOWN STATE");
    private final JLabel clampsStateLabel = new JLabel("CLAMPS STATE :");
    private final JLabel xMinusLabel = new JLabel("X-");
    private final JLabel xMinuxLabel2 = new JLabel("X-");
    private final JLabel xPlusLabel = new JLabel("X+");
    private final JLabel xPlusLabel2 = new JLabel("X+");
    private final JLabel yLabel = new JLabel("Y-");
    private final JLabel yLabel2 = new JLabel("Y-");
    JPanel clampsPanel = new JPanel();
    JPanel clampsStatePanel = new JPanel();
    JPanel controlPanel = new JPanel();
    AutochangerOnlineClampPanel clampXminusPanel;
    AutochangerOnlineClampPanel clampXplusPanel;
    AutochangerOnlineClampPanel clampYPanel;
    private final JButton lockClampsButton = new JButton("Lock Clamps");
    private final JButton unlockClampsButton = new JButton("Unlock Clamps");
    private final JButton updateStateWithSensorsButton = new JButton("Read sensors and update state");
    private final JButton abortButton = new JButton("Abort");

    public AutochangerThreeOnlineClampsPanel() {
        this.initComponents();
    }

    public void setSubsystem(AutochangerGeneralGUI subs) {
        this.subs = subs;
    }

    void initializeGui(AutochangerConfig autochangerConfig) {
    }

    void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        SwingUtilities.invokeLater(new UpdateClamps(s));
    }

    public void updateClampXminus(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.clampXminusPanel.updateClamp(s);
    }

    public void updateClampXplus(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.clampXplusPanel.updateClamp(s);
    }

    public void updateClampZ(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.clampYPanel.updateClamp(s);
    }

    private void initComponents() {
        this.updateStateWithSensorsButton.addActionListener(evt -> this.updateStateWithSensorsButtonActionPerformed(evt));
        this.lockClampsButton.addActionListener(evt -> this.lockClampsButtonActionPerformed(evt));
        this.unlockClampsButton.addActionListener(evt -> this.unlockClampsButtonActionPerformed(evt));
        this.abortButton.addActionListener(evt -> this.abortButtonActionPerformed(evt));
        Font xFont = new Font("Tahoma", 1, 18);
        this.xMinusLabel.setFont(xFont);
        this.xMinuxLabel2.setFont(xFont);
        this.xPlusLabel2.setFont(xFont);
        this.xPlusLabel.setFont(xFont);
        this.yLabel.setFont(xFont);
        this.yLabel2.setFont(xFont);
        this.clampXminusPanel = new AutochangerOnlineClampPanel();
        this.clampXplusPanel = new AutochangerOnlineClampPanel();
        this.clampYPanel = new AutochangerOnlineClampPanel();
        this.clampsState.setFont(Tools.bigFont);
        this.clampsState.setBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(255, 255, 255)));
        this.clampsStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = Tools.insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        this.clampsStatePanel.add((Component)this.clampsStateLabel, gbc2);
        ++gbc2.gridx;
        this.clampsStatePanel.add((Component)this.clampsState, gbc2);
        this.clampsPanel.setLayout(new GridBagLayout());
        this.clampsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.YELLOW), "ONLINE Clamps"));
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = Tools.insets_std;
        this.clampXminusPanel.setClampName("OnlineClamp 1");
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        this.clampsPanel.add((Component)this.clampXminusPanel, gbc1);
        this.clampXplusPanel.setClampName("OnlineClamp 2");
        ++gbc1.gridx;
        this.clampsPanel.add((Component)this.clampXplusPanel, gbc1);
        this.clampYPanel.setClampName("OnlineClamp 3");
        gbc1.gridx = 0;
        ++gbc1.gridy;
        gbc1.gridwidth = 2;
        this.clampsPanel.add((Component)this.clampYPanel, gbc1);
        this.controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.anchor = 23;
        gbc3.fill = 2;
        gbc3.insets = Tools.insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        this.controlPanel.add((Component)this.updateStateWithSensorsButton, gbc3);
        ++gbc3.gridy;
        this.controlPanel.add((Component)this.lockClampsButton, gbc3);
        ++gbc3.gridy;
        this.controlPanel.add((Component)this.unlockClampsButton, gbc3);
        ++gbc3.gridy;
        this.controlPanel.add((Component)this.abortButton, gbc3);
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.PINK), "AUTOCHANGER ONLINE CLAMPS"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_std;
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.xMinusLabel, gbc);
        gbc.anchor = 13;
        gbc.gridx = 3;
        this.add((Component)this.xPlusLabel, gbc);
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.anchor = 10;
        this.add((Component)this.clampsStatePanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.clampsPanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.yLabel, gbc);
        gbc.insets = Tools.insets_big;
        gbc.insets = new Insets(14, 30, 6, 30);
        gbc.gridx = 0;
        ++gbc.gridy;
        ++gbc.gridx;
        gbc.anchor = 13;
        this.add((Component)this.controlPanel, gbc);
    }

    private void updateStateWithSensorsButtonActionPerformed(ActionEvent evt) {
        this.subs.updateStateWithSensors();
    }

    private void lockClampsButtonActionPerformed(ActionEvent evt) {
        this.subs.lockOnlineClamps();
    }

    private void unlockClampsButtonActionPerformed(ActionEvent evt) {
        this.subs.unlockOnlineClamps();
    }

    private void abortButtonActionPerformed(ActionEvent evt) {
        this.subs.abortAction();
    }

    @Override
    public String toString() {
        return "ONLINE Clamps";
    }

    public static void main(String[] argv) {
        AutochangerThreeOnlineClampsPanel d = new AutochangerThreeOnlineClampsPanel();
        JFrame frame = new JFrame("Autochanger Clamps Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateClamps
    implements Runnable {
        StatusDataPublishedByAutochangerThreeClamps s;

        public UpdateClamps(StatusDataPublishedByAutochangerThreeClamps status) {
            this.s = status;
        }

        @Override
        public void run() {
            AutochangerThreeOnlineClampsPanel.this.clampsState.setText(this.s.getLockStatus().getText());
            AutochangerThreeOnlineClampsPanel.this.clampsState.setForeground(this.s.getLockStatus().getColor());
        }
    }
}

