/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerOnlineClampConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.utilities.logging.Logger;

public class AutochangerOnlineClampPanel
extends JPanel {
    private static final Logger fcslog = Tools.fcslog;
    private DigitalSwitch lockSensorDS;
    private DigitalSwitch lockSensorCDS;
    private DigitalSwitch unlockSensorDS;
    private DigitalSwitch unlockSensorCDS;
    private DigitalSwitch errorDS;
    private JLabel clampName;
    private JLabel lockLabel;
    private JLabel unlockLabel;
    private JLabel errorLabel;
    private JLabel lockStatus;
    private JPanel paramPanel;
    JLabel ctlLabel = new JLabel("current to lock:");
    JLabel ctuLabel = new JLabel("current to unlock:");
    JLabel ctcLabel = new JLabel("current to clamp:");
    JLabel ttLabel = new JLabel("time to travel:");
    JLabel htLabel = new JLabel("hold time:");
    JLabel currentToLockLabel = new JLabel("2000");
    JLabel currentToUnlockLabel = new JLabel("0");
    JLabel currentToClampLabel = new JLabel("0");
    JLabel holdTimeLabel = new JLabel("12000");
    JLabel travelTimeLabel = new JLabel("0");
    JPanel faultPanel;
    DigitalSwitch faultSwitch;

    public AutochangerOnlineClampPanel() {
        this.initComponents();
    }

    void setClampName(String name) {
        this.clampName.setText(name);
    }

    public void initializeGui(AutochangerOnlineClampConfig config) {
        SwingUtilities.invokeLater(new GuiInitialization(config));
    }

    public void updateClamp(StatusDataPublishedByAutochangerOnlineClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    private void initComponents() {
        this.lockSensorDS = new DigitalSwitch();
        this.lockSensorDS.setColor(Color.gray);
        this.lockSensorCDS = new DigitalSwitch();
        this.lockSensorCDS.setColor(Color.gray);
        this.unlockSensorDS = new DigitalSwitch();
        this.unlockSensorDS.setColor(Color.gray);
        this.unlockSensorCDS = new DigitalSwitch();
        this.unlockSensorCDS.setColor(Color.gray);
        this.errorDS = new DigitalSwitch();
        this.errorDS.setColor(Color.gray);
        this.clampName = new JLabel("myClamp");
        this.unlockLabel = new JLabel("<html><P align=\"center\">UNLOCK<br>SENSOR</p></html>");
        this.lockLabel = new JLabel("<html><P align=\"center\">LOCK<br>SENSOR</p></html>");
        this.errorLabel = new JLabel("ERROR");
        this.lockStatus = new JLabel("UNKNOWN STATE");
        this.paramPanel = new JPanel();
        this.paramPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.paramPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcp = new GridBagConstraints();
        gbcp.insets = Tools.insets_std;
        gbcp.gridx = 0;
        gbcp.gridy = 0;
        gbcp.anchor = 21;
        this.paramPanel.add((Component)this.ctlLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.ctuLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.ctcLabel, gbcp);
        gbcp.anchor = 22;
        gbcp.gridx = 1;
        gbcp.gridy = 0;
        this.paramPanel.add((Component)this.currentToLockLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.currentToUnlockLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.currentToClampLabel, gbcp);
        gbcp.anchor = 21;
        gbcp.gridx = 2;
        gbcp.gridy = 0;
        this.paramPanel.add((Component)this.ttLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.htLabel, gbcp);
        gbcp.anchor = 22;
        gbcp.gridx = 3;
        gbcp.gridy = 0;
        this.paramPanel.add((Component)this.travelTimeLabel, gbcp);
        ++gbcp.gridy;
        this.paramPanel.add((Component)this.holdTimeLabel, gbcp);
        this.faultPanel = new JPanel();
        this.faultSwitch = new DigitalSwitch();
        this.faultSwitch.setColor(Color.GRAY);
        this.faultPanel.setBorder(BorderFactory.createTitledBorder("Controller"));
        this.faultPanel.setLayout(new GridBagLayout());
        this.faultPanel.setPreferredSize(new Dimension(100, 100));
        this.faultSwitch.setColor(Color.GRAY);
        this.faultSwitch.setSize(50);
        GridBagConstraints gbcf = new GridBagConstraints();
        gbcf.insets = Tools.insets_std;
        gbcf.gridx = 0;
        gbcf.gridy = 0;
        gbcf.anchor = 10;
        this.faultPanel.add((Component)this.faultSwitch, gbcf);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = Tools.insets_big;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.clampName, gbc);
        ++gbc.gridy;
        this.add((Component)this.lockStatus, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.add((Component)this.unlockSensorDS, gbc);
        ++gbc.gridy;
        this.add((Component)this.unlockLabel, gbc);
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.add((Component)this.lockSensorDS, gbc);
        ++gbc.gridy;
        this.add((Component)this.lockLabel, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        this.add((Component)this.errorDS, gbc);
        ++gbc.gridy;
        this.add((Component)this.errorLabel, gbc);
        gbc.gridx = 5;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        this.add((Component)this.faultPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 5;
        this.add((Component)this.paramPanel, gbc);
    }

    @Override
    public String toString() {
        return "ONLINE Clamp";
    }

    public static void main(String[] argv) {
        AutochangerOnlineClampPanel d = new AutochangerOnlineClampPanel();
        JFrame frame = new JFrame("Autochanger OnlineClamp Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private class GuiInitialization
    implements Runnable {
        AutochangerOnlineClampConfig clampConfig;

        public GuiInitialization(AutochangerOnlineClampConfig aConfig) {
            this.clampConfig = aConfig;
        }

        @Override
        public void run() {
            AutochangerOnlineClampPanel.this.currentToLockLabel.setText(Integer.toString(this.clampConfig.getCurrentToLock()));
            AutochangerOnlineClampPanel.this.currentToUnlockLabel.setText(Integer.toString(this.clampConfig.getCurrentToUnlock()));
            AutochangerOnlineClampPanel.this.currentToClampLabel.setText(Integer.toString(this.clampConfig.getCurrentToClamp()));
            AutochangerOnlineClampPanel.this.holdTimeLabel.setText(Integer.toString(this.clampConfig.getHoldTime()));
            AutochangerOnlineClampPanel.this.travelTimeLabel.setText(Integer.toString(this.clampConfig.getTravelTime()));
            AutochangerOnlineClampPanel.this.faultSwitch.setColor(Color.GRAY);
        }
    }

    class UpdateClamp
    implements Runnable {
        StatusDataPublishedByAutochangerOnlineClamp s;

        public UpdateClamp(StatusDataPublishedByAutochangerOnlineClamp status) {
            this.s = status;
        }

        @Override
        public void run() {
            AutochangerOnlineClampPanel.this.clampName.setText(this.s.getName());
            AutochangerOnlineClampPanel.this.lockStatus.setText(this.s.getLockStatus().getText());
            AutochangerOnlineClampPanel.this.lockStatus.setBackground(this.s.getLockStatus().getColor());
            if (this.s.isLockSensorInError()) {
                AutochangerOnlineClampPanel.this.lockSensorDS.setColor(Color.red);
            } else {
                AutochangerOnlineClampPanel.this.lockSensorDS.setColor(this.s.getLockSensorValue() == 1 ? Tools.greenColor : Color.gray);
            }
            if (this.s.isUnlockSensorInError()) {
                AutochangerOnlineClampPanel.this.unlockSensorDS.setColor(Color.red);
            } else {
                AutochangerOnlineClampPanel.this.unlockSensorDS.setColor(this.s.getUnlockSensorValue() == 1 ? Tools.greenColor : Color.gray);
            }
            boolean inTravel = this.s.getLockStatus().equals((Object)FcsEnumerations.LockStatus.INTRAVEL);
            boolean unknown = this.s.getLockStatus().equals((Object)FcsEnumerations.LockStatus.UNKNOWN);
            if (this.s.isInError() || inTravel || unknown) {
                AutochangerOnlineClampPanel.this.errorDS.setColor(this.s.getLockStatus().getColor());
                AutochangerOnlineClampPanel.this.errorLabel.setText(this.s.getLockStatus().getText());
            } else {
                AutochangerOnlineClampPanel.this.errorDS.setColor(FcsEnumerations.LockStatus.NOERROR.getColor());
                AutochangerOnlineClampPanel.this.errorLabel.setText(FcsEnumerations.LockStatus.NOERROR.getText());
            }
            AutochangerOnlineClampPanel.this.faultSwitch.setColor(this.s.isControllerInFault() ? Color.RED : Tools.greenColor);
        }
    }
}

