/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;

public class AutochangerGeneralViewPanel
extends JPanel {
    private final JPanel loaderConnectedPanel = new JPanel();
    JLabel loaderConnectedLabel = new JLabel("<html><P align=\"center\">Loader<br>sensor</p></html>");
    DigitalSwitch loaderConnectedDigitalSwitch = new DigitalSwitch();
    String connectedS = "<html><P align=\"center\">Loader<br>connected</p></html>";
    String notConnectedS = "<html><P align=\"center\">Loader<br>not<br>connected</p></html>";
    private JPanel latchesStatePanel;
    private JPanel clampsStatePanel;
    private final FilterPanel filterPanel = new FilterPanel();
    private JPanel trucksStatePanel;
    private final DigitalSwitch standbyDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inTravelDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch handoffDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch onlineDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch inErrorDigitalSwitch = new DigitalSwitch();
    private final JLabel standbyjLabel = new JLabel("STANDBY");
    private final JLabel inTraveljLabel = new JLabel("In Travel");
    private final JLabel handoffjLabel = new JLabel("HAND-OFF");
    private final JLabel onlinejLabel = new JLabel("ONLINE");
    private final JLabel inErrorjLabel = new JLabel("IN ERROR");
    JLabel clSLabel = new JLabel("Online Clamps State:");
    JLabel clampsStateLabel = new JLabel("UNKNOWN");
    JLabel laSLabel = new JLabel("Latches State:");
    JLabel latchesStateLabel = new JLabel("UNKNOWN");
    JLabel trLabel = new JLabel("Trucks position in mm:");
    JLabel trucksPositionLabel = new JLabel("0");
    JLabel trucksEnumPositionLabel = new JLabel("UNKNOWN");

    public AutochangerGeneralViewPanel() {
        this.initComponents();
    }

    void initializeGui(AutochangerConfig autochangerConfig) {
    }

    void updateAutochanger(StatusDataPublishedByAutoChanger s) {
        SwingUtilities.invokeLater(new UpdateAutochanger(s));
    }

    void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        SwingUtilities.invokeLater(new UpdateTrucks(s));
    }

    void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        SwingUtilities.invokeLater(new UpdateLatches(s));
    }

    void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        SwingUtilities.invokeLater(new UpdateClamps(s));
    }

    private void initComponents() {
        this.loaderConnectedDigitalSwitch.setColor(Color.GRAY);
        GridBagConstraints gbc0 = new GridBagConstraints();
        this.loaderConnectedPanel.setBorder(BorderFactory.createLineBorder(Color.pink, 6));
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        this.loaderConnectedPanel.add((Component)this.loaderConnectedLabel, gbc0);
        ++gbc0.gridy;
        this.loaderConnectedPanel.add((Component)this.loaderConnectedDigitalSwitch, gbc0);
        this.latchesStatePanel = new JPanel();
        GridBagConstraints gbc1 = new GridBagConstraints();
        this.latchesStatePanel.setBorder(BorderFactory.createTitledBorder("Latches State"));
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        this.latchesStatePanel.add((Component)this.laSLabel, gbc1);
        ++gbc1.gridy;
        this.latchesStatePanel.add((Component)this.latchesStateLabel, gbc1);
        this.filterPanel.setColor(Color.gray);
        this.filterPanel.setSize(120);
        this.standbyDigitalSwitch.setColor(Color.gray);
        this.inTravelDigitalSwitch.setColor(Color.gray);
        this.handoffDigitalSwitch.setColor(Color.gray);
        this.onlineDigitalSwitch.setColor(Color.gray);
        this.inErrorDigitalSwitch.setColor(Color.gray);
        this.trucksStatePanel = new JPanel();
        this.trucksStatePanel.setBorder(BorderFactory.createTitledBorder("Trucks State"));
        this.trucksStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = Tools.insets_big;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        this.trucksStatePanel.add((Component)this.trLabel, gbc2);
        ++gbc2.gridy;
        this.trucksStatePanel.add((Component)this.trucksPositionLabel, gbc2);
        ++gbc2.gridx;
        gbc2.gridy = 0;
        this.trucksStatePanel.add((Component)this.inErrorDigitalSwitch, gbc2);
        ++gbc2.gridy;
        this.trucksStatePanel.add((Component)this.inErrorjLabel, gbc2);
        ++gbc2.gridx;
        gbc2.gridy = 0;
        this.trucksStatePanel.add((Component)this.inTravelDigitalSwitch, gbc2);
        ++gbc2.gridy;
        this.trucksStatePanel.add((Component)this.inTraveljLabel, gbc2);
        ++gbc2.gridx;
        gbc2.gridy = 0;
        this.trucksStatePanel.add((Component)this.standbyDigitalSwitch, gbc2);
        ++gbc2.gridy;
        this.trucksStatePanel.add((Component)this.standbyjLabel, gbc2);
        ++gbc2.gridx;
        gbc2.gridy = 0;
        this.trucksStatePanel.add((Component)this.handoffDigitalSwitch, gbc2);
        ++gbc2.gridy;
        this.trucksStatePanel.add((Component)this.handoffjLabel, gbc2);
        ++gbc2.gridx;
        gbc2.gridy = 0;
        this.trucksStatePanel.add((Component)this.onlineDigitalSwitch, gbc2);
        ++gbc2.gridy;
        this.trucksStatePanel.add((Component)this.onlinejLabel, gbc2);
        this.clampsStatePanel = new JPanel();
        GridBagConstraints gbc3 = new GridBagConstraints();
        this.clampsStatePanel.setBorder(BorderFactory.createTitledBorder("ONLINE clamps State"));
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        this.clampsStatePanel.add((Component)this.clSLabel, gbc3);
        ++gbc3.gridx;
        this.clampsStatePanel.add((Component)this.clampsStateLabel, gbc3);
        GridBagConstraints gbc = new GridBagConstraints();
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), "AUTOCHANGER General View"));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        gbc.anchor = 512;
        gbc.insets = Tools.insets_big;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.loaderConnectedPanel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.clampsStatePanel, gbc);
        ++gbc.gridy;
        this.add((Component)this.latchesStatePanel, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 10;
        gbc.gridheight = 2;
        this.add((Component)this.filterPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridheight = 1;
        gbc.gridwidth = 2;
        gbc.anchor = 512;
        this.add((Component)this.trucksStatePanel, gbc);
    }

    @Override
    public String toString() {
        return "General View";
    }

    public static void main(String[] argv) {
        AutochangerGeneralViewPanel d = new AutochangerGeneralViewPanel();
        JFrame frame = new JFrame("Autochanger GeneralView Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    class UpdateAutochanger
    implements Runnable {
        StatusDataPublishedByAutoChanger s;

        public UpdateAutochanger(StatusDataPublishedByAutoChanger status) {
            this.s = status;
        }

        @Override
        public void run() {
            if (this.s.isLoaderConnectedSensorsInError()) {
                AutochangerGeneralViewPanel.this.loaderConnectedDigitalSwitch.setColor(Color.RED);
            } else if (this.s.getLoaderConnectedSensorValue0() == 1 && this.s.getLoaderConnectedSensorValue1() == 1) {
                AutochangerGeneralViewPanel.this.loaderConnectedDigitalSwitch.setColor(Tools.greenColor);
                AutochangerGeneralViewPanel.this.loaderConnectedLabel.setText(AutochangerGeneralViewPanel.this.connectedS);
            } else {
                AutochangerGeneralViewPanel.this.loaderConnectedDigitalSwitch.setColor(Color.gray);
                AutochangerGeneralViewPanel.this.loaderConnectedLabel.setText(AutochangerGeneralViewPanel.this.notConnectedS);
            }
        }
    }

    class UpdateClamps
    implements Runnable {
        StatusDataPublishedByAutochangerThreeClamps s;

        public UpdateClamps(StatusDataPublishedByAutochangerThreeClamps status) {
            this.s = status;
        }

        @Override
        public void run() {
            AutochangerGeneralViewPanel.this.clampsStateLabel.setText(this.s.getLockStatus().toString());
            AutochangerGeneralViewPanel.this.clampsStateLabel.setBackground(this.s.getLockStatus().getColor());
        }
    }

    class UpdateLatches
    implements Runnable {
        StatusDataPublishedByAutochangerTwoLatches s;

        public UpdateLatches(StatusDataPublishedByAutochangerTwoLatches status) {
            this.s = status;
        }

        @Override
        public void run() {
            AutochangerGeneralViewPanel.this.latchesStateLabel.setText(this.s.getLockStatus().toString());
            AutochangerGeneralViewPanel.this.latchesStateLabel.setBackground(this.s.getLockStatus().getColor());
            AutochangerGeneralViewPanel.this.filterPanel.setIsFilterInHouse(this.s.getFilterPresenceStatus().equals((Object)FcsEnumerations.FilterPresenceStatus.ENGAGED));
            if (this.s.getFilterPresenceStatus().equals((Object)FcsEnumerations.FilterPresenceStatus.UNKNOWN)) {
                AutochangerGeneralViewPanel.this.filterPanel.setColor(Color.YELLOW);
            }
        }
    }

    class UpdateTrucks
    implements Runnable {
        StatusDataPublishedByAutoChangerTrucks s;

        public UpdateTrucks(StatusDataPublishedByAutoChangerTrucks status) {
            this.s = status;
        }

        @Override
        public void run() {
            double actualPositionInMm = this.s.getPosition() / 1000;
            AutochangerGeneralViewPanel.this.trucksPositionLabel.setText(Double.toString(actualPositionInMm));
            AutochangerGeneralViewPanel.this.handoffDigitalSwitch.setColor(this.s.getHandoffSensorValue0() == 1 && this.s.getHandoffSensorValue1() == 1 ? Tools.greenColor : Color.gray);
            AutochangerGeneralViewPanel.this.onlineDigitalSwitch.setColor(this.s.getOnlineSensorValue0() == 1 && this.s.getOnlineSensorValue1() == 1 ? Tools.greenColor : Color.gray);
            AutochangerGeneralViewPanel.this.standbyDigitalSwitch.setColor(this.s.getStandbySensorValue0() == 1 && this.s.getStandbySensorValue1() == 1 ? Tools.greenColor : Color.gray);
            AutochangerGeneralViewPanel.this.inTravelDigitalSwitch.setColor(this.s.getHandoffSensorValue0() == 0 && this.s.getHandoffSensorValue1() == 0 && this.s.getOnlineSensorValue0() == 0 && this.s.getOnlineSensorValue1() == 0 && this.s.getStandbySensorValue0() == 0 && this.s.getStandbySensorValue1() == 0 ? Color.YELLOW : Color.gray);
            AutochangerGeneralViewPanel.this.inErrorDigitalSwitch.setColor(this.s.isHandoffInError() || this.s.isStandbyInError() ? Color.RED : Tools.greenColor);
            AutochangerGeneralViewPanel.this.inErrorjLabel.setText(this.s.isHandoffInError() || this.s.isStandbyInError() ? "IN ERROR" : "NO ERROR");
        }
    }
}

