/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandError;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGatherPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerTopTabbedPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;

public class AutochangerGeneralGUI
extends GeneralGUI {
    private long lastHeartBeat = 0L;
    private long lastStateRequest = 0L;
    String stateCorrelId;
    private static final String trucksModuleName = "autochangerTrucks";
    private static final String clampsName = "onlineClamps";
    private static final String latchesName = "latches";
    long updateTrucksPositionTimeout;
    long timeoutForTrucksMotion;
    long timeoutForClosingClamps;
    long timeoutForOpeningClamps;
    long timeoutForClosingLatches;
    long timeoutForOpeningLatches;

    public AutochangerGeneralGUI(String name, String destination, AgentMessagingLayer aml) {
        super(name, destination, aml);
        this.topPanel = new AutochangerGatherPanel(this);
        this.pane = new JScrollPane(this.topPanel);
        this.updateTrucksPositionTimeout = 1000L;
        this.timeoutForTrucksMotion = 60000L;
        this.timeoutForClosingClamps = 10000L;
        this.timeoutForOpeningClamps = 10000L;
        this.timeoutForClosingLatches = 10000L;
        this.timeoutForOpeningLatches = 10000L;
    }

    public void setTimeoutForTrucksMotion(long timeoutForTrucksMotion) {
        this.timeoutForTrucksMotion = timeoutForTrucksMotion;
    }

    public void onDataArrival(String source, long timestamp, String dataType, Object s) {
        block59: {
            block57: {
                if (!source.equals(this.destination)) {
                    return;
                }
                if (!this.initialized) break block57;
                switch (dataType) {
                    case "tcpProxy": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:tcpProxy"));
                        ((AutochangerGatherPanel)this.topPanel).updateCanOpenHardwarePanel((StatusDataPublishedByHardware)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "autochangerGeneral": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:autochangerGeneral"));
                        ((AutochangerGatherPanel)this.topPanel).updateAutochanger((StatusDataPublishedByAutoChanger)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "linearRailMasterController": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:linearRailMasterController"));
                        ((AutochangerGatherPanel)this.topPanel).updateLinearRailMasterController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "linearRailSlaveController": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:linearRailSlaveController"));
                        ((AutochangerGatherPanel)this.topPanel).updateLinearRailSlaveController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "latchXminusController": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:latchXminusController"));
                        ((AutochangerTopTabbedPanel)this.topPanel).updateLatchXminusController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "latchXplusController": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:latchXplusController"));
                        ((AutochangerGatherPanel)this.topPanel).updateLatchXplusController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "onlineClampXminusController": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:onlineClampXminusController"));
                        ((AutochangerGatherPanel)this.topPanel).updateOnlineClampXminusController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "onlineClampXplusController": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:onlineClampXplusController"));
                        ((AutochangerGatherPanel)this.topPanel).updateOnlineClampXplusController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "onlineClampZController": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:onlineClampZController"));
                        ((AutochangerGatherPanel)this.topPanel).updateOnlineClampZController((StatusDataPublishedByEPOSController)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "autochangerTrucks": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:autochangerTrucks"));
                        fcslog.finest((Object)(String.valueOf(this.getName()) + " Data published by Trucks= " + ((StatusDataPublishedByAutoChangerTrucks)s).toString()));
                        ((AutochangerGatherPanel)this.topPanel).updateTrucks((StatusDataPublishedByAutoChangerTrucks)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "latchXminus": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:latchXminus"));
                        fcslog.finest((Object)(String.valueOf(this.getName()) + " Data published by Latch= " + ((StatusDataPublishedByAutochangerLatch)s).toString()));
                        ((AutochangerGatherPanel)this.topPanel).updateLatch((StatusDataPublishedByAutochangerLatch)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "latchXplus": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:latchXplus"));
                        fcslog.finest((Object)(String.valueOf(this.getName()) + " Data published by Latch= " + ((StatusDataPublishedByAutochangerLatch)s).toString()));
                        ((AutochangerGatherPanel)this.topPanel).updateLatch((StatusDataPublishedByAutochangerLatch)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "autochangerLatches": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:autochangerLatches"));
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " Data published by Latches= " + ((StatusDataPublishedByAutochangerTwoLatches)s).toString()));
                        ((AutochangerGatherPanel)this.topPanel).updateLatches((StatusDataPublishedByAutochangerTwoLatches)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "onlineClampXminus": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:onlineClampXminus"));
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " Data published by ClampXminus= " + ((StatusDataPublishedByAutochangerOnlineClamp)s).toString()));
                        ((AutochangerGatherPanel)this.topPanel).updateClampXminus((StatusDataPublishedByAutochangerOnlineClamp)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "onlineClampXplus": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:onlineClampXplus"));
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " Data published by ClampXplus= " + ((StatusDataPublishedByAutochangerOnlineClamp)s).toString()));
                        ((AutochangerGatherPanel)this.topPanel).updateClampXplus((StatusDataPublishedByAutochangerOnlineClamp)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "onlineClampZ": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:onlineClampZ"));
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " Data published by ClampZ= " + ((StatusDataPublishedByAutochangerOnlineClamp)s).toString()));
                        ((AutochangerGatherPanel)this.topPanel).updateClampZ((StatusDataPublishedByAutochangerOnlineClamp)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "autochangerClamps": {
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " read data dataType:autochangerClamps"));
                        fcslog.debug((Object)(String.valueOf(this.getName()) + " Data published by Clamps= " + ((StatusDataPublishedByAutochangerThreeClamps)s).toString()));
                        ((AutochangerGatherPanel)this.topPanel).updateClamps((StatusDataPublishedByAutochangerThreeClamps)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    default: {
                        fcslog.warning((Object)(String.valueOf(this.getName()) + " An unexpected dataType was read on the status bus:" + dataType));
                        break;
                    }
                }
                break block59;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastStateRequest > 2000L) {
                this.lastStateRequest = currentTime;
                CommandRequest cmd = new CommandRequest(this.destination, "getFullState");
                this.aml.sendCommandRequest(cmd, new CommandOriginator(){

                    public void processAck(CommandAck ack) {
                    }

                    public void processResult(CommandResult result) {
                        AutochangerConfig config = (AutochangerConfig)result.getReply();
                        fcslog.debug((Object)"--- Got a reply from subs");
                        ((AutochangerGatherPanel)AutochangerGeneralGUI.this.topPanel).initializeGui(config);
                        AutochangerGeneralGUI.this.initialized = true;
                        AutochangerGeneralGUI.this.sendAsynchronousCommand(new CommandRequest(AutochangerGeneralGUI.this.destination, "updateStateWithSensors"));
                    }

                    public void processNack(CommandNack nack) {
                    }

                    public void processError(CommandError nack) {
                    }
                });
            }
        }
    }

    public void updateTrucksPosition() {
        System.out.println("Autochanger updating Trucks position");
        fcslog.info((Object)"Autochanger updating Trucks position");
        fcslog.info((Object)("/timeout=" + this.updateTrucksPositionTimeout));
        new GeneralGUI.CommandSwingWorker("updatePosition", this.updateTrucksPositionTimeout, trucksModuleName).execute();
    }

    public void goToHandOff() {
        System.out.println("Autochanger Trucks going to Handoff position");
        fcslog.info((Object)"Autochanger Trucks going to Handoff Position");
        fcslog.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker("goToHandOff", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    public void goToStandby() {
        System.out.println("Autochanger Trucks going to Standby position");
        fcslog.info((Object)"Autochanger Trucks going to Standby Position");
        fcslog.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker("goToStandby", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    public void goToOnline() {
        System.out.println("Autochanger Trucks going to Online position");
        fcslog.info((Object)"Autochanger Trucks going to Online Position");
        fcslog.info((Object)("/timeout=" + this.timeoutForTrucksMotion));
        new GeneralGUI.CommandSwingWorker("goToOnline", this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    public void unlockOnlineClamps() {
        System.out.println("Autochanger unlocking online clamps");
        fcslog.info((Object)"Autochanger unlocking online clamps");
        fcslog.info((Object)("/timeout=" + this.timeoutForOpeningClamps));
        new GeneralGUI.CommandSwingWorker("unlockClamps", this.timeoutForOpeningClamps, clampsName).execute();
    }

    public void lockOnlineClamps() {
        System.out.println("Autochanger locking online clamps");
        fcslog.info((Object)"Autochanger locking online clamps");
        fcslog.info((Object)("/timeout=" + this.timeoutForClosingClamps));
        new GeneralGUI.CommandSwingWorker("lockClamps", this.timeoutForClosingClamps, clampsName).execute();
    }

    public void closeLatch(String latchName) {
        System.out.println("Autochanger locking latch: " + latchName);
        fcslog.info((Object)("Autochanger locking latch: " + latchName));
        fcslog.info((Object)("/timeout=" + this.timeoutForClosingLatches));
        new GeneralGUI.CommandSwingWorker("close", this.timeoutForClosingLatches, latchName).execute();
    }

    public void openLatch(String latchName) {
        System.out.println("Autochanger unlocking latch: " + latchName);
        fcslog.info((Object)("Autochanger unlocking latch: " + latchName));
        fcslog.info((Object)("/timeout=" + this.timeoutForOpeningLatches));
        new GeneralGUI.CommandSwingWorker("open", this.timeoutForOpeningLatches, latchName).execute();
    }

    public void closeLatches() {
        System.out.println("Autochanger locking latches.");
        fcslog.info((Object)"Autochanger locking latches.");
        fcslog.info((Object)("/timeout=" + this.timeoutForClosingLatches));
        new GeneralGUI.CommandSwingWorker("open", this.timeoutForClosingLatches, latchesName).execute();
    }

    public void openLatches() {
        System.out.println("Autochanger unlocking latches.");
        fcslog.info((Object)"Autochanger unlocking latches.");
        fcslog.info((Object)("/timeout=" + this.timeoutForOpeningLatches));
        new GeneralGUI.CommandSwingWorker("open", this.timeoutForOpeningLatches, latchesName).execute();
    }

    public static void main(String[] args) {
        Agent agent = new Agent("AutochangerGUI", AgentInfo.AgentType.CONSOLE);
        AutochangerGeneralGUI t = new AutochangerGeneralGUI(agent.getName(), "testbenchCPPM", agent.getMessagingAccess());
        agent.start();
        JFrame frame = new JFrame("Autochanger View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }
}

