/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGeneralGUI;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerGeneralViewPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerMainPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerThreeOnlineClampsPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerTrucksPanel;
import org.lsst.ccs.subsystems.fcs.autochanger.ui.AutochangerTwoLatchesPanel;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;
import org.lsst.ccs.subsystems.fcs.config.PlutoGatewayConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenHardwarePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.PlutoGatewayPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import org.lsst.ccs.subsystems.fcs.ui.commons.TopPanel;

public class AutochangerGatherPanel
extends TopPanel {
    protected AutochangerGeneralGUI subs;
    protected CanOpenHardwarePanel hardwarePanel;
    protected EPOSControllerPanel linearRailMasterControllerPanel;
    protected EPOSControllerPanel linearRailSlaveControllerPanel;
    protected EPOSControllerPanel latchXminusControllerPanel;
    protected EPOSControllerPanel latchXplusControllerPanel;
    protected EPOSControllerPanel onlineClampXminusControllerPanel;
    protected EPOSControllerPanel onlineClampXplusControllerPanel;
    protected EPOSControllerPanel onlineClampZControllerPanel;
    protected PlutoGatewayPanel plutoGatewayPanel;
    protected AutochangerThreeOnlineClampsPanel onlineClampsPanel;
    AutochangerMainPanel autochangerMainPanel;
    AutochangerTrucksPanel acTrucksPanel = new AutochangerTrucksPanel();
    AutochangerTwoLatchesPanel acLatchesPanel = new AutochangerTwoLatchesPanel();
    AutochangerThreeOnlineClampsPanel acClampsPanel = new AutochangerThreeOnlineClampsPanel();
    AutochangerGeneralViewPanel acGeneralViewPanel = new AutochangerGeneralViewPanel();

    public AutochangerGatherPanel() {
        this.initPanels();
    }

    public AutochangerGatherPanel(AutochangerGeneralGUI subs) {
        this.initPanels();
        this.subs = subs;
        this.autochangerMainPanel.setSubsystem(subs);
        this.acClampsPanel.setSubsystem(subs);
        this.acLatchesPanel.setSubsystem(subs);
        this.acTrucksPanel.setSubsystem(subs);
        this.linearRailMasterControllerPanel.setSubsystem(subs);
        this.linearRailSlaveControllerPanel.setSubsystem(subs);
        this.latchXminusControllerPanel.setSubsystem(subs);
        this.latchXplusControllerPanel.setSubsystem(subs);
        this.onlineClampXminusControllerPanel.setSubsystem(subs);
        this.onlineClampXplusControllerPanel.setSubsystem(subs);
        this.onlineClampZControllerPanel.setSubsystem(subs);
    }

    @Override
    public SubsystemPanel getSubsystemPanel() {
        return this.autochangerMainPanel.getSubsystemPanel();
    }

    public AutochangerMainPanel getAutochangerMainPanel() {
        return this.autochangerMainPanel;
    }

    public AutochangerTrucksPanel getAcTrucksPanel() {
        return this.acTrucksPanel;
    }

    public AutochangerTwoLatchesPanel getAcLatchesPanel() {
        return this.acLatchesPanel;
    }

    public AutochangerThreeOnlineClampsPanel getAcClampsPanel() {
        return this.acClampsPanel;
    }

    public AutochangerGeneralViewPanel getAcGeneralViewPanel() {
        return this.acGeneralViewPanel;
    }

    public CanOpenHardwarePanel getHardwarePanel() {
        return this.hardwarePanel;
    }

    public EPOSControllerPanel getLinearRailMasterControllerPanel() {
        return this.linearRailMasterControllerPanel;
    }

    public EPOSControllerPanel getLinearRailSlaveControllerPanel() {
        return this.linearRailSlaveControllerPanel;
    }

    public EPOSControllerPanel getLatchXminusControllerPanel() {
        return this.latchXminusControllerPanel;
    }

    public EPOSControllerPanel getLatchXplusControllerPanel() {
        return this.latchXplusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampXminusControllerPanel() {
        return this.onlineClampXminusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampXplusControllerPanel() {
        return this.onlineClampXplusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampZControllerPanel() {
        return this.onlineClampZControllerPanel;
    }

    public PlutoGatewayPanel getPlutoGatewayPanel() {
        return this.plutoGatewayPanel;
    }

    public void initializeGui(AutochangerConfig autochangerConfig) {
        SwingUtilities.invokeLater(new GuiInitialization(autochangerConfig));
    }

    void updateCanOpenHardwarePanel(StatusDataPublishedByHardware s) {
        this.hardwarePanel.updateCanOpenHardwarePanel(s);
    }

    void updateLinearRailMasterController(StatusDataPublishedByEPOSController s) {
        this.linearRailMasterControllerPanel.updateController(s);
    }

    void updateLinearRailSlaveController(StatusDataPublishedByEPOSController s) {
        this.linearRailSlaveControllerPanel.updateController(s);
    }

    void updateLatchXminusController(StatusDataPublishedByEPOSController s) {
        this.latchXminusControllerPanel.updateController(s);
    }

    void updateLatchXplusController(StatusDataPublishedByEPOSController s) {
        this.latchXplusControllerPanel.updateController(s);
    }

    void updateOnlineClampXminusController(StatusDataPublishedByEPOSController s) {
        this.onlineClampXminusControllerPanel.updateController(s);
    }

    void updateOnlineClampXplusController(StatusDataPublishedByEPOSController s) {
        this.onlineClampXplusControllerPanel.updateController(s);
    }

    void updateOnlineClampZController(StatusDataPublishedByEPOSController s) {
        this.onlineClampZControllerPanel.updateController(s);
    }

    void updateClampXminus(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.acClampsPanel.updateClampXminus(s);
    }

    void updateClampXplus(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.acClampsPanel.updateClampXplus(s);
    }

    void updateClampZ(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.acClampsPanel.updateClampZ(s);
    }

    void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        this.acClampsPanel.updateClamps(s);
        this.acGeneralViewPanel.updateClamps(s);
    }

    void updateAutochanger(StatusDataPublishedByAutoChanger s) {
        this.autochangerMainPanel.update(s);
        this.acGeneralViewPanel.updateAutochanger(s);
    }

    void updateLatch(StatusDataPublishedByAutochangerLatch s) {
        this.acLatchesPanel.updateLatch(s);
    }

    void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        this.acLatchesPanel.updateLatches(s);
        this.acGeneralViewPanel.updateLatches(s);
    }

    void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        fcslog.finest((Object)(" Data published by Trucks= " + s.toString()));
        this.acTrucksPanel.updateTrucks(s);
        this.acGeneralViewPanel.updateTrucks(s);
    }

    private void initPanels() {
        this.hardwarePanel = new CanOpenHardwarePanel();
        this.linearRailMasterControllerPanel = new EPOSControllerPanel("linearRailMasterController");
        this.linearRailSlaveControllerPanel = new EPOSControllerPanel("linearRailSlaveController");
        this.latchXminusControllerPanel = new EPOSControllerPanel("latchXminusController");
        this.latchXplusControllerPanel = new EPOSControllerPanel("latchXplusController");
        this.onlineClampXminusControllerPanel = new EPOSControllerPanel("onlineClampXminusController");
        this.onlineClampXplusControllerPanel = new EPOSControllerPanel("onlineClampXplusController");
        this.onlineClampZControllerPanel = new EPOSControllerPanel("onlineClampZController");
        this.plutoGatewayPanel = new PlutoGatewayPanel();
        this.acClampsPanel = new AutochangerThreeOnlineClampsPanel();
        this.acLatchesPanel = new AutochangerTwoLatchesPanel();
        this.acTrucksPanel = new AutochangerTrucksPanel();
        this.autochangerMainPanel = new AutochangerMainPanel();
        this.autochangerMainPanel.setAcLatchesPanel(this.acLatchesPanel);
        this.autochangerMainPanel.setAcTrucksPanel(this.acTrucksPanel);
    }

    private class GuiInitialization
    implements Runnable {
        AutochangerConfig autochangerConfig;
        CanOpenProxyConfig canOpenProxyConfig;
        EPOSControllerConfig lrMasterCtlConfig;
        EPOSControllerConfig lrSlaveCtlConfig;
        EPOSControllerConfig latchXminusCtlConfig;
        EPOSControllerConfig latchXplusCtlConfig;
        EPOSControllerConfig onlineXminusCtlConfig;
        EPOSControllerConfig onlineXplusCtlConfig;
        EPOSControllerConfig onlineZCtlConfig;
        PlutoGatewayConfig gwConfig;

        public GuiInitialization(AutochangerConfig autochangerConfig) {
            this.autochangerConfig = autochangerConfig;
            this.canOpenProxyConfig = autochangerConfig.getTcpProxyConfig();
            this.lrMasterCtlConfig = autochangerConfig.getLinearRailMasterControllerConfig();
            this.lrSlaveCtlConfig = autochangerConfig.getLinearRailSlaveControllerConfig();
            this.latchXminusCtlConfig = autochangerConfig.getLatchXminusControllerConfig();
            this.latchXplusCtlConfig = autochangerConfig.getLatchXplusControllerConfig();
            this.onlineXminusCtlConfig = autochangerConfig.getOnlineClampXminusControllerConfig();
            this.onlineXplusCtlConfig = autochangerConfig.getOnlineClampXplusControllerConfig();
            this.onlineZCtlConfig = autochangerConfig.getOnlineClampZControllerConfig();
            this.gwConfig = autochangerConfig.getGwConfig();
        }

        @Override
        public void run() {
            AutochangerGatherPanel.this.autochangerMainPanel.initializeGui(this.autochangerConfig);
            AutochangerGatherPanel.this.acGeneralViewPanel.initializeGui(this.autochangerConfig);
            AutochangerGatherPanel.this.acClampsPanel.initializeGui(this.autochangerConfig);
            AutochangerGatherPanel.this.acLatchesPanel.initializeGui(this.autochangerConfig);
            AutochangerGatherPanel.this.subs.setTimeoutForTrucksMotion(this.autochangerConfig.getTrucksConfig().getTimeoutForTrucksMotion());
            AutochangerGatherPanel.this.acTrucksPanel.initializeGui(this.autochangerConfig.getTrucksConfig());
            AutochangerGatherPanel.this.hardwarePanel.initializeGui(this.canOpenProxyConfig);
            AutochangerGatherPanel.this.linearRailMasterControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.lrMasterCtlConfig), this.lrMasterCtlConfig);
            AutochangerGatherPanel.this.linearRailSlaveControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.lrSlaveCtlConfig), this.lrSlaveCtlConfig);
            fcslog.debug((Object)("latchXminusControllerPanel.initializeGui:" + this.latchXminusCtlConfig.toString()));
            AutochangerGatherPanel.this.latchXminusControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.latchXminusCtlConfig), this.latchXminusCtlConfig);
            fcslog.debug((Object)("latchXplusControllerPanel.initializeGui:" + this.latchXplusCtlConfig.toString()));
            AutochangerGatherPanel.this.latchXplusControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.latchXplusCtlConfig), this.latchXplusCtlConfig);
            AutochangerGatherPanel.this.onlineClampXminusControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.onlineXminusCtlConfig), this.onlineXminusCtlConfig);
            AutochangerGatherPanel.this.onlineClampXplusControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.onlineXplusCtlConfig), this.onlineXplusCtlConfig);
            AutochangerGatherPanel.this.onlineClampZControllerPanel.initializeGui(Tools.retrieveControllerInfo(this.canOpenProxyConfig, this.onlineZCtlConfig), this.onlineZCtlConfig);
            AutochangerGatherPanel.this.plutoGatewayPanel.initializeGui(Tools.retrieveDeviceInfo(this.canOpenProxyConfig, this.gwConfig.getName()), this.gwConfig);
            AutochangerGatherPanel.this.subs.postInitGui();
        }
    }
}

