/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeSelectionModel;

/**
 *
 * @author virieux
 */
public class TreePanel  extends JPanel implements TreeSelectionListener {
    
    final String title;
    JTree tree;
    JPanel rightPanel;
    JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
    JPanel helpPanel;

    public TreePanel(String title) {
        this.title = title;  
        initComponents();
    }
    
    
    
    public class HardwarePanel extends JPanel {
        String title;
        JLabel label;

        public HardwarePanel(String title) {
            this.title = title;
            this.label = new JLabel("My beautiful hardware has title:" + title);
            add(label);
        }
        
        @Override
        public String toString(){
            return title;
        }
    }
    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {

        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new java.awt.Color(255, 255, 0)), title));
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());
        
        //Create the nodes.
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(title);
        createNodes(top);


        //Create a tree that allows one selection at a time.
        tree = new JTree(top);
        tree.getSelectionModel().setSelectionMode
                (TreeSelectionModel.SINGLE_TREE_SELECTION);

        //Listen for when the selection changes.
        tree.addTreeSelectionListener(this);
        
        //Create the scroll rightPanel and add the tree to it. 
        JScrollPane treeView = new JScrollPane(tree);
        splitPane.setLeftComponent(treeView);

        //Create the viewing rightPanel.
        rightPanel = new JPanel();
        JScrollPane rightScrollPane = new JScrollPane(rightPanel);
        splitPane.setRightComponent(rightPanel);

        Dimension minimumSize = new Dimension(1200, 900);
        rightScrollPane.setMinimumSize(minimumSize);
        treeView.setMinimumSize(new Dimension(200, 900));
        splitPane.setDividerLocation(200); 
        splitPane.setPreferredSize(new Dimension(1200, 900));

        //Add the split rightPanel to this Panel.
        add(splitPane);
        
        //TODO fill helpPanel
        helpPanel = new JPanel();
        JLabel helpLabel = new JLabel("Nothing to display");
        helpPanel.add(helpLabel);
    }
    
    
    private void displayPanel(JPanel panel) {
        if (panel != null) {
            JScrollPane scrollPane = new JScrollPane(panel);
            splitPane.setRightComponent(scrollPane);
        } else { 

            JScrollPane scrollPane = new JScrollPane(helpPanel);
            splitPane.setRightComponent(scrollPane);
        }
    }


    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)
                           tree.getLastSelectedPathComponent();

        if (node == null) return;

        Object nodeInfo = node.getUserObject();
        
        if (nodeInfo == null) return;
        
        if (node.isLeaf()) {
            JPanel panel = (JPanel)nodeInfo;
            displayPanel(panel);
        } else {
            //TODO find something cleaver to be done here
        }

    }
    

    private void createNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode devicesNode = new DefaultMutableTreeNode("CANopen devices");
        devicesNode.add(new DefaultMutableTreeNode(new CanOpenHardwarePanel()));
        top.add(devicesNode);
                
        top.add(new DefaultMutableTreeNode(new HardwarePanel("hardware1")));
        
        top.add(new DefaultMutableTreeNode(new HardwarePanel("hardware2")));
        
        top.add(new DefaultMutableTreeNode(new HardwarePanel("hardware3")));
    }

    public static void main(String[] argv) {
        
        TreePanel d = new TreePanel("FCS");
        JFrame frame = new JFrame("Subsystem Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
    
}
