/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.FilterPresenceStatus;
import org.lsst.ccs.subsystems.fcs.config.CANopenHardwareConfig;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author virieux
 */
public class Tools {
    public static final Logger fcslog = Logger.getLogger("org.lsst.ccs.subsystems.fcs");
    
    public static Color greenColor = new Color(0, 165, 0);
    public static Color nicePink = new Color(255, 0, 255);
    
    public static final String fcsFontInString = "Lucida Grande";
    public static Font bigFont = new Font(fcsFontInString, 1, 14);
    public static Font hugeFont = new Font(fcsFontInString, 1, 20);
    public static Insets insets_std = new Insets(4, 4, 4, 4);
    public static Insets insets_big = new Insets(14, 4, 6, 4);
    
    public static Dimension preferedPanelSize = new Dimension(1200, 600);

    @Deprecated //instead use getLockStatus().getColor() see in FcsEnumerations
    public static Color getLockSensorColor(String lockSensorStatus) {
        if (lockSensorStatus.equals(FcsEnumerations.LockStatus.ERROR.toString())) {
            return Color.red;
        } else if (lockSensorStatus.equals(FcsEnumerations.LockStatus.LOCKED.toString())) {
            return greenColor;
        } else if (lockSensorStatus.equals(FcsEnumerations.LockStatus.UNKNOWN.toString())) {
            return Color.orange;
        } else if (lockSensorStatus.equals(FcsEnumerations.LockStatus.UNLOCKED.toString())) {
            return Color.blue;
        } else if (lockSensorStatus.equals(FcsEnumerations.LockStatus.CLAMPED.toString())) {
            return Color.GREEN;   
        } else if (lockSensorStatus.equals(FcsEnumerations.LockStatus.INTRAVEL.toString())) {
            return Color.YELLOW;   
        } else {
            fcslog.error("Tools: Unknown Lock Sensor Status " + lockSensorStatus);
            return Color.GRAY;
        }
    }

    public static Color getFilterPresenceColor(String filterPresenceStatus) {
        if (filterPresenceStatus.equals(FilterPresenceStatus.ERROR.toString())) {
            return Color.red;
        } else if (filterPresenceStatus.equals(FilterPresenceStatus.LOCKABLE.toString())) {
            return greenColor;
        } else if (filterPresenceStatus.equals(FilterPresenceStatus.NOT_LOCKABLE.toString())) {
            return Color.orange;
        } else if (filterPresenceStatus.equals(FilterPresenceStatus.NOFILTER.toString())) {
            return Color.gray;
        } else {
            fcslog.error("Unknown Filter Presence Status " + filterPresenceStatus);
            return Color.gray;
        }
    }  

    /**
     * To retreive the information nodeID, serial number of a controller in the 
     * tcpProxy config.
     * @param canOpenProxyConfig
     * @param ctlConfig
     * @return
     */
    public static CANopenHardwareConfig retrieveControllerInfo(CanOpenProxyConfig canOpenProxyConfig, 
            EPOSControllerConfig ctlConfig) {
        CANopenHardwareConfig hConfig = new CANopenHardwareConfig("Unknown", "Unknown", "Unknown", false, false);
        CANopenHardwareConfig[] list = canOpenProxyConfig.getHardwareConfigList();
        int rowNB = list.length;
        for (int i = 0; i < rowNB; i++) {
            if (list[i].getName().equals(ctlConfig.getName())) {
                fcslog.debug("retrieveControllerInfo:i="+i+"list[i].getName()="+list[i].getName());
                hConfig = list[i];
            }
        }
        return hConfig;
    }
    
     /**
     * To retreive the information nodeID, serial number of a device in the tcpProxy config.
     * @param canOpenProxyConfig
     * @param deviceName
     * @return
     */
    public static CANopenHardwareConfig retrieveDeviceInfo(CanOpenProxyConfig canOpenProxyConfig, String deviceName) {
        CANopenHardwareConfig hConfig = new CANopenHardwareConfig("Unknown", "Unknown", "Unknown", false, false);
        CANopenHardwareConfig[] list = canOpenProxyConfig.getHardwareConfigList();
        int rowNB = list.length;
        for (int i = 0; i < rowNB; i++) {
            if (list[i].getName().equals(deviceName)) {
                hConfig = list[i];
            }
        }
        return hConfig;
    }
    
}
