/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.ui.commons;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * This is a general main panel for all the Exchanger subsystem.
 * @author virieux
 */
public class PanelWithTree extends JPanel {
    
    protected static final Logger fcslog = Tools.fcslog;
    
    String title;
    private GeneralGUI subs;
    final SubsystemPanel subsPanel = new SubsystemPanel("Subsystem State");
    TreePanel treePanel;
    JSplitPane splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT);


    public PanelWithTree() {
        this.title="My Subsystem Main Panel";
        treePanel = new TreePanel(title);
        initComponents();
    }

    public PanelWithTree(String title, TreePanel treePanel) {
        this.title = title;
        this.treePanel = treePanel;
        initComponents();
    }

    
    public void setSubsystem(GeneralGUI subs) {
        this.title = subs.getName();
        this.subs = subs;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setTreePanel(TreePanel bottomPanel) {
        this.treePanel = bottomPanel;
    }
    
    
    
    
    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description">                          
    private void initComponents() {
        
        
        JScrollPane bottomScrollPane = new JScrollPane(treePanel);
        

        //Add the scroll panes to a split treePanel.       
        splitPane.setTopComponent(subsPanel);
        splitPane.setBottomComponent(bottomScrollPane);
        splitPane.setPreferredSize(new Dimension(1200, 900));
        
        //Whole Panel
        setLayout(new GridBagLayout());
        setBorder(BorderFactory.createTitledBorder(title));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(splitPane,gbc);
        //end Whole Panel
    }
    
    public static void main(String[] argv) {
        PanelWithTree d = new PanelWithTree();
        JFrame frame = new JFrame();
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
}
