/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.testbench.ui;

import org.lsst.ccs.subsystems.fcs.autochanger.ui.*;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 * This panel presents autochanger standalone hardware with a split panel.
 * (JSplitPane.VERTICAL_SPLIT)
 * On the top panel : the autochanger subsystem state.
 * On the bottom panel : a HORIZONTAL spli panel, with a left component which is a tree.
 * @author virieux
 */
public final class TestbenchCPPMTopTreePanel extends TestbenchCPPMGatherPanel {

    
    String title;
    JPanel bottomPanel;
    JSplitPane splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
    
   public TestbenchCPPMTopTreePanel() {
       bottomPanel = new TestbenchCPPMTreePanel("CPPM Test Bench");
       initComponents();
    }

    public TestbenchCPPMTopTreePanel(TestbenchCPPMGUI subs) {
        super(subs);
        bottomPanel = new TestbenchCPPMTreePanel("CPPM Test Bench", this);
        initComponents();
    }
    
    
    
    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description">                          

    protected void initComponents() {
        
        JScrollPane bottomScrollPane = new JScrollPane(bottomPanel);
        

        //Add the scroll panes to a split Panel.       
        splitPane.setTopComponent(this.getSubsystemPanel());
        splitPane.setBottomComponent(bottomScrollPane);
        //splitPane.setBottomComponent(bottomPanel);
        //splitPane.setPreferredSize(new Dimension(1200, 900));
        
        //Whole Panel
        setLayout(new GridBagLayout());
        setBorder(BorderFactory.createTitledBorder(title));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(splitPane,gbc);
        //end Whole Panel
    }
    
    public static void main(String[] argv) {
        TestbenchCPPMTopTreePanel d = new TestbenchCPPMTopTreePanel();
        JFrame frame = new JFrame("Autochanger Panel with Tree");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
}
