/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.testbench.ui;


import org.lsst.ccs.subsystems.fcs.autochanger.ui.*;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandError;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;

import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;



/**
 *
 * @author virieux
 */
public class TestbenchCPPMGUI extends AutochangerGeneralGUI {
    private long lastHeartBeat = 0, lastStateRequest = 0;
    String stateCorrelId;
    
    private static final String trucksModuleName = "autochangerTrucks";
    private static final String clampsName = "onlineClamps";
    private static final String latchesName = "latches";
    
    long updateTrucksPositionTimeout;
    long timeoutForTrucksMotion;
    
    long timeoutForClosingClamps;
    long timeoutForOpeningClamps;
    
    long timeoutForClosingLatches;
    long timeoutForOpeningLatches;

    public TestbenchCPPMGUI(String name,  String destination, AgentMessagingLayer aml) {
        super(name, destination, aml);
        this.topPanel = new TestbenchCPPMTopTreePanel(this);
        pane = new JScrollPane(topPanel);
        
        //TODO to be initialized from the configuration system
        this.updateTrucksPositionTimeout = 1000;
        this.timeoutForTrucksMotion = 60000;
        this.timeoutForClosingClamps = 10000;
        this.timeoutForOpeningClamps = 10000;
        this.timeoutForClosingLatches = 10000;
        this.timeoutForOpeningLatches = 10000;
    }

    public void setTimeoutForTrucksMotion(long timeoutForTrucksMotion) {
        this.timeoutForTrucksMotion = timeoutForTrucksMotion;
    }
    

    @Override
    public void onDataArrival(String source, long timestamp, String dataType, Object s) {
        //If this data status is not for us we forget it.
        if (!source.equals(destination)) {
            return;
        }
        if (initialized) {
            switch (dataType) {
                    
                case "tcpProxy":
                    fcslog.debug(getName() + " read data dataType:tcpProxy");
                    ((TestbenchCPPMGatherPanel)topPanel).updateCanOpenHardwarePanel((StatusDataPublishedByHardware) s);
                    lastHeartBeat = timestamp;
                    break; 
                    
//                case "autochangerGeneral":
//                    fcslog.debug(getName() + " read data dataType:autochangerGeneral");
//                    ((TestbenchCPPMGatherPanel)topPanel).updateAutochanger((StatusDataPublishedByAutoChanger) s);
//                    lastHeartBeat = timestamp;
//                    break;

                case "linearRailMasterController":
                    fcslog.debug(getName() + " read data dataType:linearRailMasterController");
                    ((TestbenchCPPMGatherPanel)topPanel).updateLinearRailMasterController((StatusDataPublishedByEPOSController) s);
                    lastHeartBeat = timestamp;
                    break;

                case "linearRailSlaveController":
                    fcslog.debug(getName() + " read data dataType:linearRailSlaveController");
                    ((TestbenchCPPMGatherPanel)topPanel).updateLinearRailSlaveController((StatusDataPublishedByEPOSController) s);
                    lastHeartBeat = timestamp;
                    break;
                    
                case "latchController":
                    fcslog.debug(getName() + " read data dataType:latchXminusController");
                    ((TestbenchCPPMGatherPanel)topPanel).updateLatchXminusController((StatusDataPublishedByEPOSController) s);
                    lastHeartBeat = timestamp;
                    break;    
                    
                case "onlineClampController":
                    fcslog.debug(getName() + " read data dataType:onlineClampController");
                    ((TestbenchCPPMGatherPanel)topPanel).updateOnlineClampXminusController((StatusDataPublishedByEPOSController) s);
                    lastHeartBeat = timestamp;
                    break;
                                        
                    
                case "autochangerTrucks":
                    fcslog.debug(getName() + " read data dataType:trucks");
                    fcslog.finest(getName() + " Data published by Trucks= " + ((StatusDataPublishedByAutoChangerTrucks)s).toString());
                    ((TestbenchCPPMGatherPanel)topPanel).updateTrucks((StatusDataPublishedByAutoChangerTrucks) s);
                    lastHeartBeat = timestamp;
                    break;  
                
                case "latchXminus":
                    fcslog.debug(getName() + " read data dataType:latchXminus");
                    fcslog.finest(getName() + " Data published by Latch= " + ((StatusDataPublishedByAutochangerLatch)s).toString());
                    ((TestbenchCPPMGatherPanel)topPanel).updateLatch((StatusDataPublishedByAutochangerLatch) s);
                    lastHeartBeat = timestamp;
                    break;
                                         
                    
                    
                    
                case "onlineClampXminus":
                    fcslog.debug(getName() + " read data dataType:onlineClampXminus");
                    fcslog.debug(getName() + " Data published by ClampXminus= " 
                            + ((StatusDataPublishedByAutochangerOnlineClamp)s).toString());
                    ((TestbenchCPPMGatherPanel)topPanel).updateClampXminus((StatusDataPublishedByAutochangerOnlineClamp) s);
                    lastHeartBeat = timestamp;
                    break;
                                        
                    
                default:
                    fcslog.warning(getName() + " An unexpected dataType was read on the status bus:" + dataType);
                    break;
            }
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastStateRequest > 2000) {
                lastStateRequest = currentTime;

                CommandRequest cmd = new CommandRequest(destination, "getFullState");
                aml.sendCommandRequest(cmd, new CommandOriginator() {

                    @Override
                    public void processAck(CommandAck ack) {
                    }

                    @Override
                    public void processResult(CommandResult result) {
                        AutochangerConfig config = (AutochangerConfig) result.getReply();
                        fcslog.debug("--- Got a reply from subs");
                        ((TestbenchCPPMGatherPanel)topPanel).initializeGui(config);
                        initialized = true;
                        //sendAsynchronousCommand(new CommandRequest(destination,"updateStateWithSensors"));
                    }

                    @Override
                    public void processNack(CommandNack nack) {
                    }

                    @Override
                    public void processError(CommandError nack) {
                    }
                });
                
            }
        }
    }    
    
    /**
    ******************************************************************************
    **  Trucks Actions
    ******************************************************************************
    */
    public void updateTrucksPosition() {
        System.out.println("Autochanger updating Trucks position");
        fcslog.info("Autochanger updating Trucks position");
        fcslog.info("/timeout=" + updateTrucksPositionTimeout);
        new CommandSwingWorker("updatePosition",this.updateTrucksPositionTimeout, trucksModuleName).execute();
    }

    public void goToHandOff() {
        System.out.println("Autochanger Trucks going to Handoff position");
        fcslog.info("Autochanger Trucks going to Handoff Position");
        fcslog.info("/timeout=" + timeoutForTrucksMotion);
        new CommandSwingWorker("goToHandOff",this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    public void goToStandby() {
        System.out.println("Autochanger Trucks going to Standby position");
        fcslog.info("Autochanger Trucks going to Standby Position");
        fcslog.info("/timeout=" + timeoutForTrucksMotion);
        new CommandSwingWorker("goToStandby",this.timeoutForTrucksMotion, trucksModuleName).execute();
    }

    public void goToOnline() {
        System.out.println("Autochanger Trucks going to Online position");
        fcslog.info("Autochanger Trucks going to Online Position");
        fcslog.info("/timeout=" + timeoutForTrucksMotion);
        new CommandSwingWorker("goToOnline",this.timeoutForTrucksMotion, trucksModuleName).execute();
    }
    /**
    ******************************************************************************
    **  end of Trucks Actions
    ******************************************************************************
    */   
    
    /**
    ******************************************************************************
    **  Clamps Actions
    ******************************************************************************
    */
    public void unlockOnlineClamps() {
        System.out.println("Autochanger unlocking online clamps");
        fcslog.info("Autochanger unlocking online clamps");
        fcslog.info("/timeout=" + timeoutForOpeningClamps);
        new CommandSwingWorker("unlockClamps",this.timeoutForOpeningClamps, clampsName).execute();
    }
    
    public void lockOnlineClamps() {
        System.out.println("Autochanger locking online clamps");
        fcslog.info("Autochanger locking online clamps");
        fcslog.info("/timeout=" + timeoutForClosingClamps);
        new CommandSwingWorker("lockClamps",this.timeoutForClosingClamps, clampsName).execute();
    }
    
    /**
    ******************************************************************************
    **  end of Clamps Actions
    ******************************************************************************
    */
    
    /**
    ******************************************************************************
    **  Latches Actions
    ******************************************************************************
     * @param latchName
    */
    public void closeLatch(String latchName) {
        System.out.println("Autochanger locking latch: " + latchName);
        fcslog.info("Autochanger locking latch: " + latchName);
        fcslog.info("/timeout=" + timeoutForClosingLatches);
        new CommandSwingWorker("close",this.timeoutForClosingLatches, latchName).execute();
    }
    
    public void openLatch(String latchName) {
        System.out.println("Autochanger unlocking latch: " + latchName);
        fcslog.info("Autochanger unlocking latch: " + latchName);
        fcslog.info("/timeout=" + timeoutForOpeningLatches);
        new CommandSwingWorker("open",this.timeoutForOpeningLatches, latchName).execute();
    }
    
    public void closeLatches() {
        System.out.println("Autochanger locking latches.");
        fcslog.info("Autochanger locking latches.");
        fcslog.info("/timeout=" + timeoutForClosingLatches);
        new CommandSwingWorker("open",this.timeoutForClosingLatches, latchesName).execute();
    }
    
    public void openLatches() {
        System.out.println("Autochanger unlocking latches.");
        fcslog.info("Autochanger unlocking latches.");
        fcslog.info("/timeout=" + timeoutForOpeningLatches);
        new CommandSwingWorker("open",this.timeoutForOpeningLatches, latchesName).execute();
    }
    /**
    ******************************************************************************
    **  end of Latches Actions
    ******************************************************************************
    */
    
            /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        
        Agent agent = new Agent("TestbenchCPPMGUI", AgentInfo.AgentType.CONSOLE);
        TestbenchCPPMGUI t = new TestbenchCPPMGUI(agent.getName(),"testbenchCPPM", agent.getMessagingAccess());
        agent.start();

        JFrame frame = new JFrame("Testbench CPPM GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
    
}
