/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ClampPanel.java
 *
 * Created on Aug 10, 2012, 3:01:45 PM
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.clamp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations.LockStatus;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.SingleFilterTestConfig;

/**
 *
 * @author turri
 */
public class CarouselTablePanel extends javax.swing.JPanel {

    final static Font myFont = new Font("Helvetica", Font.PLAIN, 12);

    /** Creates new form ClampPanel */
    public CarouselTablePanel() {
        initComponents();
        JTableHeader hdr = jTable1.getTableHeader();
        hdr.setReorderingAllowed(false);
        hdr.setSize(hdr.getWidth(), hdr.getHeight() + 2);
        jTable1.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
        jTable1.setRowSelectionAllowed(false);
        jTable1.setDefaultRenderer(Object.class, new CarouselCellRenderer());
        jTable1.setDefaultRenderer(Double.class, new CarouselCellRenderer());
        jTable1.setColumnSelectionAllowed(false);
        jTable1.setFont(myFont);
        jTable1.setRowHeight(jTable1.getRowHeight() + 2);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.LINE_AXIS));

        jTable1.setModel(new ClampsTableModel());
        jScrollPane1.setViewportView(jTable1);

        add(jScrollPane1);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    // End of variables declaration//GEN-END:variables

    public void createTableRows(SingleFilterTestConfig status) {
        SwingUtilities.invokeLater(new CreateCarouselTableRows(status));
    }

    class CreateCarouselTableRows implements Runnable {

        SingleFilterTestConfig s;

        CreateCarouselTableRows(SingleFilterTestConfig s) {
            this.s = s;
        }

        @Override
        public void run() {

            ClampsTableModel model = (ClampsTableModel) jTable1.getModel();
            model.addClamp(s.getClampXminusConfig());
            model.addClamp(s.getClampXplusConfig());


            for (int c = 0; c < jTable1.getColumnCount(); c++) {
                TableColumnModel colModel = jTable1.getColumnModel();
                TableColumn col = colModel.getColumn(c);
                TableCellRenderer rndr;
                Component comp;

                rndr = jTable1.getTableHeader().getDefaultRenderer();
                comp = rndr.getTableCellRendererComponent(jTable1,
                        col.getHeaderValue(),
                        false, false, 0, 0);
                int width = comp.getPreferredSize().width;

                rndr = jTable1.getCellRenderer(0, c);
                Class colClass = jTable1.getColumnClass(c);
                if (!colClass.equals(String.class)) {
                    if (colClass.equals(Double.class)) {
                        comp = rndr.getTableCellRendererComponent(jTable1,
                                -999.99,
                                false, false,
                                0, c);
                    } else {
                        comp = rndr.getTableCellRendererComponent(jTable1,
                                -999.99F,
                                false, false,
                                0, c);
                    }
                    width = Math.max(width, comp.getPreferredSize().width);
                } else {
                    for (int r = 0; r < jTable1.getRowCount(); r++) {
                        Object value = jTable1.getValueAt(r, c);
                        comp = rndr.getTableCellRendererComponent(jTable1, value,
                                false, false,
                                r, c);
                        width = Math.max(width, comp.getPreferredSize().width);
                    }
                }
                col.setPreferredWidth(width + 4);
            }


        }
    }

    class CarouselCellRenderer extends DefaultTableCellRenderer {

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value,
                boolean isSelected,
                boolean hasFocus,
                int row, int column) {
            Component c = super.getTableCellRendererComponent(table,
                    value,
                    isSelected,
                    hasFocus,
                    row, column);

            ClampsTableModel model = (ClampsTableModel) table.getModel();
            if (column == 2 || column == 3) {
                String lockStatus = (String) model.getValueAt(row, 2);

                if (lockStatus.equals(LockStatus.ERROR.toString())) {
                    c.setBackground(Color.red);
                } else if (lockStatus.equals(LockStatus.LOCKED.toString())) {
                    c.setBackground(Color.green);
                } else if (lockStatus.equals(LockStatus.UNKNOWN.toString())) {
                    c.setBackground(Color.orange);
                } else if (lockStatus.equals(LockStatus.UNLOCKED.toString())) {
                    c.setBackground(Color.green);
                } else {
                    c.setBackground(Color.black);
                }
            } else {
                c.setBackground(Color.white);
            }

            return c;
        }
    }
}
