package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import javax.swing.JScrollPane;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.SingleFilterTestConfig;

import javax.swing.*;
import java.io.PrintWriter;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.messaging.DataStatusListener;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandError;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByBasicAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByCarousel;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByClampActuator;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author max
 */
public class SingleFilterTestGUISubsystem implements DataStatusListener {

    private static final String destination = "single-filter-test";
    private static final String name = "SingleFilterTestModelGUIModule";
    //private static final Logger log = Logger.getLogger("org.lsst.ccs.subsystems.fcs");
    private PrintWriter out = new PrintWriter(System.out, true);
//    private SingleFilterTestAssembly assembly;
    private final FilterExchangeMainPanel assembly;
//    private CarouselTablePanel carouselTable;
    private long lastHeartBeat = 0, lastStateRequest = 0;
    private boolean initialized = false;
    JScrollPane pane;
    private final AgentMessagingLayer aml;
    protected static Logger log = Logger.getLogger("org.lsst.ccs.subsystem.fcs");
    
    public SingleFilterTestGUISubsystem(AgentMessagingLayer aml) {
        this.aml = aml;
        assembly = new FilterExchangeMainPanel(this);
        pane = new JScrollPane(assembly);
    }

    public void initGui() {
        aml.addStatusMessageListener(this);
    }
    
    public String getName(){
        return name;
    }

    public JComponent getGuiLayout() {
        return pane;
    }

    public void resetGui() {
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        Agent agent = new Agent(name, AgentInfo.AgentType.CONSOLE);
        SingleFilterTestGUISubsystem t = new SingleFilterTestGUISubsystem(agent.getMessagingAccess());
        
        t.initGui();
        agent.start();

        JFrame frame = new JFrame("Single Filter Test Subsystem");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void onDataArrival(String source, long timestamp, String dataType, Object s) {
         //If this data status is not for us we forget it.
        if (!source.equals(destination)) return;
        if (initialized) {
            switch (dataType){
                            case "carouselClamp":
                                log.debug(getName() + " read data dataType:carouselClamp");
                                assembly.updateClamp((StatusDataPublishedByClamp) s);
                                lastHeartBeat = timestamp;
                                break;
                                
                            case "actuator":
                                log.debug(getName() + " read data dataType:actuator");
                                assembly.updateActuator((StatusDataPublishedByClampActuator) s);
                                lastHeartBeat = timestamp;
                                break;
                                
                            case "carousel":
                                log.debug(getName() + " read data dataType:carousel");
                                assembly.updateCarousel((StatusDataPublishedByCarousel) s);
                                lastHeartBeat = timestamp;
                                break;
                                
                            case "autochangerLatch":
                                log.debug(getName() + " read data dataType:autochangerLatch");
                                assembly.updateLatch((StatusDataPublishedByAutochangerLatch) s);
                                lastHeartBeat = timestamp;
                                break;
                                
                            case "autochanger":
                                log.debug(getName() + " read data dataType:autochanger");
                                assembly.updateAutoChanger ((StatusDataPublishedByBasicAutoChanger) s);
                                lastHeartBeat = timestamp;
                                break;                                
                                                             
                            default:
                                log.warning(getName() + " An unexpected dataType was read on the status bus:" + dataType);
                                break;
                            
                        }
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastStateRequest > 2000) {
                lastStateRequest = currentTime;
                CommandRequest cmd = new CommandRequest(destination, "getFullState");
                aml.sendCommandRequest(cmd, new CommandOriginator(){

                    @Override
                    public void processAck(CommandAck ack) {
                    }

                    @Override
                    public void processResult(CommandResult result) {
                        SingleFilterTestConfig config = (SingleFilterTestConfig) result.getReply();
                        assembly.initializeGui(config);
                        initialized = true;
                    }

                    @Override
                    public void processNack(CommandNack nack) {
                    }

                    @Override
                    public void processError(CommandError nack) {
                    }
                    
                });
            }
        }
    }
}
