/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenHardwarePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;
import org.lsst.ccs.subsystems.fcs.ui.commons.TopPanel;

/**
 *
 * @author virieux
 */
public class LoaderTopPanel extends TopPanel {
    
    private GeneralGUI subs;
    private JTabbedPane jTabbedPane;
    LoaderMainPanel loaderMainPanel;
    private CanOpenHardwarePanel hardwarePanel;
    private EPOSControllerPanel hooksControllerPanel;
    private EPOSControllerPanel carrierControllerPanel;
    private JPanel plutoGWPanel;

    
    
    /** Initialization of the GUI for data stored in tcpConfiguration. **/
    private  class GuiInitialization implements Runnable {
        
        LoaderConfig loaderConfig;
        CanOpenProxyConfig canOpenProxyConfig;
        EPOSControllerConfig clampCtlConfig;
        EPOSControllerConfig carrierCtlConfig;

        public GuiInitialization(LoaderConfig loaderConfig) {
            this.loaderConfig = loaderConfig;
            this.canOpenProxyConfig = loaderConfig.getTcpProxyConfig();
            this.clampCtlConfig = loaderConfig.getLoaderClampControllerConfig();
            this.carrierCtlConfig = loaderConfig.getLoaderCarrierControllerConfig();
        }

        @Override
        public void run() {
            
            /** Loader Main Panel **/
            loaderMainPanel.initializeGui(loaderConfig);
            
            /** CANopen hardware list panel **/
            hardwarePanel.initializeGui(canOpenProxyConfig);
            
            /** Clamp Controller Panel **/
            hooksControllerPanel.initializeGui(Tools.retrieveControllerInfo(canOpenProxyConfig,clampCtlConfig), clampCtlConfig);
            
            /** Carrier Controller Panel **/
            carrierControllerPanel.initializeGui(Tools.retrieveControllerInfo(canOpenProxyConfig,carrierCtlConfig), carrierCtlConfig);
        }
    }
    
    class UpdateCarrierController implements Runnable {
    
        StatusDataPublishedByEPOSController s;
        
        public UpdateCarrierController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            carrierControllerPanel.updateController(s);          
        }
    }
    
    class UpdateClampController implements Runnable {
    
        StatusDataPublishedByEPOSController s;
        
        public UpdateClampController(StatusDataPublishedByEPOSController s) {
            this.s = s;
        }

        @Override
        public void run() {
            hooksControllerPanel.updateController(s);          
        }
    }
    
     /**
     * Creates new form LoaderHighPanel
     */
    public LoaderTopPanel() {
        initComponents();
    }
    
    public LoaderTopPanel(LoaderGUI subs) {        
        this.subs = subs;

        initComponents();
        loaderMainPanel.setSubsystem(subs);
        this.hooksControllerPanel.setSubsystem(subs);
        this.carrierControllerPanel.setSubsystem(subs);       
    }
    
    @Override
    public SubsystemPanel getSubsystemPanel() {
        return loaderMainPanel.getSubsystemPanel();
    }
    
    public EPOSControllerPanel getHooksControllerPanel() {
        return hooksControllerPanel;
    }

    public EPOSControllerPanel getCarrierControllerPanel() {
        return carrierControllerPanel;
    }
    
    
    public void initializeGui(LoaderConfig loaderConfig) {
        SwingUtilities.invokeLater(new GuiInitialization(loaderConfig));
    }
    
    void updateLoaderGeneral(StatusDataPublishedByLoader statusDataPublishedByLoader) {
        this.loaderMainPanel.updateLoaderGeneral(statusDataPublishedByLoader);
    }
    

    void updateClamp(StatusDataPublishedByLoaderClamp statusDataPublishedByLoaderClamp) {
        this.loaderMainPanel.updateClamp(statusDataPublishedByLoaderClamp);
    }

    void updateCarrier(StatusDataPublishedByLoaderCarrier statusDataPublishedByLoaderCarrier) {
        this.loaderMainPanel.updateCarrier(statusDataPublishedByLoaderCarrier);
    }
    
    void updateCanOpenHardwarePanel(StatusDataPublishedByHardware statusDataPublishedByHardware) {
        this.hardwarePanel.updateCanOpenHardwarePanel(statusDataPublishedByHardware);
    }
    
    public void updateCarrierController(StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateCarrierController(status));
    }
    
    public void updateClampController(StatusDataPublishedByEPOSController status) {
        SwingUtilities.invokeLater(new UpdateClampController(status));
    }
    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description">                          
    private void initComponents() {
        //loader main panel
        loaderMainPanel = new LoaderMainPanel();
        //because the LoaderMainModule is too big we need a scrollBar.
        JScrollPane mainViewScrollPane = new JScrollPane(loaderMainPanel);
        mainViewScrollPane.createVerticalScrollBar();
        mainViewScrollPane.setPreferredSize(new Dimension(1200,900));
        //CANopen devices panel
        hardwarePanel = new CanOpenHardwarePanel();       
        //controllers Panels
        hooksControllerPanel = new EPOSControllerPanel();     
        carrierControllerPanel = new EPOSControllerPanel();
        //plutoGateway panel        
        plutoGWPanel = new JPanel();
        plutoGWPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.anchor = GridBagConstraints.NORTHWEST;
        gbc3.insets = insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        JLabel jl3 =new JLabel("Pluto Gateway Panel : work in progress.....");        
        plutoGWPanel.add(jl3,gbc3);
        
        //TabbedPane
        jTabbedPane = new JTabbedPane();  

        jTabbedPane.setTabPlacement(JTabbedPane.TOP);
        jTabbedPane.setBorder(BorderFactory.createLineBorder(new java.awt.Color(0, 150, 180)));
        jTabbedPane.addTab("Loader Main View", mainViewScrollPane);
        jTabbedPane.addTab("Loader CANopen Devices", hardwarePanel);
        jTabbedPane.addTab("Loader Clamp Controller", hooksControllerPanel);
        jTabbedPane.addTab("Loader Carrier Controller", carrierControllerPanel);
        jTabbedPane.addTab("Loader Pluto Gateway", plutoGWPanel);

        
        //Whole Panel
        setLayout(new GridBagLayout());
        setForeground(new Color(204, 204, 255));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gbc.gridx = 0;
        gbc.gridy = 0;    
        add(jTabbedPane, gbc);
        
    }
    
    
    
    public static void main(String[] argv) {
        
        LoaderTopPanel d = new LoaderTopPanel();
        JFrame frame = new JFrame("Loader High Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
        
    
}
