/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderCarrierConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderClampConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author virieux
 */
public class LoaderMainPanel extends JPanel {

    protected static final Logger log = Logger.getLogger("org.lsst.ccs.subsystems.fcs");

    private LoaderGUI subs;

    private final JLabel onCameraLabel = new JLabel("ON CAMERA SENSOR");
    private final JLabel autochangerHoldingFilterLabel = new JLabel("AUTOCHANGER HOLDING FILTER SENSOR");
    private final JPanel fakeSensorsPanel = new JPanel();
    private final JPanel controlPanel = new JPanel();
    private final LoaderClampPanel loaderClampPanel = new LoaderClampPanel();
    private final LoaderCarrierPanel loaderCarrierPanel = new LoaderCarrierPanel();
    private final SubsystemPanel subsystemPanel = new SubsystemPanel("Loader Subsystem State");
    private final DigitalSwitch onCameraDigitalSwitch = new DigitalSwitch();
    private final DigitalSwitch autochangerHoldingFilterDigitalSwitch = new DigitalSwitch();
    //control panel    
    private final JButton loadFilterButton = new JButton("loadFilterInCamera");
    private final JButton unloadFilterButton = new JButton("unloadFilterFromCamera");
    // End of variables declaration 

    /**
     * Creates new form LoaderMainPanel
     */
    public LoaderMainPanel() {
        initComponents();
    }

    public LoaderMainPanel(LoaderGUI subs) {
        this.subs = subs;
        loaderClampPanel.setLoaderSubsystem(subs);
        loaderCarrierPanel.setLoaderSubsystem(subs);
        subsystemPanel.setSubsystem(subs);
        initComponents();
    }

    public void setSubsystem(LoaderGUI newSubs) {
        this.subs = newSubs;
        subsystemPanel.setSubsystem(subs);
        loaderClampPanel.setLoaderSubsystem(newSubs);
        loaderCarrierPanel.setLoaderSubsystem(newSubs);
    }

    public LoaderClampPanel getLoaderClampPanel() {
        return loaderClampPanel;
    }

    public SubsystemPanel getSubsystemPanel() {
        return subsystemPanel;
    }
    
    

    public void initializeGui(LoaderConfig config) {
        SwingUtilities.invokeLater(new GuiInitialization(config));
    }

    public void updateLoaderGeneral(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateLoaderGeneral(status));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateCarrier(StatusDataPublishedByLoaderCarrier statusDataPublishedByLoaderCarrier) {
        SwingUtilities.invokeLater(new UpdateCarrier(statusDataPublishedByLoaderCarrier));
    }

    private class GuiInitialization implements Runnable {

        LoaderConfig loaderConfig;

        public GuiInitialization(LoaderConfig aConfig) {
            this.loaderConfig = aConfig;
            //controlRealHardwareLabel.setText(loaderConfig.isRealHardware() ? "Real Hardware" : "Simulation");
        }

        @Override
        public void run() {
            
            subsystemPanel.setcontrolRealHardwareLabelText(loaderConfig.isRealHardware() ? "Real Hardware" : "Simulation");

            LoaderClampConfig loaderClampConfig = loaderConfig.getLoaderClampConfig();
            subs.openHooksTimeout = loaderClampConfig.getTimeoutToOpen();
            subs.closeHooksTimeout = loaderClampConfig.getTimeoutToClose();
            subs.clampHooksTimeout = loaderClampConfig.getTimeoutToClamp();
            subs.homingHooksTimeout = loaderClampConfig.getTimeoutToGoHome();
            loaderClampPanel.initializeGui(loaderClampConfig);

            LoaderCarrierConfig loaderCarrierConfig = loaderConfig.getLoaderCarrierConfig();
            subs.goToHandoffTimeout = loaderCarrierConfig.getTimeoutToGoToHandoff();
            subs.goToStorageTimeout = loaderCarrierConfig.getTimeoutToGoToStorage();
            loaderCarrierPanel.initializeGui(loaderCarrierConfig);
        }
    }

    /**
     * To updateState the general items for loader.
     */
    class UpdateLoaderGeneral implements Runnable {

        StatusDataPublishedByLoader s;

        UpdateLoaderGeneral(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {

            if (s.isLoaderOnCameraSensorsInError()) {
                onCameraDigitalSwitch.setColor(Color.RED);
            } else {
                onCameraDigitalSwitch.setColor(s.getLoaderOnCameraSensorValue0() == 1 ? greenColor : Color.gray);
            }
            autochangerHoldingFilterDigitalSwitch.setColor(s.getAutochangerHoldingFilterSensorValue() == 1 ? greenColor : Color.gray);
            loaderClampPanel.updateClamp(s);
        }
    }

    class UpdateCarrier implements Runnable {

        StatusDataPublishedByLoaderCarrier s;

        public UpdateCarrier(StatusDataPublishedByLoaderCarrier s) {
            this.s = s;
        }

        @Override
        public void run() {
            loaderCarrierPanel.updateCarrier(s);

        }
    }

    class UpdateClamp implements Runnable {

        StatusDataPublishedByLoaderClamp s;

        UpdateClamp(StatusDataPublishedByLoaderClamp s) {
            this.s = s;
        }

        @Override
        public void run() {
            loaderClampPanel.updateClamp(s);

        }
    }

    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {

        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new java.awt.Color(255, 255, 0)), "LOADER"));
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());

        /**
         ******************************************************************************
         **  Control Panel
         ******************************************************************************
         */
        loadFilterButton.addActionListener((ActionEvent evt) -> {
            loadFilterActionPerformed(evt);
        });
        
        unloadFilterButton.addActionListener((ActionEvent evt) -> {
            unloadFilterActionPerformed(evt);
        });
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc0 = new GridBagConstraints();
        gbc0.insets = insets_std;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        gbc0.fill = GridBagConstraints.HORIZONTAL;
        controlPanel.add(loadFilterButton, gbc0);
        gbc0.gridy++;
        controlPanel.add(unloadFilterButton, gbc0);
         //end of Control Panel
        

        //Fake Sensors Panel 
        onCameraDigitalSwitch.setColor(Color.gray);
        autochangerHoldingFilterDigitalSwitch.setColor(Color.gray);
        fakeSensorsPanel.setBorder(BorderFactory.createTitledBorder("FAKE SENSORS"));
        fakeSensorsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = insets_std;
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.fill = GridBagConstraints.HORIZONTAL;
        fakeSensorsPanel.add(onCameraLabel, gbc1);

        gbc1.gridx++;
        fakeSensorsPanel.add(onCameraDigitalSwitch, gbc1);

        gbc1.insets = new Insets(0, 60, 0, 4);
        gbc1.gridx++;
        fakeSensorsPanel.add(autochangerHoldingFilterLabel, gbc1);
        gbc1.insets = insets_std;
        gbc1.gridx++;
        fakeSensorsPanel.add(autochangerHoldingFilterDigitalSwitch, gbc1);
        //end Fake Sensors Panel 

        //Whole Panel
        GridBagConstraints gbc = new GridBagConstraints();

        gbc.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gbc.insets = insets_std;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(subsystemPanel, gbc);
        gbc.gridx++;
        add(controlPanel, gbc);

        //gbc.anchor = java.awt.GridBagConstraints.CENTER;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy++;
        add(fakeSensorsPanel, gbc);

        gbc.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridwidth = 2;
        add(loaderClampPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridwidth = 1;
        add(loaderCarrierPanel, gbc);

    }// </editor-fold> 
    
    private void loadFilterActionPerformed(ActionEvent evt) {                                      
        subs.loadFilter();
    }
    
    private void unloadFilterActionPerformed(ActionEvent evt) {                                      
        subs.unloadFilter();
    }

    public static void main(String[] argv) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {

              // Set cross-platform Java L&F (also called "Metal")
        UIManager.setLookAndFeel(
        UIManager.getCrossPlatformLookAndFeelClassName());
        LoaderMainPanel d = new LoaderMainPanel();
        JFrame frame = new JFrame("Loader Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
}
