/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.loader.ui;

import org.lsst.ccs.subsystems.fcs.ui.commons.VerticalProgressBarPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoader;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderClampConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.FilterPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.bigFont;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author virieux
 */
public class LoaderClampPanel extends JPanel {
    protected static final Logger fcslog = Tools.fcslog;
    private LoaderGUI subs;
   

    private final JLabel clampState = new JLabel("UNKNOWN STATE");
    private final JLabel clampStateLabel = new JLabel("Clamp State :");
    private final JLabel xMinusLabel = new JLabel("X-");
    private final JLabel xMinuxLabel2 = new JLabel("X-");
    private final JLabel xPlusLabel = new JLabel("X+");
    private final JLabel xPlusLabel2 = new JLabel("X+");

    private LoaderHookPanel hookPanel1;
    private LoaderHookPanel hookPanel2;
    private LoaderHookPanel hookPanel3;
    private LoaderHookPanel hookPanel4;
    private final FilterPanel filterPanel = new FilterPanel();
    private VerticalProgressBarPanel positionProgressBarPanel;
    private VerticalProgressBarPanel currentProgressBarPanel;
    private JButton closeHooksButton;
    private JButton openHooksButton;
    private JButton goToClampedPositionButton;
    private JButton goToHomePositionButton;
    private JButton clampHooksButton;
    private JButton updateStateWithSensorsButton;
    private JButton abortButton;
    // End of variables declaration                

    
    /** Creates new form LoaderClampPanel */
    public LoaderClampPanel() {
        initComponents();      
    }

    public void setLoaderSubsystem(LoaderGUI subs) {      
        this.subs = subs;
    }
    
    public void initializeGui(LoaderClampConfig config) {
        SwingUtilities.invokeLater(new GuiInitialization(config));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }
    
    public void updateClamp(StatusDataPublishedByLoader status) {
        SwingUtilities.invokeLater(new UpdateFilterPanel(status));
    }
    
    
    private  class GuiInitialization implements Runnable {
        
        LoaderClampConfig loaderClampConfig;

        public GuiInitialization(LoaderClampConfig aConfig) {
            this.loaderClampConfig = aConfig;
        }

        @Override
        public void run() {           
            positionProgressBarPanel.setMinValue(loaderClampConfig.getMinPosition());
            positionProgressBarPanel.setMaxValue(loaderClampConfig.getMaxPosition());
            positionProgressBarPanel.setValue(0);
            currentProgressBarPanel.setMinValue(loaderClampConfig.getMinCurrent());
            currentProgressBarPanel.setMaxValue(loaderClampConfig.getMaxCurrent());
            currentProgressBarPanel.setValue(0);
        }
    }
    
    
    class UpdateClamp implements Runnable {
        
        StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        @Override
        public void run() {
            
            Color clampStateColor = s.getClampState().getColor();
            int clampPosition = s.getPosition();
            clampState.setText(s.getClampState().getText());
            clampState.setForeground(clampStateColor);   
            positionProgressBarPanel.setValue(clampPosition);
            positionProgressBarPanel.setColor(clampStateColor);
            currentProgressBarPanel.setValue(s.getCurrent());
            hookPanel1.updateHook(s.getStatusPublishedByHook1());
            hookPanel2.updateHook(s.getStatusPublishedByHook2());
            hookPanel3.updateHook(s.getStatusPublishedByHook3());
            hookPanel4.updateHook(s.getStatusPublishedByHook4());
            
            
        }
    }
    
    class UpdateFilterPanel implements Runnable {
        
        StatusDataPublishedByLoader s;

        public UpdateFilterPanel(StatusDataPublishedByLoader s) {
            this.s = s;
        }

        @Override
        public void run() {
            if (s.isFilterPresenceSensorsInError()) {
                filterPanel.setColor(Color.red);
            } else {
                filterPanel.setIsFilterInHouse( s.getFilterPresenceSensorValue0() == 1);
            }
        }
    
    }
    
    
     /** This method is called from within the constructor to
     * initialize the form.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {

        //X- and X+ label
        Font xFont = new Font("Tahoma", 1, 18);
        xMinusLabel.setFont(xFont); // NOI18N      
        xMinuxLabel2.setFont(xFont); // NOI18N
        xPlusLabel2.setFont(xFont); // NOI18N       
        xPlusLabel.setFont(xFont); // NOI18N
        JPanel hooksPanel = new JPanel();
        JPanel clampStatePanel = new JPanel();
        JPanel controlPanel = new JPanel();
        hookPanel2 = new LoaderHookPanel();
        hookPanel4 = new LoaderHookPanel();
        hookPanel3 = new LoaderHookPanel();
        hookPanel1 = new LoaderHookPanel();
        
        currentProgressBarPanel = new VerticalProgressBarPanel("Current",-300,500,0);
        currentProgressBarPanel.setStringPainted(false);
        positionProgressBarPanel = new VerticalProgressBarPanel("Position",5000,480000,0);

        
        filterPanel.setColor(Color.gray);
        
        updateStateWithSensorsButton = new JButton("Read sensors and update state");
        openHooksButton = new JButton("Open");
        goToClampedPositionButton = new JButton("Go To Clamped Position");
        clampHooksButton = new JButton("Clamp");
        closeHooksButton = new JButton("Close");
        goToHomePositionButton = new JButton("Go To Home Position");
        abortButton = new JButton("Abort");

        updateStateWithSensorsButton.addActionListener(new ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                updateStateWithSensorsButtonActionPerformed(evt);
            }
        });
        
        openHooksButton.addActionListener(new ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                openHooksButtonActionPerformed(evt);
            }
        });

        goToClampedPositionButton.addActionListener(new ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                goToClampedPositionButtonActionPerformed(evt);
            }
        });

        clampHooksButton.addActionListener(new ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clampHooksButtonActionPerformed(evt);
            }
        });

        closeHooksButton.addActionListener(new ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeHooksButtonActionPerformed(evt);
            }
        });

        goToHomePositionButton.addActionListener(new ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                goToHomePositionButtonActionPerformed(evt);
            }
        });

        abortButton.addActionListener(new ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                abortActionPerformed(evt);
            }
        });

        
        /**
         ******************************************************************************
         **  Clamp State Panel
         ******************************************************************************
         */
        clampState.setFont(bigFont); // NOI18N
        clampState.setBorder(javax.swing.BorderFactory.createEtchedBorder(new java.awt.Color(255, 255, 255), new java.awt.Color(255, 255, 255)));
        clampStatePanel.setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        clampStatePanel.add(clampStateLabel, gbc2);
        gbc2.gridx++;
        clampStatePanel.add(clampState, gbc2);       
        /**
         ******************************************************************************
         **  end of Clamp State Panel
         ******************************************************************************
         */
        
        /**
         ******************************************************************************
         **  Hooks Panel
         ******************************************************************************
         */
        hooksPanel.setLayout(new java.awt.GridBagLayout());
        hooksPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.ORANGE), "Hooks State"));
        GridBagConstraints gbc1 = new java.awt.GridBagConstraints();
        gbc1.insets = insets_std;
        
        hookPanel1.setHookName("Hook 1");
        hookPanel1.setHookLocation(LoaderHookPanel.LEFT);
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        hooksPanel.add(hookPanel1, gbc1);
        
        hookPanel2.setHookName("Hook 2");
        hookPanel2.setHookLocation(LoaderHookPanel.LEFT);
        gbc1.gridx++;
        hooksPanel.add(hookPanel2, gbc1);
        
        hookPanel3.setHookName("Hook 3");
        hookPanel3.setHookLocation(LoaderHookPanel.LEFT);
        gbc1.gridx = 0;
        gbc1.gridy = 1;
        hooksPanel.add(hookPanel3, gbc1);

        hookPanel4.setHookName("Hook 4");
        hookPanel4.setHookLocation(LoaderHookPanel.LEFT);
        gbc1.gridx++;
        hooksPanel.add(hookPanel4, gbc1);
        /**
         ******************************************************************************
         **  End of Hooks Panel
         ******************************************************************************
         */
        
         /**
         ******************************************************************************
         **  Control Panel
         ******************************************************************************
         */
        controlPanel.setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc3 = new java.awt.GridBagConstraints();
        gbc3.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc3.fill = GridBagConstraints.HORIZONTAL;
        gbc3.insets = insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        controlPanel.add(updateStateWithSensorsButton,gbc3);
        gbc3.gridy++;
        controlPanel.add(goToHomePositionButton,gbc3);
        gbc3.gridy++;
        controlPanel.add(goToClampedPositionButton,gbc3);
        gbc3.gridy++;
        controlPanel.add(openHooksButton,gbc3);
        gbc3.gridy++;
        controlPanel.add(closeHooksButton,gbc3);
        gbc3.gridy++;
        controlPanel.add(clampHooksButton,gbc3);
        gbc3.gridy++;
        controlPanel.add(abortButton,gbc3);
         /**
         ******************************************************************************
         **  End of Control Panel
         ******************************************************************************
         */


        
        /**
         ******************************************************************************
         **  Whole Panel
         ******************************************************************************
         */
        setBorder(javax.swing.BorderFactory.createTitledBorder("LOADER CLAMP"));
        //setBorder(javax.swing.BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.PINK),"LOADER CLAMP"));
        //setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.WEST;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(xMinusLabel, gbc);
        gbc.anchor = GridBagConstraints.EAST;
        gbc.gridx = 3;
        add(xPlusLabel, gbc);
        
        gbc.gridx = 0;       
        gbc.gridwidth = 4;
        gbc.anchor = GridBagConstraints.CENTER;
        add(clampStatePanel, gbc);
        gbc.gridy++;
        add(hooksPanel, gbc);
        
        gbc.insets = insets_big;
        gbc.insets = new Insets(14,30,6,30);
        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridwidth = 1;
        //add(hooksPositionVerticalProgressBarPanel, gbc);
        add(positionProgressBarPanel, gbc);
        gbc.gridx++;
        //add(actualCurrentVerticalProgressBarPanel, gbc);
        add(currentProgressBarPanel, gbc);
        gbc.gridx++;
        add(filterPanel,gbc);
        gbc.gridx++;
        gbc.anchor = GridBagConstraints.EAST;
        add(controlPanel,gbc);
        
    }// </editor-fold>                        

    private void updateStateWithSensorsButtonActionPerformed(java.awt.event.ActionEvent evt) {                                                
    
        subs.updateStateWithSensors();
    }  
        
    private void openHooksButtonActionPerformed(java.awt.event.ActionEvent evt) {                                                
    
        subs.openHooks();
    }                                               

    private void closeHooksButtonActionPerformed(java.awt.event.ActionEvent evt) {                                                 

        subs.closeHooks();
    }                                                

    private void clampHooksButtonActionPerformed(java.awt.event.ActionEvent evt) {                                                 
        subs.clampHooks();
    }                                                

    private void goToHomePositionButtonActionPerformed(java.awt.event.ActionEvent evt) {                                                       
        subs.goToHomePosition();
    }                                                      

    private void goToClampedPositionButtonActionPerformed(java.awt.event.ActionEvent evt) {                                                          
        subs.goToClosePosition();
    }                                                         

    private void abortActionPerformed(java.awt.event.ActionEvent evt) {                                      
        subs.abortAction();
    }  
    
   public static void main(String[] argv) {
        
        LoaderClampPanel d = new LoaderClampPanel();
        JFrame frame = new JFrame("New Loader Clamp Panel");
        d.currentProgressBarPanel.setValueName("Current");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
    
}
