/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.carousel.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.carousel.config.CarouselConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author virieux
 */
public class CarouselMainPanel extends JPanel {
    
    protected static final Logger log = Logger.getLogger("org.lsst.ccs.subsystems.fcs"); 
    
    private CarouselGUI subs;
    SubsystemPanel subsystemPanel;
    
    private class GuiInitialization implements Runnable {
        CarouselConfig config;
        public GuiInitialization(CarouselConfig aConfig) {
            this.config = aConfig;
            subsystemPanel.setcontrolRealHardwareLabelText(config.isRealHardware() ? "Real Hardware" : "Simulation");
        }
        @Override
        public void run() {
        }
    }

    public CarouselMainPanel() {
        initComponents();
    }

    public CarouselMainPanel(CarouselGUI subs) {
        this.subs = subs;
        initComponents();
    }

    public void setSubsystem(CarouselGUI subs) {
        this.subs = subs;
    }

    public SubsystemPanel getSubsystemPanel() {
        return subsystemPanel;
    }
    
    
    
    public void initializeGui(CarouselConfig config) {
        SwingUtilities.invokeLater(new GuiInitialization(config));
    }
    


    
    
    
    
    


    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {
        
        subsystemPanel = new SubsystemPanel("Carousel Subsystem State");

        //Whole Panel
        GridBagConstraints gbc = new GridBagConstraints();
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new java.awt.Color(255, 255, 0)), "CAROUSEL"));
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());
        gbc.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(subsystemPanel, gbc);
    }
    
    public static void main(String[] argv) {
        
        CarouselMainPanel d = new CarouselMainPanel();
        JFrame frame = new JFrame("Carousel Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
    
    
}
