/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.carousel.ui;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.messages.AgentInfo;
import org.lsst.ccs.bus.messages.CommandAck;
import org.lsst.ccs.bus.messages.CommandError;
import org.lsst.ccs.bus.messages.CommandNack;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.CommandResult;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.CommandOriginator;

import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import static org.lsst.ccs.subsystems.fcs.carousel.ui.CarouselMainPanel.log;
import org.lsst.ccs.subsystems.fcs.carousel.config.CarouselConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.GeneralGUI;

/**
 *
 * @author virieux
 */
public class CarouselGUI extends GeneralGUI{
    private long lastHeartBeat = 0, lastStateRequest = 0;
    String stateCorrelId;

    public CarouselGUI(String name, String destination, AgentMessagingLayer aml) {
        super(name, destination, aml);
        this.topPanel = new CarouselTopPanel(this);
        pane = new JScrollPane(topPanel);
    }
    


    @Override
    public void onDataArrival(String source, long timestamp, String dataType, Object s) {
        //If this data status is not for us we forget it.
        if (!source.equals(destination)) {
            return;
        }
        if (initialized) {
            switch (dataType) {
                    
                case "tcpProxy":
                    log.debug(getName() + " read data dataType:tcpProxy");
                    ((CarouselTopPanel)topPanel).updateCanOpenHardwarePanel((StatusDataPublishedByHardware) s);
                    lastHeartBeat = timestamp;
                    break;                               

                case "carouselController":
                    log.debug(getName() + " read data dataType:linearRailMasterController");
                    ((CarouselTopPanel)topPanel).updateCarouselController((StatusDataPublishedByEPOSController) s);
                    lastHeartBeat = timestamp;
                    break;
                   
                default:
                    log.warning(getName() + " An unexpected dataType was read on the status bus:" + dataType);
                    break;
            }
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastStateRequest > 2000) {
                lastStateRequest = currentTime;
//                ModuleInvokerCommand cmd = new ModuleInvokerCommand("getFullState");
//                sendAsynchronousCommand(cmd);
//                stateCorrelId = cmd.getCorrelId();
                CommandRequest cmd = new CommandRequest(destination, "getFullState");
                aml.sendCommandRequest(cmd, new CommandOriginator() {

                    @Override
                    public void processAck(CommandAck ack) {
                    }

                    @Override
                    public void processResult(CommandResult result) {
                        CarouselConfig config = (CarouselConfig) result.getReply();
                        log.debug("--- Got a reply from subs");
                        ((CarouselTopPanel)topPanel).initializeGui(config);
                        initialized = true;
                    }

                    @Override
                    public void processNack(CommandNack nack) {
                    }

                    @Override
                    public void processError(CommandError nack) {
                    }
                });
            }
        }    
    }
    
     /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        Agent agent = new Agent("CarouselGUI", AgentInfo.AgentType.CONSOLE);
        CarouselGUI t = new CarouselGUI(agent.getName(),"carousel", agent.getMessagingAccess());
        agent.start();

        JFrame frame = new JFrame("Carousel View GUI");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }    
    
}
