/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeSelectionModel;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.preferedPanelSize;

/**
 *
 * @author virieux
 */
public class AutochangerTreePanel extends JPanel implements TreeSelectionListener{
    
    String title;
    JTree tree;
    JPanel rightPanel;
    JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
    JPanel helpPanel;
    AutochangerGatherPanel gatherPanel;
    

    public AutochangerTreePanel(String title) {
        this.title = title;
        initComponents();
    }
    
    public AutochangerTreePanel(String title, AutochangerGatherPanel gatherPanel) {
        this.title = title;
        this.gatherPanel = gatherPanel;
        initComponents();
    }
    
    

    public void createNodes(DefaultMutableTreeNode top) {

        if (gatherPanel == null) gatherPanel = new AutochangerGatherPanel();
        DefaultMutableTreeNode devicesNode = new DefaultMutableTreeNode("CANopen devices");
        devicesNode.add(new DefaultMutableTreeNode(gatherPanel.getHardwarePanel()));
        devicesNode.add(new DefaultMutableTreeNode(gatherPanel.getPlutoGatewayPanel()));
        devicesNode.add(new DefaultMutableTreeNode(gatherPanel.getLatchXminusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(gatherPanel.getLatchXplusControllerPanel()));
        devicesNode.add(new DefaultMutableTreeNode(gatherPanel.getLinearRailSlaveControllerPanel()));       
        devicesNode.add(new DefaultMutableTreeNode(gatherPanel.getLinearRailMasterControllerPanel()));        
        devicesNode.add(new DefaultMutableTreeNode(gatherPanel.getOnlineClampXminusControllerPanel()));       
        devicesNode.add(new DefaultMutableTreeNode(gatherPanel.getOnlineClampXplusControllerPanel()));       
        devicesNode.add(new DefaultMutableTreeNode(gatherPanel.getOnlineClampZControllerPanel()));
        top.add(devicesNode);

        top.add(new DefaultMutableTreeNode(gatherPanel.getAcGeneralViewPanel()));

        top.add(new DefaultMutableTreeNode(gatherPanel.getAcLatchesPanel()));
        
        top.add(new DefaultMutableTreeNode(gatherPanel.getAcTrucksPanel()));

        top.add(new DefaultMutableTreeNode(gatherPanel.getAcClampsPanel()));

    }
    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {

        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new java.awt.Color(255, 255, 0)), title));
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());
        
        //Create the nodes.
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(title);
        createNodes(top);


        //Create a tree that allows one selection at a time.
        tree = new JTree(top);
        tree.getSelectionModel().setSelectionMode
                (TreeSelectionModel.SINGLE_TREE_SELECTION);

        //Listen for when the selection changes.
        tree.addTreeSelectionListener(this);
        tree.setMinimumSize(new Dimension(110,100));

        splitPane.setLeftComponent(tree);
        //Create the viewing rightPanel.
        rightPanel = new JPanel();
        splitPane.setRightComponent(rightPanel);
     
        splitPane.setDividerLocation(200); 
        splitPane.setPreferredSize(preferedPanelSize);

        //Add the split rightPanel to this Panel.
        add(splitPane);
        
        //TODO fill helpPanel
        helpPanel = new JPanel();
        JLabel helpLabel = new JLabel("Nothing to display");
        helpPanel.add(helpLabel);
    }
    
    
    private void displayPanel(JPanel panel) {
        if (panel != null) {
            JScrollPane scrollPane = new JScrollPane(panel);
            splitPane.setRightComponent(scrollPane);
        } else { 

            JScrollPane scrollPane = new JScrollPane(helpPanel);
            splitPane.setRightComponent(scrollPane);
        }
    }


    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)
                           tree.getLastSelectedPathComponent();

        if (node == null) return;

        Object nodeInfo = node.getUserObject();
        
        if (nodeInfo == null) return;
        
        if (node.isLeaf()) {
            JPanel panel = (JPanel)nodeInfo;
            displayPanel(panel);
        } else {
            //TODO find something cleaver to be done here
        }

    }
    
    public static void main(String[] argv) {
        AutochangerTreePanel d = new AutochangerTreePanel("Autochanger");
        JFrame frame = new JFrame("Autochanger Top Tree Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

    
}
