/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

/**
 *
 * @author virieux
 */
public final class AutochangerTopTabbedPanel extends AutochangerGatherPanel {
    
    private JTabbedPane jTabbedPane;

    
    public AutochangerTopTabbedPanel() {
        initComponents();
    }

    public AutochangerTopTabbedPanel(AutochangerGeneralGUI subs) {
        super(subs);
        initComponents();
    }
    
    
    
    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form description">                          

    protected void initComponents() {
        //because the AutoChangerMainPanel is too big we need a scrollBar.
        JScrollPane mainViewScrollPane = new JScrollPane(autochangerMainPanel);
        mainViewScrollPane.createVerticalScrollBar();
        mainViewScrollPane.setPreferredSize(new Dimension(1200,600));

        //TabbedPane
        jTabbedPane = new JTabbedPane();  
        jTabbedPane.setBorder(BorderFactory.createLineBorder(new java.awt.Color(0, 150, 180)));
        jTabbedPane.addTab("Autochanger Main View", mainViewScrollPane);
        jTabbedPane.addTab("Autochanger CANopen Devices", hardwarePanel);
        jTabbedPane.addTab("Linear Rail Master Controller", linearRailMasterControllerPanel);
        jTabbedPane.addTab("Linear Rail Slave Controller", linearRailSlaveControllerPanel);
        jTabbedPane.addTab("LatchXminus Controller", latchXminusControllerPanel);
        jTabbedPane.addTab("LatchXplus Controller", latchXplusControllerPanel);
        jTabbedPane.addTab("OnlineClampXminus Controller", onlineClampXminusControllerPanel);
        jTabbedPane.addTab("OnlineClampXplus Controller", onlineClampXplusControllerPanel);
        jTabbedPane.addTab("OnlineClampZ Controller", onlineClampZControllerPanel);
        jTabbedPane.addTab("Pluto Gateway", plutoGatewayPanel);

        
        //Whole Panel
        setLayout(new GridBagLayout());
        setForeground(new Color(204, 204, 255));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gbc.gridx = 0;
        gbc.gridy = 0;    
        add(jTabbedPane, gbc);
    }
    
    public static void main(String[] argv) {
        AutochangerTopTabbedPanel d = new AutochangerTopTabbedPanel();
        JFrame frame = new JFrame("Autochanger High Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }
    
    
}
