/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.bigFont;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_big;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;

/**
 *
 * @author virieux
 */
public class AutochangerThreeOnlineClampsPanel extends JPanel {
    
    private AutochangerGeneralGUI subs;
   

    private final JLabel clampsState = new JLabel("UNKNOWN STATE");
    private final JLabel clampsStateLabel = new JLabel("CLAMPS STATE :");
    private final JLabel xMinusLabel = new JLabel("X-");
    private final JLabel xMinuxLabel2 = new JLabel("X-");
    private final JLabel xPlusLabel = new JLabel("X+");
    private final JLabel xPlusLabel2 = new JLabel("X+");
    private final JLabel yLabel = new JLabel("Y-");
    private final JLabel yLabel2 = new JLabel("Y-");
    JPanel clampsPanel = new JPanel();
    JPanel clampsStatePanel = new JPanel();
    JPanel controlPanel = new JPanel();
    AutochangerOnlineClampPanel clampXminusPanel;
    AutochangerOnlineClampPanel clampXplusPanel;
    AutochangerOnlineClampPanel clampYPanel;
    
    private final JButton lockClampsButton = new JButton("Lock Clamps");
    private final JButton unlockClampsButton = new JButton("Unlock Clamps");
    private final JButton updateStateWithSensorsButton= new JButton("Read sensors and update state");
    private final JButton abortButton = new JButton("Abort");
    // End of variables declaration 
    
    class UpdateClamps implements Runnable {
        
        StatusDataPublishedByAutochangerThreeClamps s;

        public UpdateClamps(StatusDataPublishedByAutochangerThreeClamps status) {
            this.s = status;
        }

        @Override
        public void run() {
            clampsState.setText(s.getLockStatus().getText());
            clampsState.setForeground(s.getLockStatus().getColor());   
        }
    }

    public AutochangerThreeOnlineClampsPanel() {
        initComponents();
    }
    
    public void setSubsystem(AutochangerGeneralGUI subs) {
        this.subs = subs;
    }
    
    //TODO
    void initializeGui(AutochangerConfig autochangerConfig) {
    }
    

    void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        SwingUtilities.invokeLater(new UpdateClamps(s));
    }
    
    public void updateClampXminus(StatusDataPublishedByAutochangerOnlineClamp s) {
        clampXminusPanel.updateClamp(s);
    }
    
    public void updateClampXplus(StatusDataPublishedByAutochangerOnlineClamp s) {
        clampXplusPanel.updateClamp(s);
    }
    
    public void updateClampZ(StatusDataPublishedByAutochangerOnlineClamp s) {
        clampYPanel.updateClamp(s);
    }
    
    
    
     /** This method is called from within the constructor to
     * initialize the form.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {
        /**
         ******************************************************************************
         **  Buttons initialization
         ******************************************************************************
         */ 
        updateStateWithSensorsButton.addActionListener((ActionEvent evt) -> {
            updateStateWithSensorsButtonActionPerformed(evt);
        });

        lockClampsButton.addActionListener((ActionEvent evt) -> {
            lockClampsButtonActionPerformed(evt);
        });
        
        unlockClampsButton.addActionListener((ActionEvent evt) -> {
            unlockClampsButtonActionPerformed(evt);
        });
        
        abortButton.addActionListener((ActionEvent evt) -> {
            abortButtonActionPerformed(evt);
        });
         /**
         ******************************************************************************
         **  end of Buttons initialization
         ******************************************************************************
         */

        //X- and X+ and Z label
        Font xFont = new Font("Tahoma", 1, 18);
        xMinusLabel.setFont(xFont); // NOI18N      
        xMinuxLabel2.setFont(xFont); // NOI18N
        xPlusLabel2.setFont(xFont); // NOI18N       
        xPlusLabel.setFont(xFont); // NOI18N
        yLabel.setFont(xFont); // NOI18N 
        yLabel2.setFont(xFont); // NOI18N  

        clampXminusPanel = new AutochangerOnlineClampPanel();
        clampXplusPanel = new AutochangerOnlineClampPanel();
        clampYPanel = new AutochangerOnlineClampPanel();
        

        
         /**
         ******************************************************************************
         **  Clamps State Panel
         ******************************************************************************
         */
        clampsState.setFont(bigFont); // NOI18N
        clampsState.setBorder(BorderFactory.createEtchedBorder(new java.awt.Color(255, 255, 255), new java.awt.Color(255, 255, 255)));
        clampsStatePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.insets = insets_std;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        clampsStatePanel.add(clampsStateLabel, gbc2);
        gbc2.gridx++;
        clampsStatePanel.add(clampsState, gbc2);       
        /**
         ******************************************************************************
         **  end of Clamps State Panel
         ******************************************************************************
         */
        
         /**
         ******************************************************************************
         **  Clamps Panel
         ******************************************************************************
         */
        clampsPanel.setLayout(new GridBagLayout());
        clampsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.YELLOW), "ONLINE Clamps"));
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.insets = insets_std;
        
        clampXminusPanel.setClampName("OnlineClamp 1");
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        clampsPanel.add(clampXminusPanel, gbc1);
        
        clampXplusPanel.setClampName("OnlineClamp 2");
        gbc1.gridx++;
        clampsPanel.add(clampXplusPanel, gbc1);
        
        clampYPanel.setClampName("OnlineClamp 3");
        gbc1.gridx = 0;
        gbc1.gridy++;
        gbc1.gridwidth = 2;
        clampsPanel.add(clampYPanel, gbc1);
//        gbc1.gridwidth = 1;
//        gbc1.gridx = 1;
//        clampsPanel.add(controlPanel, gbc1);

        /**
         ******************************************************************************
         **  End of Clamps Panel
         ******************************************************************************
         */ 
        
         /**
         ******************************************************************************
         **  Control Panel
         ******************************************************************************
         */
        controlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.anchor = GridBagConstraints.FIRST_LINE_START;
        gbc3.fill = GridBagConstraints.HORIZONTAL;
        gbc3.insets = insets_std;
        gbc3.gridx = 0;
        gbc3.gridy = 0;
        controlPanel.add(updateStateWithSensorsButton,gbc3);
        gbc3.gridy++;
        controlPanel.add(lockClampsButton,gbc3);
        gbc3.gridy++;
        controlPanel.add(unlockClampsButton,gbc3);
        gbc3.gridy++;
        controlPanel.add(abortButton,gbc3);
         /**
         ******************************************************************************
         **  End of Control Panel
         ******************************************************************************
         */
        
         /**
         ******************************************************************************
         **  Whole Panel
         ******************************************************************************
         */
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.PINK),"AUTOCHANGER ONLINE CLAMPS"));
        //setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets_std;
        gbc.anchor = GridBagConstraints.WEST;

        gbc.gridx = 0;
        gbc.gridy = 0;
        add(xMinusLabel, gbc);
        gbc.anchor = GridBagConstraints.EAST;
        gbc.gridx = 3;
        add(xPlusLabel, gbc);
        
        gbc.gridx = 0;       
        gbc.gridwidth = 4;
        gbc.anchor = GridBagConstraints.CENTER;
        add(clampsStatePanel, gbc);
        gbc.gridy++;
        add(clampsPanel, gbc);
        
        gbc.gridy++;
        add(yLabel,gbc);
        
        gbc.insets = insets_big;
        gbc.insets = new Insets(14,30,6,30);
        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridx++;
        gbc.anchor = GridBagConstraints.EAST;
        add(controlPanel,gbc);
        
    }
    
    private void updateStateWithSensorsButtonActionPerformed(ActionEvent evt) {                                                
           subs.updateStateWithSensors();
    }
    
    private void lockClampsButtonActionPerformed(ActionEvent evt) {                                                
           subs.lockOnlineClamps();
    }
    
    private void unlockClampsButtonActionPerformed(ActionEvent evt) {                                                
           subs.unlockOnlineClamps();
    }
    
    private void abortButtonActionPerformed(ActionEvent evt) {                                                
           subs.abortAction();
    }    
    
    @Override
    public String toString() {
        return "ONLINE Clamps";
    }
    
    public static void main(String[] argv) {
        
        AutochangerThreeOnlineClampsPanel d = new AutochangerThreeOnlineClampsPanel();
        JFrame frame = new JFrame("Autochanger Clamps Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }    




    
}
