/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.states.StateBundle;

import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.Tools;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.greenColor;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.insets_std;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author virieux
 */
public class AutochangerMainPanel extends JPanel {
    
    protected static final Logger fcslog = Tools.fcslog;
    
    private AutochangerGeneralGUI subs;
    
    private final SubsystemPanel subsystemPanel = new SubsystemPanel("Autochanger Subsystem State");
    //LoaderConnectedPanel
    private final JPanel loaderConnectedPanel = new JPanel();
    JLabel loaderConnectedLabel = new JLabel("<html><P align=\"center\">Loader<br>sensor</p></html>");
    DigitalSwitch loaderConnectedDigitalSwitch = new DigitalSwitch();

    String connectedS = "<html><P align=\"center\">Loader<br>connected</p></html>";
    String notConnectedS = "<html><P align=\"center\">Loader<br>not<br>connected</p></html>";
    
    AutochangerTrucksPanel acTrucksPanel = new AutochangerTrucksPanel();
    AutochangerTwoLatchesPanel acLatchesPanel = new AutochangerTwoLatchesPanel();


    
    private class GuiInitialization implements Runnable {
        AutochangerConfig acConfig;
        
        public GuiInitialization(AutochangerConfig aConfig) {
            this.acConfig = aConfig;            
        }
        
        @Override
        public void run() {
            subsystemPanel.setcontrolRealHardwareLabelText(acConfig.isRealHardware() ? "Real Hardware" : "Simulation");
 
            //trucks
            subs.setTimeoutForTrucksMotion(acConfig.getTrucksConfig().getTimeoutForTrucksMotion());
            acTrucksPanel.initializeGui(acConfig.getTrucksConfig());

            //latches
            acLatchesPanel.initializeGui(acConfig);
        }
    }

    /**
     * A Runnable to updateState the main panel when AutoChangerModule publishes data.
     */
    private class Update implements Runnable {
        StatusDataPublishedByAutoChanger s;
        
        public Update(StatusDataPublishedByAutoChanger status) {
            this.s = status;           
        }
        
        @Override
        public void run() {
            if (s.isLoaderConnectedSensorsInError()) {
                loaderConnectedDigitalSwitch.setColor(Color.RED);
            //if loader is connected
            } else if ((s.getLoaderConnectedSensorValue0() == 1)
                    && (s.getLoaderConnectedSensorValue1() == 1)) {
                loaderConnectedDigitalSwitch.setColor(greenColor);
                loaderConnectedLabel.setText(connectedS);
            //if loader is not connected    
            } else {
                loaderConnectedDigitalSwitch.setColor(Color.gray);
                loaderConnectedLabel.setText(notConnectedS);
            }
        }
    }
    

    public AutochangerMainPanel() {
        initComponents();
    }

    public AutochangerMainPanel(AutochangerGeneralGUI subs) {
        this.subs = subs;
        initComponents();
        subsystemPanel.setSubsystem(subs);
        acTrucksPanel.setSubsystem(subs);

    }

    public void setSubsystem(AutochangerGeneralGUI subs) {
        this.subs = subs;
        subsystemPanel.setSubsystem(subs);
        acTrucksPanel.setSubsystem(subs);
        acLatchesPanel.setSubsystem(subs);
    }

    public SubsystemPanel getSubsystemPanel() {
        return subsystemPanel;
    }

    public AutochangerTrucksPanel getAcTrucksPanel() {
        return acTrucksPanel;
    }

    public AutochangerTwoLatchesPanel getAcLatchesPanel() {
        return acLatchesPanel;
    }

    public void setAcTrucksPanel(AutochangerTrucksPanel acTrucksPanel) {
        this.acTrucksPanel = acTrucksPanel;
    }

    public void setAcLatchesPanel(AutochangerTwoLatchesPanel acLatchesPanel) {
        this.acLatchesPanel = acLatchesPanel;
    }
    
    
    
    
    public void initializeGui(AutochangerConfig config) {
        SwingUtilities.invokeLater(new GuiInitialization(config));
    }
    
    void updateSubsystemState(StateBundle state) {
        this.subsystemPanel.updateState(state);
    }
    
    public void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        fcslog.finest(getName() + " Data published by Trucks= " + s.toString());
        acTrucksPanel.updateTrucks(s);
    }
    
    public void updateLatch(StatusDataPublishedByAutochangerLatch s) {
        fcslog.finest(getName() + " Data published by Latch= " + s.toString());
        acLatchesPanel.updateLatch(s);
    } 
    
    public void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        fcslog.finest(getName() + " Data published by Latches= " + s.toString());
        acLatchesPanel.updateLatches(s);
    }   
    
    public void update(StatusDataPublishedByAutoChanger s) {
        SwingUtilities.invokeLater(new Update(s));
    }

    
    
    
    
    
    


    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Form Description">                          
    private void initComponents() {
        //LoaderConnectedPanel
        loaderConnectedDigitalSwitch.setColor(Color.GRAY);

        GridBagConstraints gbc0 = new GridBagConstraints();
        loaderConnectedPanel.setBorder(BorderFactory.createLineBorder(Color.pink, WIDTH+5));
        gbc0.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gbc0.gridx = 0;
        gbc0.gridy = 0;
        loaderConnectedPanel.add(loaderConnectedLabel,gbc0);
        gbc0.gridy++;
        loaderConnectedPanel.add(loaderConnectedDigitalSwitch,gbc0);

        //Whole Panel
        GridBagConstraints gbc = new GridBagConstraints();
        setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new java.awt.Color(255, 255, 0)), "AUTOCHANGER"));
        setForeground(new Color(204, 204, 255));
        setLayout(new GridBagLayout());
        gbc.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gbc.insets = insets_std;
        gbc.gridx = 0;
        gbc.gridy = 0;
        add(subsystemPanel, gbc);
        gbc.gridx++;
        add(loaderConnectedPanel,gbc);
        gbc.gridx = 0;
        gbc.gridy++;
        gbc.gridwidth = 2;
        add(acLatchesPanel,gbc);
        gbc.gridy++;
        add(acTrucksPanel, gbc);
    }
    
    @Override
    public String toString() {
        return "Main View Panel";
    }
    
    public static void main(String[] argv) {
        
        AutochangerMainPanel d = new AutochangerMainPanel();
        JFrame frame = new JFrame("Autochanger Main Panel");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }
    
}
