/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.autochanger.ui;

import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChanger;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutoChangerTrucks;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerLatch;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerOnlineClamp;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerThreeClamps;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByAutochangerTwoLatches;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByEPOSController;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByHardware;
import org.lsst.ccs.subsystems.fcs.autochanger.config.AutochangerConfig;
import org.lsst.ccs.subsystems.fcs.config.CanOpenProxyConfig;
import org.lsst.ccs.subsystems.fcs.config.EPOSControllerConfig;
import org.lsst.ccs.subsystems.fcs.config.PlutoGatewayConfig;
import org.lsst.ccs.subsystems.fcs.ui.commons.CanOpenHardwarePanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.EPOSControllerPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.PlutoGatewayPanel;
import org.lsst.ccs.subsystems.fcs.ui.commons.SubsystemPanel;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.retrieveControllerInfo;
import static org.lsst.ccs.subsystems.fcs.ui.commons.Tools.retrieveDeviceInfo;
import org.lsst.ccs.subsystems.fcs.ui.commons.TopPanel;

/**
 * This panel gathers all the panels needed for the autochanger GUI.
 * It takes care of the initialization of the panels and the update of the panels.
 * @author virieux
 */
public class AutochangerGatherPanel extends TopPanel {

    protected AutochangerGeneralGUI subs;

    
    //CANopen devices panels
    protected CanOpenHardwarePanel hardwarePanel;
    protected EPOSControllerPanel linearRailMasterControllerPanel;
    protected EPOSControllerPanel linearRailSlaveControllerPanel;
    protected EPOSControllerPanel latchXminusControllerPanel;
    protected EPOSControllerPanel latchXplusControllerPanel;
    protected EPOSControllerPanel onlineClampXminusControllerPanel;
    protected EPOSControllerPanel onlineClampXplusControllerPanel;
    protected EPOSControllerPanel onlineClampZControllerPanel;
    protected PlutoGatewayPanel plutoGatewayPanel;
    
    //Exchanger hardware panels
    protected AutochangerThreeOnlineClampsPanel onlineClampsPanel;
    AutochangerMainPanel autochangerMainPanel;
    AutochangerTrucksPanel acTrucksPanel = new AutochangerTrucksPanel();
    AutochangerTwoLatchesPanel acLatchesPanel = new AutochangerTwoLatchesPanel();
    AutochangerThreeOnlineClampsPanel acClampsPanel = new AutochangerThreeOnlineClampsPanel();
    AutochangerGeneralViewPanel acGeneralViewPanel = new AutochangerGeneralViewPanel();

    public AutochangerGatherPanel() {
        initPanels();
    }
    
    public AutochangerGatherPanel(AutochangerGeneralGUI subs) {        
        initPanels();
        this.subs = subs;
        this.autochangerMainPanel.setSubsystem(subs);
        this.acClampsPanel.setSubsystem(subs);
        this.acLatchesPanel.setSubsystem(subs);
        this.acTrucksPanel.setSubsystem(subs);
        this.linearRailMasterControllerPanel.setSubsystem(subs);
        this.linearRailSlaveControllerPanel.setSubsystem(subs);
        this.latchXminusControllerPanel.setSubsystem(subs);
        this.latchXplusControllerPanel.setSubsystem(subs);
        this.onlineClampXminusControllerPanel.setSubsystem(subs);
        this.onlineClampXplusControllerPanel.setSubsystem(subs);
        this.onlineClampZControllerPanel.setSubsystem(subs);
    }

    @Override
    public SubsystemPanel getSubsystemPanel() {
        return this.autochangerMainPanel.getSubsystemPanel();
    }

    public AutochangerMainPanel getAutochangerMainPanel() {
        return autochangerMainPanel;
    }

    public AutochangerTrucksPanel getAcTrucksPanel() {
        return acTrucksPanel;
    }

    public AutochangerTwoLatchesPanel getAcLatchesPanel() {
        return acLatchesPanel;
    }

    public AutochangerThreeOnlineClampsPanel getAcClampsPanel() {
        return acClampsPanel;
    }

    public AutochangerGeneralViewPanel getAcGeneralViewPanel() {
        return acGeneralViewPanel;
    }
    
    

    public CanOpenHardwarePanel getHardwarePanel() {
        return hardwarePanel;
    }

    public EPOSControllerPanel getLinearRailMasterControllerPanel() {
        return linearRailMasterControllerPanel;
    }

    public EPOSControllerPanel getLinearRailSlaveControllerPanel() {
        return linearRailSlaveControllerPanel;
    }

    public EPOSControllerPanel getLatchXminusControllerPanel() {
        return latchXminusControllerPanel;
    }

    public EPOSControllerPanel getLatchXplusControllerPanel() {
        return latchXplusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampXminusControllerPanel() {
        return onlineClampXminusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampXplusControllerPanel() {
        return onlineClampXplusControllerPanel;
    }

    public EPOSControllerPanel getOnlineClampZControllerPanel() {
        return onlineClampZControllerPanel;
    }

    public PlutoGatewayPanel getPlutoGatewayPanel() {
        return plutoGatewayPanel;
    }
    
    

    public void initializeGui(AutochangerConfig autochangerConfig) {
        SwingUtilities.invokeLater(new GuiInitialization(autochangerConfig));
    }
    
            
    /** Initialization of the GUI for data stored in tcpConfiguration. **/
    private  class GuiInitialization implements Runnable {
        
        AutochangerConfig autochangerConfig;
        CanOpenProxyConfig canOpenProxyConfig;
        EPOSControllerConfig lrMasterCtlConfig;
        EPOSControllerConfig lrSlaveCtlConfig;
        EPOSControllerConfig latchXminusCtlConfig;
        EPOSControllerConfig latchXplusCtlConfig;
        EPOSControllerConfig onlineXminusCtlConfig;
        EPOSControllerConfig onlineXplusCtlConfig;
        EPOSControllerConfig onlineZCtlConfig;
        PlutoGatewayConfig gwConfig;

        public GuiInitialization(AutochangerConfig autochangerConfig) {
            this.autochangerConfig = autochangerConfig;
            this.canOpenProxyConfig = autochangerConfig.getTcpProxyConfig();
            this.lrMasterCtlConfig = autochangerConfig.getLinearRailMasterControllerConfig();
            this.lrSlaveCtlConfig = autochangerConfig.getLinearRailSlaveControllerConfig();
            this.latchXminusCtlConfig = autochangerConfig.getLatchXminusControllerConfig();
            this.latchXplusCtlConfig = autochangerConfig.getLatchXplusControllerConfig();
            this.onlineXminusCtlConfig = autochangerConfig.getOnlineClampXminusControllerConfig(); 
            this.onlineXplusCtlConfig = autochangerConfig.getOnlineClampXplusControllerConfig();
            this.onlineZCtlConfig = autochangerConfig.getOnlineClampZControllerConfig();
            this.gwConfig = autochangerConfig.getGwConfig();
            
        }

        @Override
        public void run() {
            
            /** Autochanger Main Panel **/
            autochangerMainPanel.initializeGui(autochangerConfig);
            
            //TODO only if needed
//            /** Autochanger General View Panel **/
//            autochangerGeneralViewPanel.initializeGui(autochangerConfig);
            
            //** Autochanger General View Panel **/
            acGeneralViewPanel.initializeGui(autochangerConfig);
            
            /** Autochanger Clamps Panel **/
            acClampsPanel.initializeGui(autochangerConfig);
            
            /** Autochanger Latches Panel **/
            acLatchesPanel.initializeGui(autochangerConfig);
            
            /** Autochanger Trucks Panel **/
            subs.setTimeoutForTrucksMotion(autochangerConfig.getTrucksConfig().getTimeoutForTrucksMotion());
            acTrucksPanel.initializeGui(autochangerConfig.getTrucksConfig());


            
            /** CANopen hardware list panel **/
            hardwarePanel.initializeGui(canOpenProxyConfig);
            
            /** Linear Rail Master Controller Panel **/
            linearRailMasterControllerPanel.initializeGui(retrieveControllerInfo(canOpenProxyConfig,lrMasterCtlConfig), lrMasterCtlConfig);
            
            /** Linear Rail Slave Controller Panel**/
            linearRailSlaveControllerPanel.initializeGui(retrieveControllerInfo(canOpenProxyConfig,lrSlaveCtlConfig), lrSlaveCtlConfig);

            /** Latch Xminus Controller Panel**/
            fcslog.debug("latchXminusControllerPanel.initializeGui:"+latchXminusCtlConfig.toString());
            latchXminusControllerPanel.initializeGui(retrieveControllerInfo(canOpenProxyConfig,latchXminusCtlConfig), latchXminusCtlConfig);

             /** Latch Xplus Controller Panel**/
            fcslog.debug("latchXplusControllerPanel.initializeGui:"+latchXplusCtlConfig.toString());
            latchXplusControllerPanel.initializeGui(retrieveControllerInfo(canOpenProxyConfig,latchXplusCtlConfig), latchXplusCtlConfig);
            
            
           
            /** Online Clamp Xminus Controller Panel**/
            onlineClampXminusControllerPanel.initializeGui(retrieveControllerInfo(canOpenProxyConfig,onlineXminusCtlConfig), onlineXminusCtlConfig);  
           
            /** Online Clamp Xplus Controller Panel**/
            onlineClampXplusControllerPanel.initializeGui(retrieveControllerInfo(canOpenProxyConfig,onlineXplusCtlConfig), onlineXplusCtlConfig);  
           
            /** Online Clamp Z Controller Panel**/
            onlineClampZControllerPanel.initializeGui(retrieveControllerInfo(canOpenProxyConfig,onlineZCtlConfig), onlineZCtlConfig);  
            
            /** PlutoGateway Panel**/
           plutoGatewayPanel.initializeGui(retrieveDeviceInfo(canOpenProxyConfig,gwConfig.getName()), gwConfig);
           
           /** To initialize GUI when GUI starts after the subsystem.**/
           subs.postInitGui();
        }
    }

    void updateCanOpenHardwarePanel(StatusDataPublishedByHardware s) {
        hardwarePanel.updateCanOpenHardwarePanel(s);
    }

    void updateLinearRailMasterController(StatusDataPublishedByEPOSController s) {
        linearRailMasterControllerPanel.updateController(s);
    }

    void updateLinearRailSlaveController(StatusDataPublishedByEPOSController s) {
        linearRailSlaveControllerPanel.updateController(s);
    }

    void updateLatchXminusController(StatusDataPublishedByEPOSController s) {
        latchXminusControllerPanel.updateController(s);
    }

    void updateLatchXplusController(StatusDataPublishedByEPOSController s) {
        latchXplusControllerPanel.updateController(s);
    }

    void updateOnlineClampXminusController(StatusDataPublishedByEPOSController s) {
        onlineClampXminusControllerPanel.updateController(s);
    }

    void updateOnlineClampXplusController(StatusDataPublishedByEPOSController s) {
        onlineClampXplusControllerPanel.updateController(s);
    }

    void updateOnlineClampZController(StatusDataPublishedByEPOSController s) {
        onlineClampZControllerPanel.updateController(s);
    }
    
    
    void updateClampXminus(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.acClampsPanel.updateClampXminus(s);
    }
    
    void updateClampXplus(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.acClampsPanel.updateClampXplus(s);
    }
    
    void updateClampZ(StatusDataPublishedByAutochangerOnlineClamp s) {
        this.acClampsPanel.updateClampZ(s);
    }
    
    void updateClamps(StatusDataPublishedByAutochangerThreeClamps s) {
        this.acClampsPanel.updateClamps(s);
        this.acGeneralViewPanel.updateClamps(s);
    }
    
    void updateAutochanger(StatusDataPublishedByAutoChanger s) {
        this.autochangerMainPanel.update(s);
        this.acGeneralViewPanel.updateAutochanger(s);
    }

    void updateLatch(StatusDataPublishedByAutochangerLatch s) {
        //this.autochangerMainPanel.updateLatch(s);
        this.acLatchesPanel.updateLatch(s);
    }

    void updateLatches(StatusDataPublishedByAutochangerTwoLatches s) {
        //this.autochangerMainPanel.updateLatches(s);
        this.acLatchesPanel.updateLatches(s);
        this.acGeneralViewPanel.updateLatches(s);
    }

    void updateTrucks(StatusDataPublishedByAutoChangerTrucks s) {
        fcslog.finest(" Data published by Trucks= " + s.toString());
        //this.autochangerMainPanel.updateTrucks(s);
        this.acTrucksPanel.updateTrucks(s);
        this.acGeneralViewPanel.updateTrucks(s);
    }



    
    private void initPanels() {
        //CANopen devices panel
        hardwarePanel = new CanOpenHardwarePanel();       
        //controllers Panels
        linearRailMasterControllerPanel = new EPOSControllerPanel("linearRailMasterController");     
        linearRailSlaveControllerPanel = new EPOSControllerPanel("linearRailSlaveController");
        latchXminusControllerPanel = new EPOSControllerPanel("latchXminusController");
        latchXplusControllerPanel = new EPOSControllerPanel("latchXplusController");
        onlineClampXminusControllerPanel = new EPOSControllerPanel("onlineClampXminusController");
        onlineClampXplusControllerPanel = new EPOSControllerPanel("onlineClampXplusController");
        onlineClampZControllerPanel = new EPOSControllerPanel("onlineClampZController");
        //plutoGatewayPanel
        plutoGatewayPanel = new PlutoGatewayPanel();
        

        acClampsPanel = new AutochangerThreeOnlineClampsPanel();
        acLatchesPanel = new AutochangerTwoLatchesPanel();
        acTrucksPanel = new AutochangerTrucksPanel();
        //autochanger main panel
        autochangerMainPanel = new AutochangerMainPanel();
        autochangerMainPanel.setAcLatchesPanel(acLatchesPanel);
        autochangerMainPanel.setAcTrucksPanel(acTrucksPanel);
    }
    
}
