/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Arc2D;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DigitalSwitch
extends JPanel {
    private int size = 20;
    private Color color = new Color(0, 153, 0);

    public DigitalSwitch() {
        this.initComponents();
        this.setSize(this.size);
    }

    public void setSize(int size) {
        this.size = size;
        super.setPreferredSize(new Dimension(size, size));
    }

    @Override
    public void setBackground(Color bg) {
        this.setColor(bg);
    }

    public void setColor(Color c) {
        this.color = c;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.addRenderingHints(hints);
        float width = this.size;
        float height = this.size;
        float actualWidth = Math.min(width, height);
        float border = 1.0f;
        Arc2D.Double circle = new Arc2D.Double(border, border, actualWidth - 2.0f * border, actualWidth - 2.0f * border, 0.0, 360.0, 1);
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(this.color);
        g2.fill(circle);
        g2.setColor(Color.black);
        g2.draw(circle);
    }

    public static void main(String[] argv) {
        DigitalSwitch d = new DigitalSwitch();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

