/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.clamp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.config.SingleFilterTestConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.clamp.ClampsTableModel;

public class CarouselTablePanel
extends JPanel {
    static final Font myFont = new Font("Helvetica", 0, 12);
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public CarouselTablePanel() {
        this.initComponents();
        JTableHeader hdr = this.jTable1.getTableHeader();
        hdr.setReorderingAllowed(false);
        hdr.setSize(hdr.getWidth(), hdr.getHeight() + 2);
        this.jTable1.setAutoResizeMode(3);
        this.jTable1.setRowSelectionAllowed(false);
        this.jTable1.setDefaultRenderer(Object.class, new CarouselCellRenderer());
        this.jTable1.setDefaultRenderer(Double.class, new CarouselCellRenderer());
        this.jTable1.setColumnSelectionAllowed(false);
        this.jTable1.setFont(myFont);
        this.jTable1.setRowHeight(this.jTable1.getRowHeight() + 2);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setLayout(new BoxLayout(this, 2));
        this.jTable1.setModel(new ClampsTableModel());
        this.jScrollPane1.setViewportView(this.jTable1);
        this.add(this.jScrollPane1);
    }

    public void createTableRows(SingleFilterTestConfig status) {
        SwingUtilities.invokeLater(new CreateCarouselTableRows(status));
    }

    class CarouselCellRenderer
    extends DefaultTableCellRenderer {
        CarouselCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ClampsTableModel model = (ClampsTableModel)table.getModel();
            if (column == 2 || column == 3) {
                String lockStatus = (String)model.getValueAt(row, 2);
                if (lockStatus.equals(FcsEnumerations.LockStatus.ERROR.toString())) {
                    c.setBackground(Color.red);
                } else if (lockStatus.equals(FcsEnumerations.LockStatus.LOCKED.toString())) {
                    c.setBackground(Color.green);
                } else if (lockStatus.equals(FcsEnumerations.LockStatus.UNKNOWN.toString())) {
                    c.setBackground(Color.orange);
                } else if (lockStatus.equals(FcsEnumerations.LockStatus.UNLOCKED.toString())) {
                    c.setBackground(Color.green);
                } else {
                    c.setBackground(Color.black);
                }
            } else {
                c.setBackground(Color.white);
            }
            return c;
        }
    }

    class CreateCarouselTableRows
    implements Runnable {
        SingleFilterTestConfig s;

        CreateCarouselTableRows(SingleFilterTestConfig s) {
            this.s = s;
        }

        @Override
        public void run() {
            ClampsTableModel model = (ClampsTableModel)CarouselTablePanel.this.jTable1.getModel();
            model.addClamp(this.s.getClampXminusConfig());
            model.addClamp(this.s.getClampXplusConfig());
            int c = 0;
            while (c < CarouselTablePanel.this.jTable1.getColumnCount()) {
                TableColumnModel colModel = CarouselTablePanel.this.jTable1.getColumnModel();
                TableColumn col = colModel.getColumn(c);
                TableCellRenderer rndr = CarouselTablePanel.this.jTable1.getTableHeader().getDefaultRenderer();
                Component comp = rndr.getTableCellRendererComponent(CarouselTablePanel.this.jTable1, col.getHeaderValue(), false, false, 0, 0);
                int width = comp.getPreferredSize().width;
                rndr = CarouselTablePanel.this.jTable1.getCellRenderer(0, c);
                Class<?> colClass = CarouselTablePanel.this.jTable1.getColumnClass(c);
                if (!colClass.equals(String.class)) {
                    comp = colClass.equals(Double.class) ? rndr.getTableCellRendererComponent(CarouselTablePanel.this.jTable1, -999.99, false, false, 0, c) : rndr.getTableCellRendererComponent(CarouselTablePanel.this.jTable1, Float.valueOf(-999.99f), false, false, 0, c);
                    width = Math.max(width, comp.getPreferredSize().width);
                } else {
                    int r = 0;
                    while (r < CarouselTablePanel.this.jTable1.getRowCount()) {
                        Object value = CarouselTablePanel.this.jTable1.getValueAt(r, c);
                        comp = rndr.getTableCellRendererComponent(CarouselTablePanel.this.jTable1, value, false, false, r, c);
                        width = Math.max(width, comp.getPreferredSize().width);
                        ++r;
                    }
                }
                col.setPreferredWidth(width + 4);
                ++c;
            }
        }
    }
}

