/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.FilterExchangeMainPanel;

public class VerticalProgressBar
extends JPanel {
    int minValue = 0;
    int maxValue = 100;
    int valueA = 10;
    int valueB = 20;
    int valueC = 90;
    int height = 100;
    int width = 60;
    int vinsets = 15;
    int hinsets = 10;
    int fullHeightInBins = this.height - this.vinsets - 5;
    int value = 35;
    String position = "left";
    Color backgroundColor = new Color(212, 208, 200);
    Color fillColor = new Color(204, 205, 255);

    public VerticalProgressBar() {
        this.setPreferredSize(new Dimension(this.width, this.height));
    }

    public void setPosition(String position) {
        this.position = position;
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.backgroundColor = bg;
        this.repaint();
    }

    public void setValues(int minValue, int maxValue, int valueA, int valueB, int valueC) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valueA = valueA;
        this.valueB = valueB;
        this.valueC = valueC;
        this.repaint();
    }

    private int convertValue(int value) {
        int fullScale = this.maxValue - this.minValue;
        double binsIncrement = (double)this.fullHeightInBins / (double)fullScale;
        return (int)((double)(value - this.minValue) * binsIncrement);
    }

    public void setValueAndColor(int value, Color c) {
        this.value = value;
        this.fillColor = c;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle fullRectangle = new Rectangle(this.hinsets, this.vinsets, this.width - 2 * this.hinsets, this.fullHeightInBins);
        g2.setColor(this.backgroundColor);
        g2.fill(fullRectangle);
        g2.setColor(FilterExchangeMainPanel.getFilterPresenceColor(FcsEnumerations.FilterPresenceStatus.ERROR.toString()));
        int lineHeight = this.vinsets + this.convertValue(this.valueA);
        g2.drawLine(this.hinsets + 1, lineHeight, this.width - this.hinsets - 1, lineHeight);
        g2.setColor(FilterExchangeMainPanel.getFilterPresenceColor(FcsEnumerations.FilterPresenceStatus.LOCKABLE.toString()));
        lineHeight = this.vinsets + this.convertValue(this.valueB);
        g2.drawLine(this.hinsets + 1, lineHeight, this.width - this.hinsets - 1, lineHeight);
        g2.setColor(FilterExchangeMainPanel.getFilterPresenceColor(FcsEnumerations.FilterPresenceStatus.NOT_LOCKABLE.toString()));
        lineHeight = this.vinsets + this.convertValue(this.valueC);
        g2.drawLine(this.hinsets + 1, lineHeight, this.width - this.hinsets - 1, lineHeight);
        g2.setColor(Color.black);
        g2.draw(fullRectangle);
        g2.setFont(new Font("system", 1, 15));
        String valueStr = String.valueOf(this.value);
        g2.setColor(Color.black);
        Rectangle2D bounds = g2.getFontMetrics().getStringBounds(valueStr, g2);
        g2.drawString(valueStr, (int)((double)(this.width / 2) - bounds.getWidth() / 2.0), this.vinsets - 3);
        g2.setColor(this.fillColor);
        int v = this.convertValue(this.value);
        Rectangle fillRectangle = new Rectangle(this.hinsets + 1, this.vinsets + v, this.width - 2 * this.hinsets - 1, this.fullHeightInBins - v);
        g2.fill(fillRectangle);
        int edge = this.width - this.hinsets + 1;
        int height = this.vinsets + v;
        int[] x = new int[]{edge, edge + 5, edge + 5};
        int[] y = new int[]{height, height + 4, height - 4};
        if (this.position.equals("left")) {
            edge = this.hinsets - 1;
            x = new int[]{edge, edge - 5, edge - 5};
        }
        g2.fillPolygon(x, y, 3);
        g2.setColor(Color.black);
        g2.drawPolygon(x, y, 3);
    }

    public static void main(String[] argv) {
        VerticalProgressBar d = new VerticalProgressBar();
        d.setPosition("right");
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

