/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderClampConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderClampPanel;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGUISubsystem;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.FilterPanel;
import org.lsst.ccs.subsystems.fcs.ui.common.DigitalSwitch;
import org.lsst.ccs.utilities.logging.Logger;

public class LoaderMainPanel
extends JPanel {
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs");
    private LoaderGUISubsystem subs;
    private DigitalSwitch autochangerHoldingFilterDigitalSwitch;
    private JLabel autochangerHoldingFilterSensor;
    private JLabel controlRealHardware;
    private FilterPanel filterPanel1;
    private JDialog jDialog1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private LoaderClampPanel loaderClampPanel;
    private DigitalSwitch onCameraDigitalSwitch;
    private JLabel onCameraLabelName;

    public LoaderMainPanel() {
        this.initComponents();
    }

    public LoaderMainPanel(LoaderGUISubsystem subs) {
        this.subs = subs;
        this.initComponents();
        this.onCameraDigitalSwitch.setColor(Color.gray);
        this.autochangerHoldingFilterDigitalSwitch.setColor(Color.gray);
    }

    public LoaderClampPanel getLoaderClampPanel() {
        return this.loaderClampPanel;
    }

    public void initializeGui(LoaderConfig status) {
        SwingUtilities.invokeLater(new GuiInitialization(status));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateCarrier(StatusDataPublishedByLoaderCarrier statusDataPublishedByLoaderCarrier) {
        SwingUtilities.invokeLater(new UpdateCarrier(statusDataPublishedByLoaderCarrier));
    }

    private void initComponents() {
        this.jDialog1 = new JDialog();
        this.loaderClampPanel = new LoaderClampPanel();
        this.jPanel1 = new JPanel();
        this.filterPanel1 = new FilterPanel();
        this.controlRealHardware = new JLabel();
        this.jPanel4 = new JPanel();
        this.jPanel2 = new JPanel();
        this.onCameraLabelName = new JLabel();
        this.onCameraDigitalSwitch = new DigitalSwitch();
        this.jPanel3 = new JPanel();
        this.autochangerHoldingFilterDigitalSwitch = new DigitalSwitch();
        this.autochangerHoldingFilterSensor = new JLabel();
        GroupLayout jDialog1Layout = new GroupLayout(this.jDialog1.getContentPane());
        this.jDialog1.getContentPane().setLayout(jDialog1Layout);
        jDialog1Layout.setHorizontalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        jDialog1Layout.setVerticalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(255, 255, 0)), "LOADER"));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        this.loaderClampPanel.setLoaderSubsystem(this.subs);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.ipady = 151;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 120, 0, 121);
        this.add((Component)this.loaderClampPanel, gridBagConstraints);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.ipady = 100;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(50, 597, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        GroupLayout filterPanel1Layout = new GroupLayout(this.filterPanel1);
        this.filterPanel1.setLayout(filterPanel1Layout);
        filterPanel1Layout.setHorizontalGroup(filterPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 200, Short.MAX_VALUE));
        filterPanel1Layout.setVerticalGroup(filterPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 200, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.ipady = 200;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 547, 142, 0);
        this.add((Component)this.filterPanel1, gridBagConstraints);
        this.controlRealHardware.setFont(new Font("Lucida Grande", 1, 14));
        this.controlRealHardware.setText("hardwareType");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 597, 0, 0);
        this.add((Component)this.controlRealHardware, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.onCameraLabelName.setText("ON CAMERA SENSOR");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.jPanel2.add((Component)this.onCameraLabelName, gridBagConstraints);
        GroupLayout onCameraDigitalSwitchLayout = new GroupLayout(this.onCameraDigitalSwitch);
        this.onCameraDigitalSwitch.setLayout(onCameraDigitalSwitchLayout);
        onCameraDigitalSwitchLayout.setHorizontalGroup(onCameraDigitalSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        onCameraDigitalSwitchLayout.setVerticalGroup(onCameraDigitalSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.onCameraDigitalSwitch, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(5, 6, 5, 30);
        this.jPanel4.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        GroupLayout autochangerHoldingFilterDigitalSwitchLayout = new GroupLayout(this.autochangerHoldingFilterDigitalSwitch);
        this.autochangerHoldingFilterDigitalSwitch.setLayout(autochangerHoldingFilterDigitalSwitchLayout);
        autochangerHoldingFilterDigitalSwitchLayout.setHorizontalGroup(autochangerHoldingFilterDigitalSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        autochangerHoldingFilterDigitalSwitchLayout.setVerticalGroup(autochangerHoldingFilterDigitalSwitchLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel3.add((Component)this.autochangerHoldingFilterDigitalSwitch, gridBagConstraints);
        this.autochangerHoldingFilterSensor.setText("AUTOCHANGER HOLDING FILTER SENSOR");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(1, 14, 1, 14);
        this.jPanel3.add((Component)this.autochangerHoldingFilterSensor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 768;
        this.jPanel4.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 512;
        this.add((Component)this.jPanel4, gridBagConstraints);
    }

    private class GuiInitialization
    implements Runnable {
        LoaderConfig loaderConfig;

        public GuiInitialization(LoaderConfig aConfig) {
            this.loaderConfig = aConfig;
            LoaderMainPanel.this.controlRealHardware.setText(this.loaderConfig.isRealHardware() ? "Real Hardware" : "Simulation");
        }

        @Override
        public void run() {
            LoaderClampConfig loaderClampConfig = this.loaderConfig.getLoaderClampConfig();
            ((LoaderMainPanel)LoaderMainPanel.this).subs.openHooksTimeout = loaderClampConfig.getTimeoutToOpen();
            ((LoaderMainPanel)LoaderMainPanel.this).subs.closeHooksTimeout = loaderClampConfig.getTimeoutToClose();
            ((LoaderMainPanel)LoaderMainPanel.this).subs.clampHooksTimeout = loaderClampConfig.getTimeoutToClamp();
            ((LoaderMainPanel)LoaderMainPanel.this).subs.homingHooksTimeout = loaderClampConfig.getTimeoutToGoHome();
        }
    }

    class UpdateCarrier
    implements Runnable {
        StatusDataPublishedByLoaderCarrier s;

        public UpdateCarrier(StatusDataPublishedByLoaderCarrier s) {
            this.s = s;
        }

        @Override
        public void run() {
        }
    }

    class UpdateClamp
    implements Runnable {
        StatusDataPublishedByLoaderClamp s;

        UpdateClamp(StatusDataPublishedByLoaderClamp s) {
            this.s = s;
        }

        @Override
        public void run() {
            this.s.getClampState();
            LoaderMainPanel.this.loaderClampPanel.updateClamp(this.s);
        }
    }
}

