/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.HeadlessException;
import java.io.PrintWriter;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import org.freehep.graphicsbase.swing.ErrorDialog;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.DataStatusListener;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderMainPanel;

public class LoaderGUISubsystem
extends Subsystem
implements DataStatusListener {
    private static final String destination = "testbenchLPSC";
    private static final String clampModuleName = "clamp";
    private PrintWriter out = new PrintWriter(System.out, true);
    private final LoaderMainPanel loaderMainPanel = new LoaderMainPanel(this);
    private long lastHeartBeat = 0L;
    private long lastStateRequest = 0L;
    private boolean initialized = false;
    String stateCorrelId;
    JScrollPane pane = new JScrollPane(this.loaderMainPanel);
    long openHooksTimeout = 0L;
    long closeHooksTimeout = 0L;
    long clampHooksTimeout = 0L;
    long homingHooksTimeout = 0L;
    long abortTimeout = 1000L;

    public void initGui() {
        this.setName("LoaderGUIModule");
        this.setListenToStatus(true);
        this.setStatusBroadcastPeriod(0);
        this.start();
    }

    public JComponent getGuiLayout() {
        return this.pane;
    }

    public void resetGui() {
    }

    public static void main(String[] args) {
        LoaderGUISubsystem t = new LoaderGUISubsystem();
        JFrame frame = new JFrame("Loader Subsystem");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }

    protected void testSwingWorker() {
        System.out.println("Hallo");
        new CommandSwingWorker("openHooks", this.openHooksTimeout).execute();
    }

    protected void abortMyDestinationSubsystem() {
        System.out.println("Aborting testbenchLPSC");
        this.sendAsynchronousCommand(new ModuleInvokerCommand("abort", new Object[0]));
    }

    protected void openHooks() {
        log.info((Object)"Opening Hooks", new String[0]);
        log.info((Object)("/timeout=" + this.openHooksTimeout), new String[0]);
        new CommandSwingWorker("openHooks", this.openHooksTimeout).execute();
    }

    protected void closeHooks() {
        log.info((Object)"Closing Hooks", new String[0]);
        System.out.println("/timeout=" + this.closeHooksTimeout);
        new CommandSwingWorker("closeHooks", this.closeHooksTimeout).execute();
    }

    protected void clampHooks() {
        log.info((Object)"Clamping Hooks", new String[0]);
        log.info((Object)("/timeout=" + this.clampHooksTimeout), new String[0]);
        new CommandSwingWorker("clampHooks", this.clampHooksTimeout).execute();
    }

    protected void goToHomePosition() {
        log.info((Object)"Going to Home Position", new String[0]);
        log.info((Object)("/timeout=" + this.homingHooksTimeout), new String[0]);
        new CommandSwingWorker("goToHomePosition", this.homingHooksTimeout, clampModuleName).execute();
    }

    protected void goToClosePosition() {
        log.info((Object)"Going to Close Position", new String[0]);
        log.info((Object)("/timeout=" + this.clampHooksTimeout), new String[0]);
        new CommandSwingWorker("goToClampedPosition", this.clampHooksTimeout, clampModuleName).execute();
    }

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    public void onReply(CommandReply s) {
        if (s.getCorrelId().equals(this.stateCorrelId)) {
            LoaderConfig config = (LoaderConfig)s.getReply();
            log.debug((Object)"--- Got a reply from subs", new String[0]);
            this.loaderMainPanel.initializeGui(config);
            this.initialized = true;
        }
    }

    public void onDataArrival(String source, long timestamp, String dataType, Object s) {
        block14: {
            block12: {
                if (!source.equals(destination)) {
                    return;
                }
                if (!this.initialized) break block12;
                switch (dataType) {
                    case "loaderClamp": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:loaderClamp"), new String[0]);
                        this.loaderMainPanel.updateClamp((StatusDataPublishedByLoaderClamp)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    case "loaderCarrier": {
                        log.debug((Object)(String.valueOf(this.getName()) + " read data dataType:loaderCarrier"), new String[0]);
                        this.loaderMainPanel.updateCarrier((StatusDataPublishedByLoaderCarrier)s);
                        this.lastHeartBeat = timestamp;
                        break;
                    }
                    default: {
                        log.warning((Object)(String.valueOf(this.getName()) + " An unexpected dataType was read on the status bus:" + dataType), new String[0]);
                        break;
                    }
                }
                break block14;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastStateRequest > 2000L) {
                this.lastStateRequest = currentTime;
                ModuleInvokerCommand cmd = new ModuleInvokerCommand("getFullState", new Object[0]);
                this.sendAsynchronousCommand(cmd);
                this.stateCorrelId = cmd.getCorrelId();
            }
        }
    }

    private void sendAsynchronousCommand(ModuleInvokerCommand cmd) {
        cmd.setDestination(destination);
        this.fac.sendCommand((Command)cmd);
    }

    private void sendAsynchronousCommandToModule(String moduleName, ModuleInvokerCommand cmd) {
        String cmdDestination = "testbenchLPSC/" + moduleName;
        System.out.println("destination=" + cmdDestination);
        cmd.setDestination(cmdDestination);
        this.fac.sendCommand((Command)cmd);
    }

    private void sendCommand(ModuleInvokerCommand cmd, long timeout) {
        try {
            cmd.setDestination(destination);
            log.debug((Object)("fac=" + String.valueOf(this.fac)), new String[0]);
            SynchronousCommandAgent agent = new SynchronousCommandAgent(this.fac);
            log.debug((Object)("agent=" + String.valueOf(agent)), new String[0]);
            log.debug((Object)("command=" + String.valueOf(cmd)), new String[0]);
            Object response = agent.invoke((Command)cmd, timeout);
            String strRes = String.valueOf(response);
            log.debug((Object)("strRes=" + strRes), new String[0]);
            if (response == null) {
                strRes = "ok : DONE";
                JOptionPane.showMessageDialog(null, strRes, cmd.getCommand(), 1);
            } else {
                strRes = String.valueOf(response);
                JOptionPane.showMessageDialog(null, strRes, cmd.getCommand(), 1);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), new String[0]);
            JOptionPane.showMessageDialog(null, ex.toString(), "ALERT", 0);
            this.raiseAlarm(ex.toString());
        }
    }

    private Object newSendCommand(ModuleInvokerCommand cmd, String commandDestination, long timeout) {
        try {
            cmd.setDestination(commandDestination);
            log.debug((Object)("fac=" + String.valueOf(this.fac)), new String[0]);
            SynchronousCommandAgent agent = new SynchronousCommandAgent(this.fac);
            log.debug((Object)("agent=" + String.valueOf(agent)), new String[0]);
            log.debug((Object)("command=" + String.valueOf(cmd)), new String[0]);
            Object response = agent.invoke((Command)cmd, timeout);
            String strRes = String.valueOf(response);
            log.debug((Object)("strRes=" + strRes), new String[0]);
            if (response == null) {
                strRes = "ok : DONE";
                return "ok : DONE";
            }
            strRes = String.valueOf(response);
            return strRes;
        }
        catch (Exception ex) {
            return ex;
        }
    }

    private void sendCommandToModule(String moduleName, ModuleInvokerCommand cmd, long timeout) {
        String commandDestination = "testbenchLPSC/" + moduleName;
        System.out.println("destination=" + commandDestination);
        cmd.setDestination(commandDestination);
        this.sendCommand(cmd, timeout);
    }

    private class CommandSwingWorker
    extends SwingWorker<Object, Object> {
        String cmdDestination;
        String cmdName;
        long cmdTimeout;

        public CommandSwingWorker(String cmdN, long timeout) {
            if (cmdN == null) {
                throw new IllegalArgumentException("Command should not be null in CommandSwingWorker");
            }
            if (timeout == 0L) {
                throw new IllegalArgumentException("timeout should not be equal to 0 in CommandSwingWorker");
            }
            this.cmdDestination = LoaderGUISubsystem.destination;
            this.cmdName = cmdN;
            this.cmdTimeout = timeout;
        }

        public CommandSwingWorker(String cmdN, long timeout, String moduleName) {
            if (cmdN == null) {
                throw new IllegalArgumentException("Command should not be null in CommandSwingWorker");
            }
            if (timeout == 0L) {
                throw new IllegalArgumentException("timeout should not be equal to 0 in CommandSwingWorker");
            }
            if (moduleName == null) {
                throw new IllegalArgumentException("moduleName should not be null in this constructor of CommandSwingWorker");
            }
            this.cmdDestination = "testbenchLPSC/" + moduleName;
            this.cmdName = cmdN;
            this.cmdTimeout = timeout;
        }

        @Override
        public Object doInBackground() {
            log.info((Object)("Executing " + this.cmdName + " on " + this.cmdDestination), new String[0]);
            log.info((Object)("/timeout=" + this.cmdTimeout), new String[0]);
            return LoaderGUISubsystem.this.newSendCommand(new ModuleInvokerCommand(this.cmdName, new Object[0]), this.cmdDestination, this.cmdTimeout);
        }

        @Override
        protected void done() {
            try {
                Object response = this.get();
                if (response instanceof Throwable) {
                    log.error((Object)String.valueOf(response), new String[0]);
                    log.error((Object)" command returned error", (Throwable)response, new String[0]);
                    ErrorDialog.showErrorDialog(null, (Object)response.toString(), (Throwable)((Throwable)response));
                    if (!(response instanceof BadCommandException)) {
                        LoaderGUISubsystem.this.raiseAlarm(response.toString());
                    }
                } else if (response == null) {
                    String strRes = "ok : DONE";
                    JOptionPane.showMessageDialog(null, strRes, this.cmdName, 1);
                } else {
                    String strRes = String.valueOf(response);
                    JOptionPane.showMessageDialog(null, strRes, this.cmdName, 1);
                }
            }
            catch (HeadlessException | InterruptedException | ExecutionException ex) {
                log.error((Object)ex.toString(), new String[0]);
                ErrorDialog.showErrorDialog(null, (Object)ex.toString(), (Throwable)ex);
                LoaderGUISubsystem.this.raiseAlarm(ex.toString());
            }
        }
    }
}

