/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderClampConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.loader.ui.HookPanel;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGUISubsystem;
import org.lsst.ccs.subsystems.fcs.loader.ui.VerticalProgressBarClampCurrentPanel;
import org.lsst.ccs.subsystems.fcs.loader.ui.VerticalProgressBarClampPositionPanel;
import org.lsst.ccs.subsystems.fcs.ui.common.Tools;
import org.lsst.ccs.utilities.logging.Logger;

public class LoaderClampPanel
extends JPanel {
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs");
    private LoaderGUISubsystem subs;
    private ButtonGroup buttonGroup1;
    private ButtonGroup buttonGroup2;
    private JButton clampHooksButton;
    private JLabel clampState;
    private JLabel clampStateLabel;
    private JButton closeHooksButton;
    private JButton goToClampedPositionButton;
    private JButton goToHomePositionButton;
    private HookPanel hookPanel1;
    private HookPanel hookPanel2;
    private HookPanel hookPanel3;
    private HookPanel hookPanel4;
    private VerticalProgressBarClampPositionPanel hooksPositionVerticalProgressBarPanel;
    private JButton jButton1;
    private JButton jButtonAbort;
    private JDialog jDialog1;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel22;
    private JLabel jLabel25;
    private JLabel jLabel26;
    private JLabel jLabel27;
    private JLabel jLabel28;
    private JLabel jLabel8;
    private JMenu jMenu1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSeparator jSeparator1;
    private JButton openHooksButton;
    private VerticalProgressBarClampCurrentPanel verticalProgressBarClampCurrentPanel1;

    public LoaderClampPanel() {
        this.initComponents();
        this.clampState.setText("UNKNOWN STATE");
    }

    public void setLoaderSubsystem(LoaderGUISubsystem subs) {
        this.subs = subs;
    }

    public void initializeGui(LoaderConfig status) {
        SwingUtilities.invokeLater(new GuiInitialization(status));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }

    public void updateClamp(HashMap map) {
        SwingUtilities.invokeLater(new UpdateClamp(map));
    }

    private void configureHooksPositionVerticalProgressBarPanel(VerticalProgressBarClampPositionPanel progressPanel, LoaderClampConfig config) {
        progressPanel.setMinPositionValue(config.getMinPosition());
        progressPanel.setMaxPositionValue(config.getMaxPosition());
    }

    private void initComponents() {
        this.jDialog1 = new JDialog();
        this.buttonGroup1 = new ButtonGroup();
        this.jMenu1 = new JMenu();
        this.buttonGroup2 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel22 = new JLabel();
        this.jLabel25 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel26 = new JLabel();
        this.jLabel27 = new JLabel();
        this.jLabel28 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.hookPanel2 = new HookPanel();
        this.hookPanel4 = new HookPanel();
        this.hookPanel3 = new HookPanel();
        this.hookPanel1 = new HookPanel();
        this.clampStateLabel = new JLabel();
        this.clampState = new JLabel();
        this.hooksPositionVerticalProgressBarPanel = new VerticalProgressBarClampPositionPanel();
        this.jPanel3 = new JPanel();
        this.jPanel2 = new JPanel();
        this.openHooksButton = new JButton();
        this.goToClampedPositionButton = new JButton();
        this.clampHooksButton = new JButton();
        this.closeHooksButton = new JButton();
        this.goToHomePositionButton = new JButton();
        this.jButtonAbort = new JButton();
        this.jButton1 = new JButton();
        this.verticalProgressBarClampCurrentPanel1 = new VerticalProgressBarClampCurrentPanel();
        GroupLayout jDialog1Layout = new GroupLayout(this.jDialog1.getContentPane());
        this.jDialog1.getContentPane().setLayout(jDialog1Layout);
        jDialog1Layout.setHorizontalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        jDialog1Layout.setVerticalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.jMenu1.setText("jMenu1");
        this.setBorder(BorderFactory.createTitledBorder("LOADER CLAMP"));
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Tahoma", 1, 18));
        this.jLabel1.setText("X-");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.anchor = 25;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setFont(new Font("Tahoma", 1, 18));
        this.jLabel2.setText("X+");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 24;
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel22.setFont(new Font("Tahoma", 0, 14));
        this.jLabel22.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel22.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel22, gridBagConstraints);
        this.jLabel25.setFont(new Font("Tahoma", 0, 14));
        this.jLabel25.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel25.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 15;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 20;
        gridBagConstraints.fill = 3;
        this.add((Component)this.jLabel25, gridBagConstraints);
        this.jLabel11.setFont(new Font("Tahoma", 1, 18));
        this.jLabel11.setText("X+");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.anchor = 26;
        this.add((Component)this.jLabel11, gridBagConstraints);
        this.jLabel8.setFont(new Font("Tahoma", 1, 18));
        this.jLabel8.setText("X-");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 23;
        this.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel26.setFont(new Font("Tahoma", 0, 14));
        this.jLabel26.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel26.setMaximumSize(new Dimension(100, 2));
        this.jLabel26.setPreferredSize(null);
        this.jLabel26.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 3;
        this.add((Component)this.jLabel26, gridBagConstraints);
        this.jLabel27.setFont(new Font("Tahoma", 0, 14));
        this.jLabel27.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel27.setMaximumSize(new Dimension(100, 2));
        this.jLabel27.setPreferredSize(null);
        this.jLabel27.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jLabel27, gridBagConstraints);
        this.jLabel28.setFont(new Font("Tahoma", 0, 14));
        this.jLabel28.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel28.setPreferredSize(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 20;
        gridBagConstraints.fill = 3;
        this.add((Component)this.jLabel28, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.hookPanel2.setHookName("Hook 2");
        this.hookPanel2.setHookLocation(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.hookPanel2, gridBagConstraints);
        this.hookPanel4.setHookName("Hook 4");
        this.hookPanel4.setHookLocation(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.jPanel1.add((Component)this.hookPanel4, gridBagConstraints);
        this.hookPanel3.setHookName("Hook 3");
        this.hookPanel3.setHookLocation(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.hookPanel3, gridBagConstraints);
        this.hookPanel1.setHookName("Hook 1");
        this.hookPanel1.setHookLocation(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel1.add((Component)this.hookPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 3;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.clampStateLabel.setText("ClampState");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 9;
        this.add((Component)this.clampStateLabel, gridBagConstraints);
        this.clampState.setFont(new Font("Lucida Grande", 1, 14));
        this.clampState.setText("Clamp State");
        this.clampState.setBorder(BorderFactory.createEtchedBorder(new Color(255, 255, 255), new Color(255, 255, 255)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 9;
        this.add((Component)this.clampState, gridBagConstraints);
        this.clampState.getAccessibleContext().setAccessibleName("Unknown State");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(7, 5, 7, 6);
        this.add((Component)this.hooksPositionVerticalProgressBarPanel, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.openHooksButton.setText("Open");
        this.openHooksButton.setToolTipText("");
        this.openHooksButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoaderClampPanel.this.openHooksButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.openHooksButton, gridBagConstraints);
        this.goToClampedPositionButton.setText("Go To Clamped Position");
        this.goToClampedPositionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoaderClampPanel.this.goToClampedPositionButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.goToClampedPositionButton, gridBagConstraints);
        this.clampHooksButton.setText("Clamp");
        this.clampHooksButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoaderClampPanel.this.clampHooksButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.clampHooksButton, gridBagConstraints);
        this.closeHooksButton.setText("Close");
        this.closeHooksButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoaderClampPanel.this.closeHooksButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.closeHooksButton, gridBagConstraints);
        this.goToHomePositionButton.setText("Go To Home Position");
        this.goToHomePositionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoaderClampPanel.this.goToHomePositionButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel2.add((Component)this.goToHomePositionButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel3.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 15;
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.jButtonAbort.setText("Abort");
        this.jButtonAbort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoaderClampPanel.this.abortActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 16;
        this.add((Component)this.jButtonAbort, gridBagConstraints);
        this.jButton1.setText("jButton1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 23;
        this.add((Component)this.jButton1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 8, 0, 6);
        this.add((Component)this.verticalProgressBarClampCurrentPanel1, gridBagConstraints);
    }

    private void openHooksButtonActionPerformed(ActionEvent evt) {
        this.subs.openHooks();
    }

    private void closeHooksButtonActionPerformed(ActionEvent evt) {
        this.subs.closeHooks();
    }

    private void clampHooksButtonActionPerformed(ActionEvent evt) {
        this.subs.clampHooks();
    }

    private void goToHomePositionButtonActionPerformed(ActionEvent evt) {
        this.subs.goToHomePosition();
    }

    private void goToClampedPositionButtonActionPerformed(ActionEvent evt) {
        this.subs.goToClosePosition();
    }

    private void abortActionPerformed(ActionEvent evt) {
        this.subs.abortMyDestinationSubsystem();
    }

    private class GuiInitialization
    implements Runnable {
        LoaderConfig loaderConfig;

        public GuiInitialization(LoaderConfig aConfig) {
            this.loaderConfig = aConfig;
        }

        @Override
        public void run() {
            LoaderClampConfig loaderClampConfig = this.loaderConfig.getLoaderClampConfig();
            LoaderClampPanel.this.configureHooksPositionVerticalProgressBarPanel(LoaderClampPanel.this.hooksPositionVerticalProgressBarPanel, loaderClampConfig);
        }
    }

    class UpdateClamp
    implements Runnable {
        StatusDataPublishedByLoaderClamp s;
        HashMap<String, Object> map;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }

        public UpdateClamp(HashMap<String, Object> aMap) {
            this.map = aMap;
        }

        @Override
        public void run() {
            String clampStateString = this.s.getClampState();
            Color clampStateColor = Tools.getLockSensorColor(clampStateString);
            int clampPosition = this.s.getPosition();
            LoaderClampPanel.this.clampState.setText(clampStateString);
            LoaderClampPanel.this.clampState.setBackground(clampStateColor);
            LoaderClampPanel.this.hooksPositionVerticalProgressBarPanel.setPositionValue(clampPosition, clampStateColor);
            LoaderClampPanel.this.verticalProgressBarClampCurrentPanel1.setCurrentValue(this.s.getCurrent(), Color.BLUE);
            LoaderClampPanel.this.hookPanel1.updateHook(this.s.getStatusPublishedByHook1());
            LoaderClampPanel.this.hookPanel2.updateHook(this.s.getStatusPublishedByHook2());
            LoaderClampPanel.this.hookPanel3.updateHook(this.s.getStatusPublishedByHook3());
            LoaderClampPanel.this.hookPanel4.updateHook(this.s.getStatusPublishedByHook4());
        }
    }
}

