/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderHook;
import org.lsst.ccs.subsystems.fcs.loader.ui.LoaderGUISubsystem;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch;
import org.lsst.ccs.subsystems.fcs.ui.common.Tools;
import org.lsst.ccs.utilities.logging.Logger;

public class HookPanel
extends JPanel {
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystems.fcs");
    protected static final int LEFT = 0;
    protected static final int RIGHT = 1;
    private LoaderGUISubsystem subs;
    private DigitalSwitch hookError;
    private JLabel hookErrorLabel;
    private DigitalSwitch hookLockSensor;
    private JLabel hookLockStatus;
    private JLabel hookName;
    private DigitalSwitch hookUnlockSensor;
    private JDialog jDialog1;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public HookPanel() {
        this.initComponents();
        this.hookUnlockSensor.setColor(Color.gray);
        this.hookLockSensor.setColor(Color.gray);
        this.hookError.setColor(Color.gray);
        this.hookLockStatus.setText("UNKNOWN STATE");
    }

    private void setHookSubsystem(LoaderGUISubsystem subs) {
        this.subs = subs;
    }

    protected void setHookName(String name) {
        this.hookName.setText(name);
    }

    protected void setHookLocation(int pos) {
        switch (pos) {
            case 1: {
                GridBagLayout layout = (GridBagLayout)this.getLayout();
                GridBagConstraints hookNameConst = layout.getConstraints(this.hookName);
                hookNameConst.gridx += 2;
                layout.setConstraints(this.hookName, hookNameConst);
                GridBagConstraints lockedSensorConst = layout.getConstraints(this.hookLockSensor);
                lockedSensorConst.gridx -= 2;
                layout.setConstraints(this.hookLockSensor, lockedSensorConst);
            }
        }
    }

    public void updateHook(StatusDataPublishedByLoaderHook statusDataPublishedByLoaderHook) {
        SwingUtilities.invokeLater(new UpdateHook(statusDataPublishedByLoaderHook));
    }

    public void updateHook(HashMap<String, Object> map) {
        SwingUtilities.invokeLater(new UpdateHook(map));
    }

    private void initComponents() {
        this.jDialog1 = new JDialog();
        this.hookName = new JLabel();
        this.hookUnlockSensor = new DigitalSwitch();
        this.hookLockSensor = new DigitalSwitch();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.hookError = new DigitalSwitch();
        this.hookErrorLabel = new JLabel();
        this.hookLockStatus = new JLabel();
        GroupLayout jDialog1Layout = new GroupLayout(this.jDialog1.getContentPane());
        this.jDialog1.getContentPane().setLayout(jDialog1Layout);
        jDialog1Layout.setHorizontalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        jDialog1Layout.setVerticalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setForeground(new Color(204, 204, 255));
        this.setLayout(new GridBagLayout());
        this.hookName.setText("hook1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 14;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.hookName, gridBagConstraints);
        GroupLayout hookUnlockSensorLayout = new GroupLayout(this.hookUnlockSensor);
        this.hookUnlockSensor.setLayout(hookUnlockSensorLayout);
        hookUnlockSensorLayout.setHorizontalGroup(hookUnlockSensorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        hookUnlockSensorLayout.setVerticalGroup(hookUnlockSensorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        this.add((Component)this.hookUnlockSensor, gridBagConstraints);
        GroupLayout hookLockSensorLayout = new GroupLayout(this.hookLockSensor);
        this.hookLockSensor.setLayout(hookLockSensorLayout);
        hookLockSensorLayout.setHorizontalGroup(hookLockSensorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        hookLockSensorLayout.setVerticalGroup(hookLockSensorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 23, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        this.add((Component)this.hookLockSensor, gridBagConstraints);
        this.jLabel1.setText("<html><P align=\"center\">UNLOCK<br>SENSOR</p></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 6;
        gridBagConstraints.insets = new Insets(0, 7, 0, 7);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("<html><P align=\"center\">LOCK<br>SENSOR</p></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.insets = new Insets(0, 7, 0, 7);
        this.add((Component)this.jLabel2, gridBagConstraints);
        GroupLayout hookErrorLayout = new GroupLayout(this.hookError);
        this.hookError.setLayout(hookErrorLayout);
        hookErrorLayout.setHorizontalGroup(hookErrorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        hookErrorLayout.setVerticalGroup(hookErrorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        this.add((Component)this.hookError, new GridBagConstraints());
        this.hookErrorLabel.setText("ERROR");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 35, 0, 35);
        this.add((Component)this.hookErrorLabel, gridBagConstraints);
        this.hookLockStatus.setFont(new Font("Lucida Grande", 1, 14));
        this.hookLockStatus.setText("hookState");
        this.hookLockStatus.setBorder(BorderFactory.createEtchedBorder(new Color(0, 255, 255), null));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new Insets(0, 18, 0, 18);
        this.add((Component)this.hookLockStatus, gridBagConstraints);
    }

    class UpdateHook
    implements Runnable {
        StatusDataPublishedByLoaderHook s;
        HashMap<String, Object> map;

        public UpdateHook(StatusDataPublishedByLoaderHook statusDataPublishedByLoaderHook) {
            this.s = statusDataPublishedByLoaderHook;
        }

        public UpdateHook(HashMap<String, Object> aMap) {
            this.map = aMap;
        }

        @Override
        public void run() {
            HookPanel.this.hookName.setText(this.s.getName());
            HookPanel.this.hookUnlockSensor.setColor(this.s.getUnlockSensorValue() == 1 ? Tools.greenColor : Color.gray);
            HookPanel.this.hookLockSensor.setColor(this.s.getLockSensorValue() == 1 ? Tools.greenColor : Color.gray);
            HookPanel.this.hookError.setColor(this.s.isInError() ? Color.RED : Tools.greenColor);
            HookPanel.this.hookErrorLabel.setText(this.s.isInError() ? "IN ERROR" : "NO ERROR");
            HookPanel.this.hookLockStatus.setText(this.s.getLockStatusString());
            Color hookLockStatusColor = Tools.getLockSensorColor(this.s.getLockStatusString());
            HookPanel.this.hookLockStatus.setBackground(hookLockStatusColor);
        }
    }
}

