/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import javax.swing.JComponent;

/**
 *
 * @author turri
 */
public final class Switch extends JComponent {

    private String name;

    public Switch() {
        this("");
    }
    
    public Switch(String name) {
        this.name = name;
        setSize(new Dimension(30, 30));
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D) g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.addRenderingHints(hints);

//        float width = getWidth();
//        float height = getHeight();
        float width = 30;
        float height = 30;
        float actualWidth = Math.min(width, height);

        float border = 1;

        // Draw the outline
        Shape circle = new Arc2D.Double(border, border, actualWidth - 2 * border, actualWidth - 2 * border, 0, 360, Arc2D.CHORD);
        g2.setStroke(new BasicStroke(1));
        g2.setColor(Color.red);
        g2.fill(circle);
        g2.setColor(Color.black);
        g2.draw(circle);
        g2.drawString(name, actualWidth * 3 / 4, actualWidth / 2);
    }
}
