/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * DigitalSwitch.java
 *
 * Created on Oct 4, 2012, 2:11:07 AM
 */
package org.lsst.ccs.subsystems.fcs.singlefiltertest.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;

/**
 *
 * @author turri
 */
public class FilterPanel extends javax.swing.JPanel {

    private int size = 200;
    private Color filterOutColor = new Color(153, 153, 153);
    private Color filterInColor = new Color(0, 165, 0);
    private Color filterColor = filterOutColor;
    private String filterString = "";

    /** Creates new form DigitalSwitch */
    public FilterPanel() {
        initComponents();
        setSize(size);
    }

    public void setSize(int size) {
        this.size = size;
        super.setPreferredSize(new Dimension(size, size));
    }

    @Override
    public void setBackground(Color bg) {
        setColor(bg);
    }

    public void setIsFilterInHouse(boolean isFilterIn) {
        if (isFilterIn) {
            filterString = "Filter In";
            setColor(filterInColor);
        } else {
            filterString = "No Filter";
            setColor(filterOutColor);
        }
    }

    public void setColor(Color c) {
        this.filterColor = c;
        repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.addRenderingHints(hints);

//        float width = getWidth();
//        float height = getHeight();
        float width = size;
        float height = size;
        float actualWidth = Math.min(width, height);

        float border = 1;

        // Draw the outline
        Shape outerCircle = new Arc2D.Double(border, border, actualWidth - 2 * border, actualWidth - 2 * border, 0, 360, Arc2D.CHORD);
        g2.setStroke(new BasicStroke(1));
        g2.setColor(Color.gray);
        g2.fill(outerCircle);
        g2.setColor(Color.black);
        g2.draw(outerCircle);

        actualWidth = actualWidth - 20;
        Arc2D filterCircle = new Arc2D.Double(border + 10, border + 10, actualWidth - 2 * border, actualWidth - 2 * border, 0, 360, Arc2D.CHORD);
        g2.setStroke(new BasicStroke(1));
        g2.setColor(filterColor);
        g2.fill(filterCircle);
        g2.setColor(Color.black);
        g2.draw(filterCircle);

        String msg = filterString;
        if (!"".equals(msg)) {
            g2.setFont(new Font("system", Font.BOLD, 20));
            Rectangle2D bounds = g2.getFontMetrics().getStringBounds(msg, g2);
            g2.drawString(msg, (int) ((getWidth() - bounds.getWidth()) / 2), (int)(getHeight()+bounds.getHeight()/2) / 2);
        }



    }

    public static void main(String[] argv) {

        FilterPanel d = new FilterPanel();
        JFrame frame = new JFrame("Test");
        frame.setContentPane(d);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
