/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * FilterExchangeMainPanel.java
 *
 * Created on Oct 3, 2012, 12:45:05 AM
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderClampConfig;
import org.lsst.ccs.utilities.logging.Logger;
/**
 *
 * @author Francoise
 */
public class LoaderMainPanel extends javax.swing.JPanel {

    protected static final Logger log = Logger.getLogger("org.lsst.ccs.subsystems.fcs");
    
    private LoaderGUISubsystem subs;

    
    /** Creates new form LoaderMainPanel */
    public LoaderMainPanel() {
        initComponents();
        

    }

    public LoaderMainPanel(LoaderGUISubsystem subs) {        
        this.subs = subs;       
        initComponents();
        onCameraDigitalSwitch.setColor(Color.gray);
        autochangerHoldingFilterDigitalSwitch.setColor(Color.gray);
    }

    public LoaderClampPanel getLoaderClampPanel() {
        return loaderClampPanel;
    }
    

    public void initializeGui(LoaderConfig status) {
        SwingUtilities.invokeLater(new GuiInitialization(status));
    }


    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }


    public void updateCarrier(StatusDataPublishedByLoaderCarrier statusDataPublishedByLoaderCarrier) {
        SwingUtilities.invokeLater(new UpdateCarrier(statusDataPublishedByLoaderCarrier));
    }
    

    
    
      private class GuiInitialization implements Runnable {
        
        LoaderConfig loaderConfig;

        public GuiInitialization(LoaderConfig aConfig) {
            this.loaderConfig = aConfig;
            controlRealHardware.setText(loaderConfig.isRealHardware() ? "Real Hardware" : "Simulation");
            
        }

        @Override
        public void run() {
            
            LoaderClampConfig loaderClampConfig = loaderConfig.getLoaderClampConfig();
            subs.openHooksTimeout = loaderClampConfig.getTimeoutToOpen();
            subs.closeHooksTimeout = loaderClampConfig.getTimeoutToClose();
            subs.clampHooksTimeout = loaderClampConfig.getTimeoutToClamp();
            subs.homingHooksTimeout = loaderClampConfig.getTimeoutToGoHome();
        }
    }

      
    class UpdateCarrier implements Runnable {
        
        
        StatusDataPublishedByLoaderCarrier s;
        
        public UpdateCarrier(StatusDataPublishedByLoaderCarrier s) {
            this.s = s;
        }

        @Override
        public void run() {
            //TODO
        }
    }


    
    
    class UpdateClamp implements Runnable {

        StatusDataPublishedByLoaderClamp s;

        UpdateClamp(StatusDataPublishedByLoaderClamp s) {
            this.s = s;
        }
        

        @Override
        public void run() {

            String clampState = s.getClampState();
            loaderClampPanel.updateClamp(s);
            
        }
    }



    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jDialog1 = new javax.swing.JDialog();
        loaderClampPanel = new org.lsst.ccs.subsystems.fcs.loader.ui.LoaderClampPanel();
        jPanel1 = new javax.swing.JPanel();
        filterPanel1 = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.FilterPanel();
        controlRealHardware = new javax.swing.JLabel();
        jPanel4 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        onCameraLabelName = new javax.swing.JLabel();
        onCameraDigitalSwitch = new org.lsst.ccs.subsystems.fcs.ui.common.DigitalSwitch();
        jPanel3 = new javax.swing.JPanel();
        autochangerHoldingFilterDigitalSwitch = new org.lsst.ccs.subsystems.fcs.ui.common.DigitalSwitch();
        autochangerHoldingFilterSensor = new javax.swing.JLabel();

        javax.swing.GroupLayout jDialog1Layout = new javax.swing.GroupLayout(jDialog1.getContentPane());
        jDialog1.getContentPane().setLayout(jDialog1Layout);
        jDialog1Layout.setHorizontalGroup(
            jDialog1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        jDialog1Layout.setVerticalGroup(
            jDialog1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );

        setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(255, 255, 0)), "LOADER"));
        setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new java.awt.GridBagLayout());

        loaderClampPanel.setLoaderSubsystem(subs);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.ipady = 151;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 120, 0, 121);
        add(loaderClampPanel, gridBagConstraints);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.ipady = 100;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(50, 597, 0, 0);
        add(jPanel1, gridBagConstraints);

        javax.swing.GroupLayout filterPanel1Layout = new javax.swing.GroupLayout(filterPanel1);
        filterPanel1.setLayout(filterPanel1Layout);
        filterPanel1Layout.setHorizontalGroup(
            filterPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 200, Short.MAX_VALUE)
        );
        filterPanel1Layout.setVerticalGroup(
            filterPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 200, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.ipady = 200;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 547, 142, 0);
        add(filterPanel1, gridBagConstraints);

        controlRealHardware.setFont(new java.awt.Font("Lucida Grande", 1, 14)); // NOI18N
        controlRealHardware.setText("hardwareType");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 597, 0, 0);
        add(controlRealHardware, gridBagConstraints);

        jPanel4.setLayout(new java.awt.GridBagLayout());

        jPanel2.setLayout(new java.awt.GridBagLayout());

        onCameraLabelName.setText("ON CAMERA SENSOR");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 6);
        jPanel2.add(onCameraLabelName, gridBagConstraints);

        javax.swing.GroupLayout onCameraDigitalSwitchLayout = new javax.swing.GroupLayout(onCameraDigitalSwitch);
        onCameraDigitalSwitch.setLayout(onCameraDigitalSwitchLayout);
        onCameraDigitalSwitchLayout.setHorizontalGroup(
            onCameraDigitalSwitchLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );
        onCameraDigitalSwitchLayout.setVerticalGroup(
            onCameraDigitalSwitchLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel2.add(onCameraDigitalSwitch, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        gridBagConstraints.insets = new java.awt.Insets(5, 6, 5, 30);
        jPanel4.add(jPanel2, gridBagConstraints);

        jPanel3.setLayout(new java.awt.GridBagLayout());

        javax.swing.GroupLayout autochangerHoldingFilterDigitalSwitchLayout = new javax.swing.GroupLayout(autochangerHoldingFilterDigitalSwitch);
        autochangerHoldingFilterDigitalSwitch.setLayout(autochangerHoldingFilterDigitalSwitchLayout);
        autochangerHoldingFilterDigitalSwitchLayout.setHorizontalGroup(
            autochangerHoldingFilterDigitalSwitchLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );
        autochangerHoldingFilterDigitalSwitchLayout.setVerticalGroup(
            autochangerHoldingFilterDigitalSwitchLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        jPanel3.add(autochangerHoldingFilterDigitalSwitch, gridBagConstraints);

        autochangerHoldingFilterSensor.setText("AUTOCHANGER HOLDING FILTER SENSOR");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(1, 14, 1, 14);
        jPanel3.add(autochangerHoldingFilterSensor, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.BASELINE_TRAILING;
        jPanel4.add(jPanel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.BASELINE_LEADING;
        add(jPanel4, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private org.lsst.ccs.subsystems.fcs.ui.common.DigitalSwitch autochangerHoldingFilterDigitalSwitch;
    private javax.swing.JLabel autochangerHoldingFilterSensor;
    private javax.swing.JLabel controlRealHardware;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.FilterPanel filterPanel1;
    private javax.swing.JDialog jDialog1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private org.lsst.ccs.subsystems.fcs.loader.ui.LoaderClampPanel loaderClampPanel;
    private org.lsst.ccs.subsystems.fcs.ui.common.DigitalSwitch onCameraDigitalSwitch;
    private javax.swing.JLabel onCameraLabelName;
    // End of variables declaration//GEN-END:variables


}
