/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 *
 * Created on Oct 3, 2012, 12:45:05 AM
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderHook;
import org.lsst.ccs.subsystems.fcs.ui.common.Tools;
import static org.lsst.ccs.subsystems.fcs.ui.common.Tools.greenColor;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author Francoise
 */
public class HookPanel extends javax.swing.JPanel {

    protected static final Logger log = Logger.getLogger("org.lsst.ccs.subsystems.fcs");
    protected static final int LEFT = 0, RIGHT = 1;
    
    private LoaderGUISubsystem subs;

    /**
     * Creates new form LoaderMainPanel
     */
    public HookPanel() {
        initComponents();
        hookUnlockSensor.setColor(Color.gray);
        hookLockSensor.setColor(Color.gray);
        hookError.setColor(Color.gray);
        hookLockStatus.setText("UNKNOWN STATE");
    }
    
    private void setHookSubsystem(LoaderGUISubsystem subs) {
        this.subs = subs;
    }

    protected void setHookName(String name) {
        hookName.setText(name);
    }

    // if we want to inverse the display of the hook for the hooks displayed on the right,
    // we have to do : setHookLocation(RIGHT)
    protected void setHookLocation(int pos) {
        switch (pos) {
            case 1:
                GridBagLayout layout = (GridBagLayout) getLayout();

                // Move the label to the right by two places
                GridBagConstraints hookNameConst = layout.getConstraints(hookName);
                hookNameConst.gridx = hookNameConst.gridx + 2;
                layout.setConstraints(hookName,hookNameConst);

                // Move the locked sensor to the left by two spaces
                GridBagConstraints lockedSensorConst = layout.getConstraints(hookLockSensor);
                lockedSensorConst.gridx = lockedSensorConst.gridx - 2;
                layout.setConstraints(hookLockSensor, lockedSensorConst);
        }
    }

    public void updateHook(StatusDataPublishedByLoaderHook statusDataPublishedByLoaderHook) {
        SwingUtilities.invokeLater(new UpdateHook(statusDataPublishedByLoaderHook));
    }
    
    public void updateHook(HashMap<String, Object> map) {
        SwingUtilities.invokeLater(new UpdateHook(map));
    }

    
    class UpdateHook implements Runnable {

        StatusDataPublishedByLoaderHook s;

        public UpdateHook(StatusDataPublishedByLoaderHook statusDataPublishedByLoaderHook) {
            this.s = statusDataPublishedByLoaderHook;
        }
        
        HashMap<String, Object> map;
        
        public UpdateHook(HashMap<String, Object> aMap) {
            this.map = aMap;
        }

        @Override
        public void run() {
           
            hookName.setText(s.getName());
            hookUnlockSensor.setColor(s.getUnlockSensorValue() == 1 ? greenColor : Color.gray);
            hookLockSensor.setColor(s.getLockSensorValue() == 1 ? greenColor : Color.gray);
            hookError.setColor(s.isInError() ? Color.RED  : greenColor);
            hookErrorLabel.setText(s.isInError() ? "IN ERROR"  : "NO ERROR");
            hookLockStatus.setText(s.getLockStatusString());
            Color hookLockStatusColor = Tools.getLockSensorColor(s.getLockStatusString());
            hookLockStatus.setBackground(hookLockStatusColor);
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jDialog1 = new javax.swing.JDialog();
        hookName = new javax.swing.JLabel();
        hookUnlockSensor = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch();
        hookLockSensor = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        hookError = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch();
        hookErrorLabel = new javax.swing.JLabel();
        hookLockStatus = new javax.swing.JLabel();

        javax.swing.GroupLayout jDialog1Layout = new javax.swing.GroupLayout(jDialog1.getContentPane());
        jDialog1.getContentPane().setLayout(jDialog1Layout);
        jDialog1Layout.setHorizontalGroup(
            jDialog1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        jDialog1Layout.setVerticalGroup(
            jDialog1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );

        setBorder(javax.swing.BorderFactory.createEtchedBorder());
        setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new java.awt.GridBagLayout());

        hookName.setText("hook1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 14;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 6);
        add(hookName, gridBagConstraints);

        javax.swing.GroupLayout hookUnlockSensorLayout = new javax.swing.GroupLayout(hookUnlockSensor);
        hookUnlockSensor.setLayout(hookUnlockSensorLayout);
        hookUnlockSensorLayout.setHorizontalGroup(
            hookUnlockSensorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 23, Short.MAX_VALUE)
        );
        hookUnlockSensorLayout.setVerticalGroup(
            hookUnlockSensorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 23, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        add(hookUnlockSensor, gridBagConstraints);

        javax.swing.GroupLayout hookLockSensorLayout = new javax.swing.GroupLayout(hookLockSensor);
        hookLockSensor.setLayout(hookLockSensorLayout);
        hookLockSensorLayout.setHorizontalGroup(
            hookLockSensorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 23, Short.MAX_VALUE)
        );
        hookLockSensorLayout.setVerticalGroup(
            hookLockSensorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 23, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 3;
        add(hookLockSensor, gridBagConstraints);

        jLabel1.setText("<html><P align=\"center\">UNLOCK<br>SENSOR</p></html>");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 6;
        gridBagConstraints.insets = new java.awt.Insets(0, 7, 0, 7);
        add(jLabel1, gridBagConstraints);

        jLabel2.setText("<html><P align=\"center\">LOCK<br>SENSOR</p></html>");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 7;
        gridBagConstraints.insets = new java.awt.Insets(0, 7, 0, 7);
        add(jLabel2, gridBagConstraints);

        javax.swing.GroupLayout hookErrorLayout = new javax.swing.GroupLayout(hookError);
        hookError.setLayout(hookErrorLayout);
        hookErrorLayout.setHorizontalGroup(
            hookErrorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );
        hookErrorLayout.setVerticalGroup(
            hookErrorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 20, Short.MAX_VALUE)
        );

        add(hookError, new java.awt.GridBagConstraints());

        hookErrorLabel.setText("ERROR");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 35, 0, 35);
        add(hookErrorLabel, gridBagConstraints);

        hookLockStatus.setFont(new java.awt.Font("Lucida Grande", 1, 14)); // NOI18N
        hookLockStatus.setText("hookState");
        hookLockStatus.setBorder(javax.swing.BorderFactory.createEtchedBorder(new java.awt.Color(0, 255, 255), null));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 18, 0, 18);
        add(hookLockStatus, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch hookError;
    private javax.swing.JLabel hookErrorLabel;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch hookLockSensor;
    private javax.swing.JLabel hookLockStatus;
    private javax.swing.JLabel hookName;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.DigitalSwitch hookUnlockSensor;
    private javax.swing.JDialog jDialog1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    // End of variables declaration//GEN-END:variables

}
