/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.lsst.ccs.subsystems.fcs.ui.utils;

import java.util.HashMap;
import org.lsst.ccs.bus.KVList;
import org.lsst.ccs.bus.KeyData;
import org.lsst.ccs.utilities.beanutils.Optional;

/**
 *
 * @author virieux
 */
public class FcsGuiUtils {

    /*
     * Provide a hash map from a KVList to make the processing of the KVList easiest.
     */
    public static HashMap<String, Object> getMapFromKVList(KVList kvl) {
        HashMap<String, Object> map = new HashMap<>();
        String theName = null;
        for (KeyData keyData : kvl) {
            String key = keyData.getKey();
            Optional<Object> optional = keyData.getValue();
            if (optional.isPresent()) {
                if (theName == null) {
                    String[] words = key.split("/");
                    if (words.length > 1) {
                        theName = words[0];
                        map.put("name", theName);
                        //Subsystem.log.debug("Module name=" + theName);
                    }
                }
                map.put(key, optional.get());
                //Subsystem.log.debug("map KEY=" + key + "# map VALUE=" + optional.get().toString());
            } else {
                //Subsystem.log.error("No object associated with key=" + key);
            }
        }
        return map;
    }
    
}
