/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * FilterExchangeMainPanel.java
 *
 * Created on Oct 3, 2012, 12:45:05 AM
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderClampConfig;
import org.lsst.ccs.utilities.logging.Logger;
/**
 *
 * @author Francoise
 */
public class LoaderMainPanel extends javax.swing.JPanel {

    protected static final Logger log = Logger.getLogger("org.lsst.ccs.subsystems.fcs");
    
    private LoaderGUISubsystem subs;

    
    /** Creates new form LoaderMainPanel */
    public LoaderMainPanel() {
        initComponents();

    }

    public LoaderMainPanel(LoaderGUISubsystem subs) {        
        this.subs = subs;       
        initComponents();   
    }

    public LoaderClampPanel getLoaderClampPanel() {
        return loaderClampPanel;
    }
    

    public void initializeGui(LoaderConfig status) {
        SwingUtilities.invokeLater(new GuiInitialization(status));
    }


    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }


    public void updateCarrier(StatusDataPublishedByLoaderCarrier statusDataPublishedByLoaderCarrier) {
        SwingUtilities.invokeLater(new UpdateCarrier(statusDataPublishedByLoaderCarrier));
    }
    

    
    
      private class GuiInitialization implements Runnable {
        
        LoaderConfig loaderConfig;

        public GuiInitialization(LoaderConfig aConfig) {
            this.loaderConfig = aConfig;
            controlRealHardware.setText(loaderConfig.isRealHardware() ? "Real Hardware" : "Simulation");
        }

        @Override
        public void run() {
            
            LoaderClampConfig loaderClampConfig = loaderConfig.getLoaderClampConfig();
            subs.openHooksTimeout = loaderClampConfig.getTimeoutToOpen();
            subs.closeHooksTimeout = loaderClampConfig.getTimeoutToClose();
            subs.clampHooksTimeout = loaderClampConfig.getTimeoutToClamp();
            subs.homingHooksTimeout = loaderClampConfig.getTimeoutToGoHome();
        }
    }

      
    class UpdateCarrier implements Runnable {
        
        
        StatusDataPublishedByLoaderCarrier s;
        
        public UpdateCarrier(StatusDataPublishedByLoaderCarrier s) {
            this.s = s;
        }

        @Override
        public void run() {
            //TODO
        }
    }


    
    
    class UpdateClamp implements Runnable {

        StatusDataPublishedByLoaderClamp s;

        UpdateClamp(StatusDataPublishedByLoaderClamp s) {
            this.s = s;
        }
        

        @Override
        public void run() {

            String clampState = s.getClampState();
            loaderClampPanel.updateClamp(s);
            
        }
    }



    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jDialog1 = new javax.swing.JDialog();
        loaderClampPanel = new org.lsst.ccs.subsystems.fcs.loader.ui.LoaderClampPanel();
        jPanel1 = new javax.swing.JPanel();
        filterPanel1 = new org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.FilterPanel();
        controlRealHardware = new javax.swing.JLabel();

        javax.swing.GroupLayout jDialog1Layout = new javax.swing.GroupLayout(jDialog1.getContentPane());
        jDialog1.getContentPane().setLayout(jDialog1Layout);
        jDialog1Layout.setHorizontalGroup(
            jDialog1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        jDialog1Layout.setVerticalGroup(
            jDialog1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );

        setBorder(javax.swing.BorderFactory.createEtchedBorder());
        setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new java.awt.GridBagLayout());

        loaderClampPanel.setLoaderSubsystem(subs);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        add(loaderClampPanel, gridBagConstraints);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        add(jPanel1, gridBagConstraints);

        javax.swing.GroupLayout filterPanel1Layout = new javax.swing.GroupLayout(filterPanel1);
        filterPanel1.setLayout(filterPanel1Layout);
        filterPanel1Layout.setHorizontalGroup(
            filterPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 200, Short.MAX_VALUE)
        );
        filterPanel1Layout.setVerticalGroup(
            filterPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 200, Short.MAX_VALUE)
        );

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        add(filterPanel1, gridBagConstraints);

        controlRealHardware.setFont(new java.awt.Font("Lucida Grande", 1, 14)); // NOI18N
        controlRealHardware.setText("controlRealHardware");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        add(controlRealHardware, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel controlRealHardware;
    private org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.FilterPanel filterPanel1;
    private javax.swing.JDialog jDialog1;
    private javax.swing.JPanel jPanel1;
    private org.lsst.ccs.subsystems.fcs.loader.ui.LoaderClampPanel loaderClampPanel;
    // End of variables declaration//GEN-END:variables


}
