package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.HeadlessException;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import javax.swing.JScrollPane;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.ModuleInvokerCommand;

import javax.swing.*;
import java.io.PrintWriter;
import java.util.concurrent.ExecutionException;
import org.freehep.graphicsbase.swing.ErrorDialog;
import org.lsst.ccs.bus.DataStatusListener;
import org.lsst.ccs.bus.BadCommandException;
import org.lsst.ccs.bus.utils.SynchronousCommandAgent;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderCarrier;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;

/**
 *
 * @author F
 */
public class LoaderGUISubsystem extends Subsystem implements DataStatusListener {

    private static final String destination = "testbenchLPSC";
    private static final String clampModuleName = "clamp";
    private PrintWriter out = new PrintWriter(System.out, true);
    private final LoaderMainPanel loaderMainPanel;
    private long lastHeartBeat = 0, lastStateRequest = 0;
    private boolean initialized = false;
    String stateCorrelId;
    JScrollPane pane;
    
    //actions timeout
    long openHooksTimeout;
    long closeHooksTimeout;
    long clampHooksTimeout;
    long homingHooksTimeout;
    long abortTimeout;
    
    /**
     * To send command which takes time from a JButton.
    */
    private class CommandSwingWorker extends SwingWorker<Object, Object> {
       String cmdDestination;
       String cmdName;
       long cmdTimeout;
       
       public CommandSwingWorker(String cmdN, long timeout) {
           super();
           if (cmdN == null) throw new IllegalArgumentException("Command should not be null in CommandSwingWorker");
           if (timeout == 0) throw new IllegalArgumentException("timeout should not be equal to 0 in CommandSwingWorker");
           this.cmdDestination = destination;
           this.cmdName = cmdN;
           this.cmdTimeout = timeout;
       }
       
       public CommandSwingWorker(String cmdN, long timeout, String moduleName) {
           super();
           if (cmdN == null) throw new IllegalArgumentException("Command should not be null in CommandSwingWorker");
           if (timeout == 0) throw new IllegalArgumentException("timeout should not be equal to 0 in CommandSwingWorker");      
           if (moduleName == null) throw new IllegalArgumentException("moduleName should not be null in this constructor of CommandSwingWorker");          
           this.cmdDestination = destination + "/" + moduleName;
           this.cmdName = cmdN;
           this.cmdTimeout = timeout;
       }
       
       @Override
       public Object doInBackground() {
           log.info("Executing " + cmdName + " on " + cmdDestination); 
           log.info("/timeout=" + cmdTimeout);
           String key = "";
           int level = 0;
           //should be : new ModuleInvokerCommand(key,level,cmdDestination,cmdName) but ambiguous constructor
           return newSendCommand(new ModuleInvokerCommand(cmdName),cmdDestination,cmdTimeout);
       }

       @Override
       protected void done() {
           try {
               Object response = get();
               String strRes;
               if (response instanceof Throwable) {
                    log.error(String.valueOf(response));
//                    JOptionPane.showMessageDialog(null, response.toString(), "ALERT", JOptionPane.ERROR_MESSAGE);
                      log.error(" command returned error",(Throwable) response); 
                        //ErrorDialog.showErrorDialog(null,"Command returned error",(Throwable) response);
                      ErrorDialog.showErrorDialog(null,response.toString(),(Throwable) response);
                      if (!(response instanceof BadCommandException)) raiseAlarm(response.toString());
               
               } else if (response == null) {
                    strRes = "ok : DONE" ;
                    JOptionPane.showMessageDialog(null, strRes, cmdName,  JOptionPane.INFORMATION_MESSAGE);
                
                } else {
                    strRes = String.valueOf(response);
                    JOptionPane.showMessageDialog(null, strRes, cmdName, JOptionPane.INFORMATION_MESSAGE);
                }
           } catch (InterruptedException | ExecutionException | HeadlessException ex) {
                log.error(ex.toString());
                //JOptionPane.showMessageDialog(null, ex.toString(), "ALERT", JOptionPane.ERROR_MESSAGE);
                ErrorDialog.showErrorDialog(null,ex.toString(),(Throwable) ex);
                raiseAlarm(ex.toString());
           }
       }
    }


    public LoaderGUISubsystem() {
        loaderMainPanel = new LoaderMainPanel(this);
        pane = new JScrollPane(loaderMainPanel);
        openHooksTimeout = 0;
        closeHooksTimeout = 0;
        clampHooksTimeout = 0;
        homingHooksTimeout = 0; 
        abortTimeout = 1000;
    }

    public void initGui() {
        setName("LoaderGUIModule");        
        setListenToStatus(true);
        setStatusBroadcastPeriod(0);
        start();
    }

    public JComponent getGuiLayout() {
        return pane;
    }

    public void resetGui() {
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        LoaderGUISubsystem t = new LoaderGUISubsystem();

        JFrame frame = new JFrame("Loader Subsystem");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

    protected void testSwingWorker() {
        System.out.println("Hallo");
        new CommandSwingWorker("openHooks",this.openHooksTimeout).execute();
    }
    
    protected void abortMyDestinationSubsystem() {
        System.out.println("Aborting " + destination);
        sendAsynchronousCommand(new ModuleInvokerCommand("abort"));
        
//        //just for tests
//        new CommandSwingWorker("abort",abortTimeout,clampModuleName).execute();
        
        //This does not work properly because the abort method return code is void so it
        //always opens a JOPtionPane with ok : DONE
        //new CommandSwingWorker("abort",abortTimeout).execute();
    }
    
    protected void openHooks() {
        log.info("Opening Hooks"); log.info("/timeout=" + openHooksTimeout);
        new CommandSwingWorker("openHooks",openHooksTimeout).execute();
        //sendCommand(new ModuleInvokerCommand("openHooks"),openHooksTimeout);
    }
    
    protected void closeHooks() {
        log.info("Closing Hooks");System.out.println("/timeout=" + closeHooksTimeout); 
        //sendCommand(new ModuleInvokerCommand("closeHooks"),closeHooksTimeout);
        new CommandSwingWorker("closeHooks",this.closeHooksTimeout).execute();
    }

    protected void clampHooks() {
        log.info("Clamping Hooks");log.info("/timeout=" + clampHooksTimeout);
        new CommandSwingWorker("clampHooks",this.clampHooksTimeout).execute();
        //sendCommand(new ModuleInvokerCommand("clampHooks"),clampHooksTimeout);
    }
    
    //TODO move this method to LoaderClampPanel
    protected void goToHomePosition() {
        log.info("Going to Home Position");log.info("/timeout=" + homingHooksTimeout);
        new CommandSwingWorker("goToHomePosition",this.homingHooksTimeout, clampModuleName).execute();
        //sendCommandToModule(clampModuleName,new ModuleInvokerCommand("goToHomePosition"),homingHooksTimeout);
    }
    
    //TODO move this method to LoaderClampPanel
    protected void goToClosePosition() {
        log.info("Going to Close Position");log.info("/timeout=" + clampHooksTimeout);
        new CommandSwingWorker("goToClampedPosition",this.clampHooksTimeout,clampModuleName).execute();
        //        sendCommandToModule(clampModuleName,new ModuleInvokerCommand("goToClampedPosition"),clampHooksTimeout);
    }
    
    
    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void onReply(CommandReply s) {
        //FIXME temporary fix to prevent multiple GUIs from interfering with each other.
        //See https://jira.slac.stanford.edu/browse/LSSTCCS-9
        if (s.getCorrelId().equals(stateCorrelId)) {
            
            //This is the first Status Message after the GUI has started
            LoaderConfig config = (LoaderConfig) s.getReply();
            log.debug("--- Got a reply from subs");
            loaderMainPanel.initializeGui(config);
            initialized = true;
        }
    }
    
    @Override
    public void onDataArrival(String source, long timestamp, String dataType, Object s) {
         //If this data status is not for us we forget it.
        if (!source.equals(destination)) return;
        if (initialized) {
            switch (dataType){
                            case "loaderClamp":
                                log.debug(getName() + " read data dataType:loaderClamp");
                                loaderMainPanel.updateClamp((StatusDataPublishedByLoaderClamp) s);
                                lastHeartBeat = timestamp;
                                break;
                                
                            case "loaderCarrier":
                                log.debug(getName() + " read data dataType:loaderCarrier");
                                loaderMainPanel.updateCarrier((StatusDataPublishedByLoaderCarrier) s);
                                lastHeartBeat = timestamp;
                                break;
                                                             
                            default:
                                log.warning(getName() + " An unexpected dataType was read on the status bus:" + dataType);
                                break;
                            
                        }
        } else {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastStateRequest > 2000) {
                lastStateRequest = currentTime;
                ModuleInvokerCommand cmd = new ModuleInvokerCommand("getFullState");
                sendAsynchronousCommand(cmd);
                stateCorrelId = cmd.getCorrelId();
            }
        }
    }
    


    private void sendAsynchronousCommand(ModuleInvokerCommand cmd) {
        cmd.setDestination(destination);
        fac.sendCommand(cmd);
    }
    
    private void sendAsynchronousCommandToModule(String moduleName, ModuleInvokerCommand cmd) {
        String cmdDestination = LoaderGUISubsystem.destination + "/" + moduleName;
        System.out.println("destination=" + cmdDestination);
        cmd.setDestination(cmdDestination);
        fac.sendCommand(cmd);
    }
    
    /**
     * Send a synchronous command to the subsystem this GUI is made for 
     * and analyse the response.
     * Display the response with a popup window (JOptionPane).
     * @param cmd
     * @param timeout 
     */
    private void sendCommand(ModuleInvokerCommand cmd, long timeout) {
        try {
            cmd.setDestination(destination);
            log.debug("fac=" + String.valueOf(fac));
            SynchronousCommandAgent agent = new SynchronousCommandAgent(fac);
            log.debug("agent=" + String.valueOf(agent));           
            log.debug("command=" + String.valueOf(cmd));
            Object response = agent.invoke(cmd, timeout);
            //ask Bernard 
            String strRes = String.valueOf(response);
            log.debug("strRes=" + strRes);
            if (response == null) {
                strRes = "ok : DONE" ;
                JOptionPane.showMessageDialog(null, strRes, cmd.getCommand(),  JOptionPane.INFORMATION_MESSAGE);
                
            } else {
                strRes = String.valueOf(response);
                JOptionPane.showMessageDialog(null, strRes, cmd.getCommand(), JOptionPane.INFORMATION_MESSAGE);
            }
        } catch (Exception ex) {
                log.error(ex.getMessage());
                JOptionPane.showMessageDialog(null, ex.toString(), "ALERT", JOptionPane.ERROR_MESSAGE);
                this.raiseAlarm(ex.toString());
        }
        
    }
    
    private Object newSendCommand(ModuleInvokerCommand cmd, String commandDestination, long timeout)  {
        try {    
            cmd.setDestination(commandDestination);
            log.debug("fac=" + String.valueOf(fac));
            SynchronousCommandAgent agent = new SynchronousCommandAgent(fac);
            log.debug("agent=" + String.valueOf(agent));           
            log.debug("command=" + String.valueOf(cmd));
            Object response = agent.invoke(cmd, timeout);
            //ask Bernard 
            String strRes = String.valueOf(response);
            log.debug("strRes=" + strRes);
            if (response == null) {
                return strRes = "ok : DONE" ;
                //JOptionPane.showMessageDialog(null, strRes, cmd.getCommand(),  JOptionPane.INFORMATION_MESSAGE);
                
            } else {
                return strRes = String.valueOf(response);
                //JOptionPane.showMessageDialog(null, strRes, cmd.getCommand(), JOptionPane.INFORMATION_MESSAGE);
            }
        } catch (Exception ex) {
            return ex;
        }

        
    }
    
    
    private void sendCommandToModule(String moduleName, ModuleInvokerCommand cmd, long timeout) {
        String commandDestination = destination + "/" + moduleName;
        System.out.println("destination=" + commandDestination);
        cmd.setDestination(commandDestination);
        sendCommand(cmd,timeout);
    }
    




}
