/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * LoaderClampPanel.java
 *
 * Created on April 01, 2014, 12:45:05 AM
 */
package org.lsst.ccs.subsystems.fcs.loader.ui;

import java.awt.Color;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.fcs.StatusDataPublishedByLoaderClamp;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderConfig;
import org.lsst.ccs.subsystems.fcs.loader.config.LoaderClampConfig;
import org.lsst.ccs.subsystems.fcs.singlefiltertest.ui.common.Tools;
//import org.lsst.ccs.utilities.logging.Logger;
/**
 *
 * @author Francoise
 */
public class LoaderClampPanel extends javax.swing.JPanel {
    
    //protected static final Logger log = Logger.getLogger("org.lsst.ccs.subsystems.fcs");
    private LoaderGUISubsystem subs;

    
    /** Creates new form LoaderClampPanel */
    public LoaderClampPanel() {
        initComponents();
        clampState.setText("UNKNOWN STATE");       
    }

    public void setLoaderSubsystem(LoaderGUISubsystem subs) {      
        this.subs = subs;
    }
    
    
    
    
    

    public void initializeGui(LoaderConfig status) {
        SwingUtilities.invokeLater(new GuiInitialization(status));
    }

    public void updateClamp(StatusDataPublishedByLoaderClamp status) {
        SwingUtilities.invokeLater(new UpdateClamp(status));
    }
    
    public void updateClamp(HashMap map) {
        SwingUtilities.invokeLater(new UpdateClamp(map));
    }
    
    private  class GuiInitialization implements Runnable {
        
        LoaderConfig loaderConfig;

        public GuiInitialization(LoaderConfig aConfig) {
            this.loaderConfig = aConfig;
        }

        @Override
        public void run() {
            LoaderClampConfig loaderClampConfig = loaderConfig.getLoaderClampConfig();           
            configureHooksPositionVerticalProgressBarPanel(hooksPositionVerticalProgressBarPanel,loaderClampConfig);
        }
    }
    
    class UpdateClamp implements Runnable {
        
        StatusDataPublishedByLoaderClamp s;

        public UpdateClamp(StatusDataPublishedByLoaderClamp status) {
            this.s = status;
        }
        
        HashMap<String,Object> map;

        public UpdateClamp(HashMap<String,Object> aMap) {
            this.map = aMap;
        }

        @Override
        public void run() {
            
            String clampStateString = s.getClampState();
            Color clampStateColor = Tools.getLockSensorColor(clampStateString);
            int clampPosition = s.getPosition();
            clampState.setText(clampStateString);
            clampState.setBackground(clampStateColor);
            hooksPositionVerticalProgressBarPanel.setPositionValue(clampPosition,clampStateColor);
            hookPanel1.updateHook(s.getStatusPublishedByHook1());
            hookPanel2.updateHook(s.getStatusPublishedByHook2());
            hookPanel3.updateHook(s.getStatusPublishedByHook3());
            hookPanel4.updateHook(s.getStatusPublishedByHook4());
            
        }
    }
  
       
    private void configureHooksPositionVerticalProgressBarPanel(VerticalProgressBarPanel progressPanel, LoaderClampConfig config) {
        progressPanel.setMinPositionValue(config.getMinPosition());
        progressPanel.setMaxPositionValue(config.getMaxPosition());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jDialog1 = new javax.swing.JDialog();
        buttonGroup1 = new javax.swing.ButtonGroup();
        jMenu1 = new javax.swing.JMenu();
        buttonGroup2 = new javax.swing.ButtonGroup();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel22 = new javax.swing.JLabel();
        jLabel25 = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jLabel26 = new javax.swing.JLabel();
        jLabel27 = new javax.swing.JLabel();
        jLabel28 = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        jPanel1 = new javax.swing.JPanel();
        hookPanel2 = new org.lsst.ccs.subsystems.fcs.loader.ui.HookPanel();
        hookPanel4 = new org.lsst.ccs.subsystems.fcs.loader.ui.HookPanel();
        hookPanel3 = new org.lsst.ccs.subsystems.fcs.loader.ui.HookPanel();
        hookPanel1 = new org.lsst.ccs.subsystems.fcs.loader.ui.HookPanel();
        clampStateLabel = new javax.swing.JLabel();
        clampState = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        hooksPositionVerticalProgressBarPanel = new org.lsst.ccs.subsystems.fcs.loader.ui.VerticalProgressBarPanel();
        jPanel3 = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        openHooksButton = new javax.swing.JButton();
        goToClampedPositionButton = new javax.swing.JButton();
        clampHooksButton = new javax.swing.JButton();
        closeHooksButton = new javax.swing.JButton();
        goToHomePositionButton = new javax.swing.JButton();
        jButtonAbort = new javax.swing.JButton();

        javax.swing.GroupLayout jDialog1Layout = new javax.swing.GroupLayout(jDialog1.getContentPane());
        jDialog1.getContentPane().setLayout(jDialog1Layout);
        jDialog1Layout.setHorizontalGroup(
            jDialog1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        jDialog1Layout.setVerticalGroup(
            jDialog1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );

        jMenu1.setText("jMenu1");

        setBorder(javax.swing.BorderFactory.createEtchedBorder());
        setForeground(new java.awt.Color(204, 204, 255));
        setLayout(new java.awt.GridBagLayout());

        jLabel1.setFont(new java.awt.Font("Tahoma", 1, 18)); // NOI18N
        jLabel1.setText("X-");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LAST_LINE_START;
        add(jLabel1, gridBagConstraints);

        jLabel2.setFont(new java.awt.Font("Tahoma", 1, 18)); // NOI18N
        jLabel2.setText("X+");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_END;
        add(jLabel2, gridBagConstraints);

        jLabel22.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        jLabel22.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jLabel22.setPreferredSize(null);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jLabel22, gridBagConstraints);

        jLabel25.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        jLabel25.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jLabel25.setPreferredSize(null);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 15;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 20;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        add(jLabel25, gridBagConstraints);

        jLabel11.setFont(new java.awt.Font("Tahoma", 1, 18)); // NOI18N
        jLabel11.setText("X+");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 14;
        gridBagConstraints.gridy = 23;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.LAST_LINE_END;
        add(jLabel11, gridBagConstraints);

        jLabel8.setFont(new java.awt.Font("Tahoma", 1, 18)); // NOI18N
        jLabel8.setText("X-");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        add(jLabel8, gridBagConstraints);

        jLabel26.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        jLabel26.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jLabel26.setMaximumSize(new java.awt.Dimension(100, 2));
        jLabel26.setPreferredSize(null);
        jLabel26.setRequestFocusEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 3;
        add(jLabel26, gridBagConstraints);

        jLabel27.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        jLabel27.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jLabel27.setMaximumSize(new java.awt.Dimension(100, 2));
        jLabel27.setPreferredSize(null);
        jLabel27.setRequestFocusEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 22;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jLabel27, gridBagConstraints);

        jLabel28.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        jLabel28.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jLabel28.setPreferredSize(null);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 20;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        add(jLabel28, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        add(jSeparator1, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        hookPanel2.setHookName("Hook 2");
        hookPanel2.setHookLocation(HookPanel.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel1.add(hookPanel2, gridBagConstraints);

        hookPanel4.setHookName("Hook 4");
        hookPanel4.setHookLocation(HookPanel.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        jPanel1.add(hookPanel4, gridBagConstraints);

        hookPanel3.setHookName("Hook 3");
        hookPanel3.setHookLocation(HookPanel.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        jPanel1.add(hookPanel3, gridBagConstraints);

        hookPanel1.setHookName("Hook 1");
        hookPanel1.setHookLocation(HookPanel.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel1.add(hookPanel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 3;
        add(jPanel1, gridBagConstraints);

        clampStateLabel.setText("ClampState");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 9;
        add(clampStateLabel, gridBagConstraints);

        clampState.setFont(new java.awt.Font("Lucida Grande", 1, 14)); // NOI18N
        clampState.setText("Clamp State");
        clampState.setBorder(javax.swing.BorderFactory.createEtchedBorder(new java.awt.Color(255, 255, 255), new java.awt.Color(255, 255, 255)));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 9;
        add(clampState, gridBagConstraints);
        clampState.getAccessibleContext().setAccessibleName("Unknown State");

        jLabel3.setText("LOADER CLAMP");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.PAGE_END;
        gridBagConstraints.insets = new java.awt.Insets(0, 1, 0, 1);
        add(jLabel3, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new java.awt.Insets(7, 0, 7, 0);
        add(hooksPositionVerticalProgressBarPanel, gridBagConstraints);

        jPanel3.setLayout(new java.awt.GridBagLayout());

        jPanel2.setLayout(new java.awt.GridBagLayout());

        openHooksButton.setText("Open");
        openHooksButton.setToolTipText("");
        openHooksButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                openHooksButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(openHooksButton, gridBagConstraints);

        goToClampedPositionButton.setText("Go To Clamped Position");
        goToClampedPositionButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                goToClampedPositionButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(goToClampedPositionButton, gridBagConstraints);

        clampHooksButton.setText("Clamp");
        clampHooksButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clampHooksButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(clampHooksButton, gridBagConstraints);

        closeHooksButton.setText("Close");
        closeHooksButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeHooksButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(closeHooksButton, gridBagConstraints);

        goToHomePositionButton.setText("Go To Home Position");
        goToHomePositionButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                goToHomePositionButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(goToHomePositionButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel3.add(jPanel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 15;
        add(jPanel3, gridBagConstraints);

        jButtonAbort.setText("Abort");
        jButtonAbort.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                abortActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 16;
        add(jButtonAbort, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void openHooksButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_openHooksButtonActionPerformed
    
        subs.openHooks();
    }//GEN-LAST:event_openHooksButtonActionPerformed

    private void closeHooksButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeHooksButtonActionPerformed

        subs.closeHooks();
    }//GEN-LAST:event_closeHooksButtonActionPerformed

    private void clampHooksButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clampHooksButtonActionPerformed
        // TODO add your handling code here:
        subs.clampHooks();
    }//GEN-LAST:event_clampHooksButtonActionPerformed

    private void goToHomePositionButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_goToHomePositionButtonActionPerformed
        subs.goToHomePosition();
    }//GEN-LAST:event_goToHomePositionButtonActionPerformed

    private void goToClampedPositionButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_goToClampedPositionButtonActionPerformed
        subs.goToClosePosition();
    }//GEN-LAST:event_goToClampedPositionButtonActionPerformed

    private void abortActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_abortActionPerformed
        // TODO add your handling code here:
        subs.abortMyDestinationSubsystem();
    }//GEN-LAST:event_abortActionPerformed

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.ButtonGroup buttonGroup2;
    private javax.swing.JButton clampHooksButton;
    private javax.swing.JLabel clampState;
    private javax.swing.JLabel clampStateLabel;
    private javax.swing.JButton closeHooksButton;
    private javax.swing.JButton goToClampedPositionButton;
    private javax.swing.JButton goToHomePositionButton;
    private org.lsst.ccs.subsystems.fcs.loader.ui.HookPanel hookPanel1;
    private org.lsst.ccs.subsystems.fcs.loader.ui.HookPanel hookPanel2;
    private org.lsst.ccs.subsystems.fcs.loader.ui.HookPanel hookPanel3;
    private org.lsst.ccs.subsystems.fcs.loader.ui.HookPanel hookPanel4;
    private org.lsst.ccs.subsystems.fcs.loader.ui.VerticalProgressBarPanel hooksPositionVerticalProgressBarPanel;
    private javax.swing.JButton jButtonAbort;
    private javax.swing.JDialog jDialog1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel25;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JLabel jLabel28;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JMenu jMenu1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JButton openHooksButton;
    // End of variables declaration//GEN-END:variables




}
